/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp.ref;

import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.webapp.Servlet;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.util.extension.AbstractPropertyWriter;

public final class ServletPropertyProvider
extends AbstractPropertyWriter {
    public ServletPropertyProvider() {
        this.getPropertyNames().add("$enableGenericCopy");
        this.getPropertyNames().add("$enableGenericCut");
        this.getPropertyNames().add("$enableGenericPaste");
        this.getPropertyNames().add("deployed");
        this.getPropertyNames().add("id");
        this.getPropertyNames().add("description");
        this.getPropertyNames().add("loadOnStartup");
        this.getPropertyNames().add("loadOnStartupOrder");
        this.getPropertyNames().add("displayName");
        this.getPropertyNames().add("smallIcon");
        this.getPropertyNames().add("largeIcon");
        this.getPropertyNames().add("runAsDescription");
        this.getPropertyNames().add("runAsRoleName");
    }

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        if (!WebAppModelMetaInfo.isServlet(element.getUniqueName()) && !WebAppModelMetaInfo.isJsp(element.getUniqueName())) {
            return false;
        }
        return this.getPropertyNames().contains(propertyName);
    }

    public String getPropertyValue(Element element, String propertyName) {
        Servlet servlet = WebAppModelAccess.getServlet(this.getModel(), element.getUniqueName());
        if (servlet == null) {
            return null;
        }
        if ("$enableGenericCopy".equals(propertyName)) {
            return Boolean.TRUE.toString();
        }
        if ("$enableGenericCut".equals(propertyName)) {
            return Boolean.TRUE.toString();
        }
        if ("$enableGenericPaste".equals(propertyName)) {
            return Boolean.TRUE.toString();
        }
        if ("deployed".equals(propertyName)) {
            return Boolean.TRUE.toString();
        }
        if ("id".equals(propertyName)) {
            return servlet.getId();
        }
        if ("description".equals(propertyName)) {
            return servlet.getDescription();
        }
        if ("loadOnStartup".equals(propertyName)) {
            return servlet.isLoadOnStartup() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
        }
        if ("loadOnStartupOrder".equals(propertyName)) {
            Integer order = servlet.getLoadOnStartupOrder();
            return order == null ? null : order.toString();
        }
        if ("displayName".equals(propertyName)) {
            return servlet.getUserInterface().getDisplayName();
        }
        if ("smallIcon".equals(propertyName)) {
            return servlet.getUserInterface().getSmallIcon();
        }
        if ("largeIcon".equals(propertyName)) {
            return servlet.getUserInterface().getLargeIcon();
        }
        if ("runAsDescription".equals(propertyName)) {
            return servlet.getRunAsDescription();
        }
        if ("runAsRoleName".equals(propertyName)) {
            return servlet.getRunAsRoleName();
        }
        return this.unknownProperty(propertyName);
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        Servlet servlet = WebAppModelAccess.getServlet(this.getModel(), element.getUniqueName());
        if (servlet == null) {
            return false;
        }
        if ("id".equals(propertyName)) {
            return servlet.canSetId(propertyValue);
        }
        if ("description".equals(propertyName)) {
            return servlet.canSetDescription(propertyValue);
        }
        if ("loadOnStartup".equals(propertyName)) {
            boolean load = Boolean.valueOf(propertyValue);
            return servlet.canSetLoadOnStartup(load, servlet.getLoadOnStartupOrder());
        }
        if ("loadOnStartupOrder".equals(propertyName)) {
            Integer order;
            if (propertyValue != null && propertyValue.trim().length() > 0) {
                try {
                    order = Integer.valueOf(propertyValue);
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            } else {
                order = null;
            }
            return servlet.canSetLoadOnStartup(servlet.isLoadOnStartup(), order);
        }
        if ("displayName".equals(propertyName)) {
            return servlet.getUserInterface().canSetDisplayName(propertyValue);
        }
        if ("smallIcon".equals(propertyName)) {
            return servlet.getUserInterface().canSetSmallIcon(propertyValue);
        }
        if ("largeIcon".equals(propertyName)) {
            return servlet.getUserInterface().canSetLargeIcon(propertyValue);
        }
        if ("runAsDescription".equals(propertyName)) {
            return servlet.canSetRunAsDescription(propertyValue);
        }
        if ("runAsRoleName".equals(propertyName)) {
            return servlet.canSetRunAsRoleName(propertyValue);
        }
        return false;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        Servlet servlet = WebAppModelAccess.getServlet(this.getModel(), element.getUniqueName());
        if ("id".equals(propertyName)) {
            servlet.setId(propertyValue);
            return;
        }
        if ("description".equals(propertyName)) {
            servlet.setDescription(propertyValue);
            return;
        }
        if ("loadOnStartup".equals(propertyName)) {
            boolean load = Boolean.valueOf(propertyValue);
            servlet.setLoadOnStartup(load, servlet.getLoadOnStartupOrder());
            return;
        }
        if ("loadOnStartupOrder".equals(propertyName)) {
            Integer order = propertyValue != null && propertyValue.trim().length() > 0 ? Integer.valueOf(propertyValue) : null;
            servlet.setLoadOnStartup(servlet.isLoadOnStartup(), order);
            return;
        }
        if ("displayName".equals(propertyName)) {
            servlet.getUserInterface().setDisplayName(propertyValue);
            return;
        }
        if ("smallIcon".equals(propertyName)) {
            servlet.getUserInterface().setSmallIcon(propertyValue);
            return;
        }
        if ("largeIcon".equals(propertyName)) {
            servlet.getUserInterface().setLargeIcon(propertyValue);
            return;
        }
        if ("runAsDescription".equals(propertyName)) {
            servlet.setRunAsDescription(propertyValue);
            return;
        }
        if ("runAsRoleName".equals(propertyName)) {
            servlet.setRunAsRoleName(propertyValue);
            return;
        }
        this.unknownProperty(propertyName);
    }
}

