/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp.ref;

import com.tssap.j2ee.core.descriptor.FakeDescriptorEntity;
import com.tssap.j2ee.core.descriptor.SecurityRole;
import com.tssap.j2ee.core.descriptor.SecurityRoleRef;
import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.webapp.Servlet;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.core.webapp.namegen.SecurityRoleRefNameGen;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ElementEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ExistenceProviderEx;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;

public final class SecurityRoleRefProvider
extends AbstractProvider
implements EntityExistenceProvider,
ExistenceProviderEx,
ChildrenProvider {
    private static final SecurityRole BAD_ROLE = new FakeSecurityRole();

    public boolean isDeleteProviderApplicable(Element element) {
        return WebAppModelMetaInfo.isSecurityRoleRef(element.getUniqueName());
    }

    public boolean isDeleted(Element element) {
        return WebAppModelAccess.getSecurityRoleRef(this.getModel(), element.getUniqueName()) == null;
    }

    public boolean exists(UniqueName uin) {
        if (!WebAppModelMetaInfo.isSecurityRoleRef(uin)) {
            return false;
        }
        return WebAppModelAccess.getSecurityRoleRef(this.getModel(), uin) != null;
    }

    private String genName(Servlet servlet, String name) {
        SecurityRoleRefNameGen gen = new SecurityRoleRefNameGen(servlet);
        return gen.getUniqueName(name == null ? "srRef1" : name);
    }

    private SecurityRole readLink(Entity template) {
        ElementEnumeration roleEnum = template.participants("Supplier");
        if (roleEnum == null || !roleEnum.hasMoreElements()) {
            return null;
        }
        Element roleElement = roleEnum.next();
        UniqueName roleUin = roleElement.getUniqueName();
        if (!WebAppModelMetaInfo.isSecurityRole(roleUin)) {
            return BAD_ROLE;
        }
        return WebAppModelAccess.getSecurityRole(this.getModel(), roleUin);
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        String link;
        if (!"com.tssap.j2ee.core.webapp.SecurityRoleRef".equals(shapeType)) {
            return false;
        }
        if (!WebAppModelMetaInfo.isServlet(parent.getUniqueName()) && !WebAppModelMetaInfo.isJsp(parent.getUniqueName())) {
            return false;
        }
        Servlet servlet = WebAppModelAccess.getServlet(this.getModel(), parent.getUniqueName());
        if (servlet == null) {
            return false;
        }
        WebApp webApp = (WebApp)servlet.getParent();
        if (webApp == null) {
            return false;
        }
        if (template == null) {
            return false;
        }
        Object pastedRole = template.getObjectPropertyValue("$pastedElement");
        Object source = template.getObjectPropertyValue("$elementToClone");
        if (source instanceof Entity) {
            template = (Entity)source;
        }
        String name = this.genName(servlet, template.getPropertyValue("$name"));
        if (pastedRole instanceof Entity) {
            link = ((Entity)pastedRole).getPropertyValue("$name");
        } else {
            link = template.getPropertyValue("roleLink");
            if (link == null) {
                SecurityRole linkedRole = this.readLink(template);
                if (linkedRole == BAD_ROLE) {
                    return false;
                }
                if (linkedRole != null) {
                    link = linkedRole.getName();
                }
            }
        }
        String description = template.getPropertyValue("description");
        return servlet.canCreateSecurityRoleReference(name, link, description);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        String link;
        Servlet servlet = WebAppModelAccess.getServlet(this.getModel(), parent.getUniqueName());
        WebApp webApp = (WebApp)servlet.getParent();
        Object pastedRole = template.getObjectPropertyValue("$pastedElement");
        Object source = template.getObjectPropertyValue("$elementToClone");
        if (source instanceof Entity) {
            template = (Entity)source;
        }
        String name = this.genName(servlet, template.getPropertyValue("$name"));
        if (pastedRole instanceof Entity) {
            link = ((Entity)pastedRole).getPropertyValue("$name");
        } else {
            SecurityRole linkedRole;
            link = template.getPropertyValue("roleLink");
            if (link == null && (linkedRole = this.readLink(template)) != null) {
                link = linkedRole.getName();
            }
        }
        String description = template.getPropertyValue("description");
        SecurityRoleRef ref = servlet.createSecurityRoleReference(name, link, description);
        if (ref == null) {
            return null;
        }
        return WebAppModelMetaInfo.getSecurityRoleRef(webApp.getFile(), servlet.getName(), ref.getName());
    }

    public boolean canDelete(Element element) {
        SecurityRoleRef ref = WebAppModelAccess.getSecurityRoleRef(this.getModel(), element.getUniqueName());
        return ref != null && ref.canDelete();
    }

    public void delete(Element element) {
        SecurityRoleRef ref = WebAppModelAccess.getSecurityRoleRef(this.getModel(), element.getUniqueName());
        ref.delete();
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return WebAppModelMetaInfo.isServlet(parent.getUniqueName()) || WebAppModelMetaInfo.isJsp(parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        Servlet servlet = WebAppModelAccess.getServlet(this.getModel(), parent.getUniqueName());
        if (servlet == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        SecurityRoleRef[] refs = servlet.getSecurityRoleReferences();
        if (refs == null || refs.length == 0) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        WebApp webApp = (WebApp)servlet.getParent();
        ArrayList<UniqueName> uins = new ArrayList<UniqueName>(refs.length);
        int i = 0;
        while (i < refs.length) {
            UniqueName uin = WebAppModelMetaInfo.getSecurityRoleRef(webApp.getFile(), servlet.getName(), refs[i].getName());
            uins.add(uin);
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }

    private static class FakeSecurityRole
    extends FakeDescriptorEntity
    implements SecurityRole {
        private FakeSecurityRole() {
        }

        public String getName() {
            return null;
        }

        public boolean canSetName(String name) {
            return false;
        }

        public void setName(String name) {
        }

        public String getDescription() {
            return null;
        }

        public boolean canSetDescription(String description) {
            return false;
        }

        public void setDescription(String description) {
        }
    }
}

