/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp.ref;

import com.tssap.j2ee.core.descriptor.SecurityRoleRef;
import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.webapp.Servlet;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.core.webapp.namegen.SecurityRoleRefNameGen;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ExistenceProviderEx;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;

public final class SecurityRoleRefNodeProvider
extends AbstractProvider
implements EntityExistenceProvider,
ExistenceProviderEx,
ChildrenProvider {
    public boolean isDeleteProviderApplicable(Element element) {
        return WebAppModelMetaInfo.isSecurityRoleRefNode(element.getUniqueName());
    }

    public boolean isDeleted(Element element) {
        return WebAppModelAccess.getSecurityRoleRef(this.getModel(), element.getUniqueName()) == null;
    }

    public boolean exists(UniqueName uin) {
        if (!WebAppModelMetaInfo.isSecurityRoleRefNode(uin)) {
            return false;
        }
        return WebAppModelAccess.getSecurityRoleRef(this.getModel(), uin) != null;
    }

    private String genName(Servlet servlet, String name) {
        SecurityRoleRefNameGen gen = new SecurityRoleRefNameGen(servlet);
        return gen.getUniqueName(name == null ? "srRef1" : name);
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        String description;
        String link;
        String name;
        if (!"com.tssap.j2ee.core.webapp.SecurityRoleRefNode".equals(shapeType)) {
            return false;
        }
        if (!WebAppModelMetaInfo.isServlet(parent.getUniqueName()) && !WebAppModelMetaInfo.isJsp(parent.getUniqueName())) {
            return false;
        }
        Servlet servlet = WebAppModelAccess.getServlet(this.getModel(), parent.getUniqueName());
        if (servlet == null) {
            return false;
        }
        WebApp webApp = (WebApp)servlet.getParent();
        if (webApp == null) {
            return false;
        }
        if (template == null) {
            name = this.genName(servlet, null);
            link = null;
            description = null;
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            name = this.genName(servlet, template.getPropertyValue("$name"));
            link = template.getPropertyValue("roleLink");
            description = template.getPropertyValue("description");
        }
        return servlet.canCreateSecurityRoleReference(name, link, description);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        String description;
        String link;
        String name;
        Servlet servlet = WebAppModelAccess.getServlet(this.getModel(), parent.getUniqueName());
        WebApp webApp = (WebApp)servlet.getParent();
        if (template == null) {
            name = this.genName(servlet, null);
            link = null;
            description = null;
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            name = this.genName(servlet, template.getPropertyValue("$name"));
            link = template.getPropertyValue("roleLink");
            description = template.getPropertyValue("description");
        }
        SecurityRoleRef ref = servlet.createSecurityRoleReference(name, link, description);
        if (ref == null) {
            return null;
        }
        return WebAppModelMetaInfo.getSecurityRoleRef(webApp.getFile(), servlet.getName(), ref.getName());
    }

    public boolean canDelete(Element element) {
        SecurityRoleRef ref = WebAppModelAccess.getSecurityRoleRef(this.getModel(), element.getUniqueName());
        return ref != null && ref.canDelete();
    }

    public void delete(Element element) {
        SecurityRoleRef ref = WebAppModelAccess.getSecurityRoleRef(this.getModel(), element.getUniqueName());
        ref.delete();
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return WebAppModelMetaInfo.isServlet(parent.getUniqueName()) || WebAppModelMetaInfo.isJsp(parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        Servlet servlet = WebAppModelAccess.getServlet(this.getModel(), parent.getUniqueName());
        if (servlet == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        SecurityRoleRef[] refs = servlet.getSecurityRoleReferences();
        if (refs == null || refs.length == 0) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        WebApp webApp = (WebApp)servlet.getParent();
        ArrayList<UniqueName> uins = new ArrayList<UniqueName>(refs.length);
        int i = 0;
        while (i < refs.length) {
            UniqueName uin = WebAppModelMetaInfo.getSecurityRoleRefNode(webApp.getFile(), servlet.getName(), refs[i].getName());
            uins.add(uin);
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }
}

