/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp.ref;

import com.tssap.j2ee.core.descriptor.SecurityRole;
import com.tssap.j2ee.core.descriptor.SecurityRoleRef;
import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.webapp.Servlet;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.extension.AbstractLinkProvider;

public final class SecurityRoleRefLinkProvider
extends AbstractLinkProvider {
    public boolean isLinkProviderApplicable(Entity link) {
        return WebAppModelMetaInfo.isSecurityRoleRef(link.getUniqueName());
    }

    protected UniqueName getClient(Entity link) {
        Entity ejb = link.getParent();
        if (ejb == null) {
            return null;
        }
        return ejb.getUniqueName();
    }

    protected UniqueName getSupplier(Entity link) {
        SecurityRoleRef ref = WebAppModelAccess.getSecurityRoleRef(this.getModel(), link.getUniqueName());
        if (ref == null) {
            return null;
        }
        Servlet servlet = (Servlet)ref.getParent();
        if (servlet == null) {
            return null;
        }
        WebApp webApp = (WebApp)servlet.getParent();
        if (webApp == null) {
            return null;
        }
        String roleName = ref.getLink();
        if (roleName == null || webApp.getSecurityRole(roleName) == null) {
            return null;
        }
        return WebAppModelMetaInfo.getSecurityRole(webApp.getFile(), roleName);
    }

    protected boolean canSetSupplier(Entity link, Element oldParticipant, Element newParticipant) {
        if (!WebAppModelMetaInfo.isSecurityRole(newParticipant.getUniqueName())) {
            return false;
        }
        SecurityRoleRef ref = WebAppModelAccess.getSecurityRoleRef(this.getModel(), link.getUniqueName());
        if (ref == null) {
            return false;
        }
        SecurityRole securityRole = WebAppModelAccess.getSecurityRole(this.getModel(), newParticipant.getUniqueName());
        if (securityRole == null) {
            return false;
        }
        return ref.canSetLink(securityRole.getName());
    }

    protected void setSupplier(Entity link, Element oldParticipant, Element newParticipant) {
        SecurityRoleRef ref = WebAppModelAccess.getSecurityRoleRef(this.getModel(), link.getUniqueName());
        SecurityRole securityRole = WebAppModelAccess.getSecurityRole(this.getModel(), newParticipant.getUniqueName());
        ref.setLink(securityRole.getName());
    }
}

