/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp.ref;

import com.tssap.j2ee.core.providers.web.WebModelMetaInfo;
import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.web.IHttpSessionAttributeListener;
import com.tssap.j2ee.core.web.IWebElement;
import com.tssap.j2ee.core.web.IWebListener;
import com.tssap.j2ee.core.web.WebProject;
import com.tssap.j2ee.core.webapp.Listener;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.internal.core.descriptor.AbstractDeltaProvider;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppModelAccess;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppProvidersPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ExistenceProviderEx;
import com.tssap.selena.model.providers.proxy.ProxyMetaInfo;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.ModelUinSupport;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;

public final class ListenerProxyProvider
extends AbstractProvider
implements EntityExistenceProvider,
ExistenceProviderEx,
ChildrenProvider {
    public boolean isDeleteProviderApplicable(Element element) {
        return WebAppModelMetaInfo.isListener(element.getUniqueName());
    }

    private boolean listenerExists(UniqueName uin) {
        Listener listener = WebAppModelAccess.getListener(this.getModel(), uin);
        if (listener == null) {
            return false;
        }
        Model listenerRefModel = WebAppModelMetaInfo.getListenerModel(uin);
        if (listenerRefModel == null || listenerRefModel.isDeleted()) {
            return false;
        }
        Entity listenerRef = listenerRefModel.findEntity(WebAppModelMetaInfo.getListener(uin));
        if (listenerRef == null || listenerRef.isDeleted()) {
            return false;
        }
        IWebListener listenerCodeRef = listener.getReferencedListener();
        if (listenerCodeRef == null || !listenerCodeRef.exists()) {
            return false;
        }
        UniqueName listenerCodeRefUin = WebModelMetaInfo.getUniqueName((IWebElement)listenerCodeRef);
        return listenerRef.getUniqueName().equals(listenerCodeRefUin);
    }

    public boolean isDeleted(Element element) {
        return !this.listenerExists(element.getUniqueName());
    }

    public boolean exists(UniqueName uin) {
        if (!WebAppModelMetaInfo.isListener(uin)) {
            return false;
        }
        return this.listenerExists(uin);
    }

    private boolean isListenerMetaclass(String metaclass) {
        if ("com.tssap.j2ee.core.web.HttpSessionAttributeListener".equals(metaclass)) {
            return true;
        }
        if ("com.tssap.j2ee.core.web.HttpSessionActivationListener".equals(metaclass)) {
            return true;
        }
        if ("com.tssap.j2ee.core.web.HttpSessionBindingListener".equals(metaclass)) {
            return true;
        }
        if ("com.tssap.j2ee.core.web.HttpSessionListener".equals(metaclass)) {
            return true;
        }
        if ("com.tssap.j2ee.core.web.ServletContextAttributeListener".equals(metaclass)) {
            return true;
        }
        return "com.tssap.j2ee.core.web.ServletContextListener".equals(metaclass);
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        if (!this.isListenerMetaclass(shapeType)) {
            return false;
        }
        if (!WebAppModelMetaInfo.isWebApp(parent.getUniqueName())) {
            return false;
        }
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (webApp == null) {
            return false;
        }
        if (template == null) {
            return true;
        }
        Entity listenerEntity = WebAppModelMetaInfo.getSourceListener(template);
        if (listenerEntity != null) {
            if (!WebModelMetaInfo.isWebListener((UniqueName)listenerEntity.getUniqueName())) {
                return false;
            }
            IWebListener listenerRef = this.getWebListener(listenerEntity);
            if (listenerRef == null || !listenerRef.exists()) {
                return false;
            }
            return webApp.canCreateListener(listenerRef.getType().getFullyQualifiedName());
        }
        Object source = template.getObjectPropertyValue("$elementToClone");
        if (source instanceof Entity) {
            template = (Entity)source;
        }
        String listenerClass = template.getPropertyValue("listenerClassRef");
        return webApp.canCreateListener(listenerClass);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        if (template == null) {
            return null;
        }
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (!webApp.ensureSaved(true)) {
            return null;
        }
        Listener listener = null;
        Entity listenerEntity = WebAppModelMetaInfo.getSourceListener(template);
        if (listenerEntity != null) {
            IWebListener listenerRef = this.getWebListener(listenerEntity);
            listener = webApp.createListener(listenerRef.getType().getFullyQualifiedName());
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            String listenerClass = template.getPropertyValue("listenerClassRef");
            listener = webApp.createListener(listenerClass);
        }
        if (listener == null) {
            return null;
        }
        return WebAppModelAccess.getListenerUniqueName(listener.getReferencedListener(), parent.getUniqueName());
    }

    private IWebListener getWebListener(Entity listenerEntity) {
        String listenerClassFQN;
        UniqueName uniqueName = listenerEntity.getUniqueName();
        String listenerClassName = uniqueName.getName();
        String packageName = uniqueName.getLocation();
        if (packageName == null || packageName.trim().length() == 0) {
            packageName = "";
            listenerClassFQN = listenerClassName;
        } else {
            listenerClassFQN = packageName + '.' + listenerClassName;
        }
        IProject project = ModelUinSupport.getProject((UniqueName)listenerEntity.getModel().getUniqueName());
        if (project == null) {
            return null;
        }
        WebProject webProject = WebProject.getInstance((IProject)project);
        if (webProject == null) {
            return null;
        }
        IHttpSessionAttributeListener listener = webProject.getHttpSessionAttributeListener(listenerClassFQN);
        if (listener != null) {
            return listener;
        }
        listener = webProject.getHttpSessionActivationListener(listenerClassFQN);
        if (listener != null) {
            return listener;
        }
        listener = webProject.getHttpSessionBindingListener(listenerClassFQN);
        if (listener != null) {
            return listener;
        }
        listener = webProject.getHttpSessionListener(listenerClassFQN);
        if (listener != null) {
            return listener;
        }
        listener = webProject.getServletContextAttributeListener(listenerClassFQN);
        if (listener != null) {
            return listener;
        }
        listener = webProject.getServletContextListener(listenerClassFQN);
        if (listener != null) {
            return listener;
        }
        return null;
    }

    public boolean canDelete(Element element) {
        Listener listener = WebAppModelAccess.getListener(this.getModel(), element.getUniqueName());
        return listener != null && listener.canDelete();
    }

    public void delete(Element element) {
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), element.getParent().getUniqueName());
        if (!webApp.ensureSaved(true)) {
            return;
        }
        Listener listener = WebAppModelAccess.getListener(this.getModel(), element.getUniqueName());
        listener.delete();
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return WebAppModelMetaInfo.isWebApp(parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (webApp == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        Listener[] listeners = webApp.getListeners();
        if (listeners == null || listeners.length == 0) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        ArrayList<UniqueName> uins = new ArrayList<UniqueName>(listeners.length);
        int i = 0;
        while (i < listeners.length) {
            IWebListener listener = listeners[i].getReferencedListener();
            if (listener != null && listener.exists()) {
                UniqueName source = WebModelMetaInfo.getUniqueName((IWebElement)listener);
                IProject webProject = listener.getWebProject().getProject();
                Model sourceModel = ModelAccess.getModel((UniqueName)ModelUinSupport.createModelUin((String)webProject.getName()));
                if (sourceModel.findEntity(source) == null) {
                    WebAppProvidersPlugin.logWarning("Listener [" + listeners[i].getClassName() + "] not found");
                } else {
                    UniqueName uin = WebAppModelMetaInfo.getListener(sourceModel, source, parent.getUniqueName());
                    ProxyMetaInfo.bind((UniqueName)uin, (UniqueName)this.getModel().getUniqueName());
                    listeners[i].setUserData(AbstractDeltaProvider.DELTA_KEY, (Object)uin);
                    uins.add(uin);
                }
            }
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }
}

