/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp.ref;

import com.tssap.j2ee.core.providers.web.WebModelMetaInfo;
import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.web.IJSP;
import com.tssap.j2ee.core.webapp.Servlet;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppProvidersPlugin;
import com.tssap.j2ee.internal.core.providers.webapp.ref.AbstractWebAppProxyRule;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import java.util.List;
import org.eclipse.core.resources.IProject;

public class JspProxyRule
extends AbstractWebAppProxyRule {
    protected String getRefName(Model sourceModel, UniqueName source) {
        if (!WebModelMetaInfo.isJSPUniqueName((UniqueName)source)) {
            return null;
        }
        String jspFileName = WebModelMetaInfo.getJspFileName((UniqueName)source);
        if (jspFileName == null || jspFileName.trim().length() == 0) {
            WebAppProvidersPlugin.logWarning("Invalid jsp encountered [" + source + "] in model [" + sourceModel + "]");
            return null;
        }
        return jspFileName;
    }

    protected void addProxies(List uins, WebApp webApp, IProject webProject, String jspFileName, Model jspModel, UniqueName jspUin) {
        Servlet[] servlets = webApp.getServlets();
        if (servlets == null || servlets.length == 0) {
            return;
        }
        UniqueName webAppUin = null;
        int i = 0;
        while (i < servlets.length) {
            IJSP servletRef;
            Servlet servlet = servlets[i];
            if (servlet != null && (servletRef = servlet.getReferencedJsp()) != null && servletRef.exists() && jspFileName.equals(servletRef.getFile().getProjectRelativePath().toString()) && this.hasName(servletRef.getWebProject(), webProject.getName())) {
                if (webAppUin == null) {
                    webAppUin = WebAppModelMetaInfo.getWebApp(webApp.getFile());
                }
                UniqueName proxyUin = WebAppModelMetaInfo.getJsp(jspModel, jspUin, webAppUin, servlet.getName());
                uins.add(proxyUin);
            }
            ++i;
        }
    }
}

