/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp.ref;

import com.tssap.j2ee.core.providers.web.WebModelMetaInfo;
import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.providers.webapp.context.WebContextFactory;
import com.tssap.j2ee.core.providers.webapp.context.WebDeployedContextFactory;
import com.tssap.j2ee.core.web.IFilter;
import com.tssap.j2ee.core.webapp.Filter;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.core.webapp.context.FilterContext;
import com.tssap.j2ee.core.webapp.namegen.FilterNameGen;
import com.tssap.j2ee.internal.core.descriptor.AbstractDeltaProvider;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppModelAccess;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppProvidersPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ExistenceProviderEx;
import com.tssap.selena.model.providers.proxy.ProxyMetaInfo;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.ModelUinSupport;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;

public final class FilterProxyProvider
extends AbstractProvider
implements EntityExistenceProvider,
ExistenceProviderEx,
ChildrenProvider {
    static /* synthetic */ Class class$org$eclipse$jdt$core$IType;

    public boolean isDeleteProviderApplicable(Element element) {
        return WebAppModelMetaInfo.isFilter(element.getUniqueName());
    }

    private boolean filterExists(UniqueName uin) {
        Filter filter = WebAppModelAccess.getFilter(this.getModel(), uin);
        if (filter == null) {
            return false;
        }
        Model filterRefModel = WebAppModelMetaInfo.getFilterModel(uin);
        if (filterRefModel == null || filterRefModel.isDeleted()) {
            return false;
        }
        Entity filterRef = filterRefModel.findEntity(WebAppModelMetaInfo.getFilter(uin));
        if (filterRef == null || filterRef.isDeleted()) {
            return false;
        }
        IFilter filterCodeRef = filter.getReferencedFilter();
        if (filterCodeRef == null || !filterCodeRef.exists()) {
            return false;
        }
        UniqueName filterCodeRefUin = WebModelMetaInfo.getUniqueName((IFilter)filterCodeRef);
        return filterRef.getUniqueName().equals(filterCodeRefUin);
    }

    public boolean isDeleted(Element element) {
        return !this.filterExists(element.getUniqueName());
    }

    public boolean exists(UniqueName uin) {
        if (!WebAppModelMetaInfo.isFilter(uin)) {
            return false;
        }
        return this.filterExists(uin);
    }

    private String getFilterName(Entity template, WebApp webApp) {
        String name = template.getPropertyValue("$name");
        if (name == null) {
            name = template.getPropertyValue("filterName");
        }
        if (name == null || name.trim().length() == 0) {
            Object type = template.getObjectPropertyValue((class$org$eclipse$jdt$core$IType == null ? (class$org$eclipse$jdt$core$IType = FilterProxyProvider.class$("org.eclipse.jdt.core.IType")) : class$org$eclipse$jdt$core$IType).getName());
            if (type == null || !(type instanceof IType)) {
                name = "filter1";
            } else {
                name = ((IType)type).getFullyQualifiedName();
                int doti = name.indexOf(46);
                if (doti >= 0) {
                    name = name.substring(doti + 1);
                }
            }
        }
        FilterNameGen gen = new FilterNameGen(webApp);
        return gen.getUniqueName(name);
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        if (!"com.tssap.j2ee.core.web.Filter".equals(shapeType)) {
            return false;
        }
        if (!WebAppModelMetaInfo.isWebApp(parent.getUniqueName())) {
            return false;
        }
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (webApp == null) {
            return false;
        }
        if (template == null) {
            return true;
        }
        Entity filterEntity = WebAppModelMetaInfo.getSourceFilter(template);
        if (filterEntity != null) {
            if (!WebModelMetaInfo.isFilterUniqueName((UniqueName)filterEntity.getUniqueName())) {
                return false;
            }
            String name = this.getFilterName(template, webApp);
            FilterContext context = WebContextFactory.getInstance().getFilterContext((Element)filterEntity, name);
            return webApp.canCreateFilter(context);
        }
        Object source = template.getObjectPropertyValue("$elementToClone");
        if (source instanceof Entity) {
            template = (Entity)source;
        }
        String name = this.getFilterName(template, webApp);
        FilterContext context = WebDeployedContextFactory.getInstance().getFilterContext((Element)template, name);
        return webApp.canCreateFilter(context);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        if (template == null || !this.canCreateUniqueName(parent, shapeType, template)) {
            return null;
        }
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (!webApp.ensureSaved(true)) {
            return null;
        }
        Filter filter = null;
        Entity filterEntity = WebAppModelMetaInfo.getSourceFilter(template);
        if (filterEntity != null) {
            String name = this.getFilterName(template, webApp);
            FilterContext context = WebContextFactory.getInstance().getFilterContext((Element)filterEntity, name);
            filter = webApp.createFilter(context);
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            String name = this.getFilterName(template, webApp);
            FilterContext context = WebDeployedContextFactory.getInstance().getFilterContext((Element)template, name);
            filter = webApp.createFilter(context);
        }
        if (filter == null) {
            return null;
        }
        return WebAppModelAccess.getFilterUniqueName(filter.getReferencedFilter(), filter.getName(), parent.getUniqueName());
    }

    public boolean canDelete(Element element) {
        Filter filter = WebAppModelAccess.getFilter(this.getModel(), element.getUniqueName());
        return filter != null && filter.canDelete();
    }

    public void delete(Element element) {
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), element.getParent().getUniqueName());
        if (!webApp.ensureSaved(true)) {
            return;
        }
        Filter filter = WebAppModelAccess.getFilter(this.getModel(), element.getUniqueName());
        filter.delete();
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return WebAppModelMetaInfo.isWebApp(parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (webApp == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        Filter[] filters = webApp.getFilters();
        if (filters == null || filters.length == 0) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        ArrayList<UniqueName> uins = new ArrayList<UniqueName>(filters.length);
        int i = 0;
        while (i < filters.length) {
            IFilter filter = filters[i].getReferencedFilter();
            if (filter != null && filter.exists()) {
                UniqueName source = WebModelMetaInfo.getUniqueName((IFilter)filter);
                IProject webProject = filter.getWebProject().getProject();
                Model sourceModel = ModelAccess.getModel((UniqueName)ModelUinSupport.createModelUin((String)webProject.getName()));
                if (sourceModel.findEntity(source) == null) {
                    WebAppProvidersPlugin.logWarning("Filter [" + filters[i].getName() + "] not found");
                } else {
                    UniqueName uin = WebAppModelMetaInfo.getFilter(sourceModel, source, parent.getUniqueName(), filters[i].getName());
                    ProxyMetaInfo.bind((UniqueName)uin, (UniqueName)this.getModel().getUniqueName());
                    filters[i].setUserData(AbstractDeltaProvider.DELTA_KEY, (Object)uin);
                    uins.add(uin);
                }
            }
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

