/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp.ref;

import com.tssap.j2ee.core.utils.UtilsPlugin;
import com.tssap.j2ee.core.web.WebProject;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.core.webapp.WebAppProject;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.providers.proxy.ProxyRule;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;

abstract class AbstractWebAppProxyRule
implements ProxyRule {
    AbstractWebAppProxyRule() {
    }

    public UniqueNameEnumeration getProxies(Model proxyModel, Model sourceModel, UniqueName source) {
        String refName = this.getRefName(sourceModel, source);
        if (refName == null) {
            return null;
        }
        IProject sourceProject = ModelUinSupport.getProject((UniqueName)sourceModel.getUniqueName());
        if (sourceProject == null) {
            return null;
        }
        WebProject webProject = WebProject.getInstance((IProject)sourceProject);
        if (webProject == null) {
            return null;
        }
        IProject proxyProject = ModelUinSupport.getProject((UniqueName)proxyModel.getUniqueName());
        if (proxyProject == null) {
            return null;
        }
        WebAppProject webAppProject = WebAppProject.getInstance((IProject)proxyProject);
        if (webAppProject == null) {
            return null;
        }
        WebApp[] webApps = webAppProject.getWebApps();
        if (webApps == null || webApps.length == 0) {
            return null;
        }
        if (!UtilsPlugin.references((IProject)proxyProject, (IProject)sourceProject)) {
            return null;
        }
        ArrayList uins = new ArrayList();
        int i = 0;
        while (i < webApps.length) {
            this.addProxies(uins, webApps[i], sourceProject, refName, sourceModel, source);
            ++i;
        }
        if (uins.isEmpty()) {
            return null;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }

    protected abstract String getRefName(Model var1, UniqueName var2);

    protected abstract void addProxies(List var1, WebApp var2, IProject var3, String var4, Model var5, UniqueName var6);

    protected boolean hasName(WebProject webRefProject, String name) {
        if (webRefProject == null) {
            return false;
        }
        IProject webRefProjectRef = webRefProject.getProject();
        if (webRefProjectRef == null) {
            return false;
        }
        return webRefProjectRef.getName().equals(name);
    }
}

