/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp.env;

import com.tssap.j2ee.core.descriptor.Environment;
import com.tssap.j2ee.core.descriptor.ResourceRef;
import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.core.webapp.namegen.ResourceRefNameGen;
import com.tssap.j2ee.internal.core.descriptor.AbstractDeltaProvider;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppModelAccess;
import com.tssap.j2ee.internal.core.providers.webapp.env.EnvironmentModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ExistenceProviderEx;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;

public final class ResourceRefProvider
extends AbstractProvider
implements EntityExistenceProvider,
ExistenceProviderEx,
ChildrenProvider {
    public static final String DEFAULT_TYPE = "javax.sql.DataSource";

    public boolean isDeleteProviderApplicable(Element element) {
        return WebAppModelMetaInfo.isResourceRef(element.getUniqueName());
    }

    public boolean isDeleted(Element element) {
        return EnvironmentModelAccess.getResourceRef(this.getModel(), element.getUniqueName()) == null;
    }

    public boolean exists(UniqueName uin) {
        if (!WebAppModelMetaInfo.isResourceRef(uin)) {
            return false;
        }
        return EnvironmentModelAccess.getResourceRef(this.getModel(), uin) != null;
    }

    private String genName(WebApp webApp, String name) {
        ResourceRefNameGen gen = new ResourceRefNameGen(webApp);
        return gen.getUniqueName(name == null ? "jdbc/Resource1" : name);
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        String description;
        String scope;
        String auth;
        String type;
        String name;
        if (!"com.tssap.j2ee.core.webapp.ResourceRef".equals(shapeType)) {
            return false;
        }
        if (!WebAppModelMetaInfo.isWebApp(parent.getUniqueName())) {
            return false;
        }
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (webApp == null) {
            return false;
        }
        if (template == null) {
            name = this.genName(webApp, null);
            type = DEFAULT_TYPE;
            auth = "Application";
            scope = "Shareable";
            description = null;
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            name = this.genName(webApp, template.getPropertyValue("$name"));
            type = template.getPropertyValue("resType");
            auth = template.getPropertyValue("resAuth");
            scope = template.getPropertyValue("sharingScope");
            description = template.getPropertyValue("description");
        }
        return webApp.getEnvironment().canCreateResourceReference(name, type, auth, scope, description);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        String description;
        String scope;
        String auth;
        String type;
        String name;
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (template == null) {
            name = this.genName(webApp, null);
            type = DEFAULT_TYPE;
            auth = "Application";
            scope = "Shareable";
            description = null;
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            name = this.genName(webApp, template.getPropertyValue("$name"));
            type = template.getPropertyValue("resType");
            auth = template.getPropertyValue("resAuth");
            scope = template.getPropertyValue("sharingScope");
            description = template.getPropertyValue("description");
        }
        ResourceRef ref = webApp.getEnvironment().createResourceReference(name, type, auth, scope, description);
        if (ref == null) {
            return null;
        }
        return WebAppModelMetaInfo.getResourceRef(webApp.getFile(), ref.getName());
    }

    public boolean canDelete(Element element) {
        ResourceRef ref = EnvironmentModelAccess.getResourceRef(this.getModel(), element.getUniqueName());
        return ref != null && ref.canDelete();
    }

    public void delete(Element element) {
        ResourceRef ref = EnvironmentModelAccess.getResourceRef(this.getModel(), element.getUniqueName());
        ref.delete();
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return WebAppModelMetaInfo.isWebApp(parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (webApp == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        Environment env = webApp.getEnvironment();
        if (env == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        ResourceRef[] refs = webApp.getEnvironment().getResourceReferences();
        if (refs == null || refs.length == 0) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        ArrayList<UniqueName> uins = new ArrayList<UniqueName>(refs.length);
        int i = 0;
        while (i < refs.length) {
            UniqueName uin = WebAppModelMetaInfo.getResourceRef(webApp.getFile(), refs[i].getName());
            refs[i].setUserData(AbstractDeltaProvider.DELTA_KEY, (Object)uin);
            uins.add(uin);
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }
}

