/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp.env;

import com.tssap.j2ee.core.descriptor.EjbRef;
import com.tssap.j2ee.core.descriptor.Environment;
import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.core.webapp.namegen.EjbRefNameGen;
import com.tssap.j2ee.internal.core.descriptor.AbstractDeltaProvider;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppModelAccess;
import com.tssap.j2ee.internal.core.providers.webapp.env.EnvironmentModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ExistenceProviderEx;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;

public final class EjbRefProvider
extends AbstractProvider
implements EntityExistenceProvider,
ExistenceProviderEx,
ChildrenProvider {
    private static final String DEFAULT_LINK_PATH = "ejb.jar";
    private static final String DEFAULT_LINK_TARGET = "Session1Bean";
    private static final String DEFAULT_HOME_INTERFACE = "Session1Home";
    private static final String DEFAULT_REMOTE_INTERFACE = "Session1";

    public boolean isDeleteProviderApplicable(Element element) {
        return WebAppModelMetaInfo.isEjbRef(element.getUniqueName());
    }

    public boolean isDeleted(Element element) {
        return EnvironmentModelAccess.getEjbRef(this.getModel(), element.getUniqueName()) == null;
    }

    public boolean exists(UniqueName uin) {
        if (!WebAppModelMetaInfo.isEjbRef(uin)) {
            return false;
        }
        return EnvironmentModelAccess.getEjbRef(this.getModel(), uin) != null;
    }

    private String genName(WebApp webApp, String name) {
        EjbRefNameGen gen = new EjbRefNameGen(webApp);
        return gen.getUniqueName(name == null ? "ejb/ref1" : name);
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        String description;
        String remoteInterface;
        String homeInterface;
        String linkTarget;
        String linkPath;
        String type;
        String name;
        if (!"com.tssap.j2ee.core.webapp.EjbRef".equals(shapeType)) {
            return false;
        }
        if (!WebAppModelMetaInfo.isWebApp(parent.getUniqueName())) {
            return false;
        }
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (webApp == null) {
            return false;
        }
        if (template == null) {
            name = this.genName(webApp, null);
            type = "Session";
            linkPath = DEFAULT_LINK_PATH;
            linkTarget = DEFAULT_LINK_TARGET;
            homeInterface = DEFAULT_HOME_INTERFACE;
            remoteInterface = DEFAULT_REMOTE_INTERFACE;
            description = null;
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            name = this.genName(webApp, template.getPropertyValue("$name"));
            type = template.getPropertyValue("ejbRefType");
            linkPath = template.getPropertyValue("ejbLinkPath");
            linkTarget = template.getPropertyValue("ejbLinkTarget");
            homeInterface = template.getPropertyValue("homeInterfaceRef");
            remoteInterface = template.getPropertyValue("remoteInterfaceRef");
            description = template.getPropertyValue("description");
        }
        return webApp.getEnvironment().canCreateEjbReference(name, type, linkPath, linkTarget, homeInterface, remoteInterface, description);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        String description;
        String remoteInterface;
        String homeInterface;
        String linkTarget;
        String linkPath;
        String type;
        String name;
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (template == null) {
            name = this.genName(webApp, null);
            type = "Session";
            linkPath = DEFAULT_LINK_PATH;
            linkTarget = DEFAULT_LINK_TARGET;
            homeInterface = DEFAULT_HOME_INTERFACE;
            remoteInterface = DEFAULT_REMOTE_INTERFACE;
            description = null;
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            name = this.genName(webApp, template.getPropertyValue("$name"));
            type = template.getPropertyValue("ejbRefType");
            linkPath = template.getPropertyValue("ejbLinkPath");
            linkTarget = template.getPropertyValue("ejbLinkTarget");
            homeInterface = template.getPropertyValue("homeInterfaceRef");
            remoteInterface = template.getPropertyValue("remoteInterfaceRef");
            description = template.getPropertyValue("description");
        }
        EjbRef ref = webApp.getEnvironment().createEjbReference(name, type, linkPath, linkTarget, homeInterface, remoteInterface, description);
        if (ref == null) {
            return null;
        }
        return WebAppModelMetaInfo.getEjbRef(webApp.getFile(), ref.getName());
    }

    public boolean canDelete(Element element) {
        EjbRef ref = EnvironmentModelAccess.getEjbRef(this.getModel(), element.getUniqueName());
        return ref != null && ref.canDelete();
    }

    public void delete(Element element) {
        EjbRef ref = EnvironmentModelAccess.getEjbRef(this.getModel(), element.getUniqueName());
        ref.delete();
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return WebAppModelMetaInfo.isWebApp(parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (webApp == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        Environment env = webApp.getEnvironment();
        if (env == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        EjbRef[] refs = env.getEjbReferences();
        if (refs == null || refs.length == 0) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        ArrayList<UniqueName> uins = new ArrayList<UniqueName>(refs.length);
        int i = 0;
        while (i < refs.length) {
            UniqueName uin = WebAppModelMetaInfo.getEjbRef(webApp.getFile(), refs[i].getName());
            refs[i].setUserData(AbstractDeltaProvider.DELTA_KEY, (Object)uin);
            uins.add(uin);
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }
}

