/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp;

import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.webapp.SecurityConstraint;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.core.webapp.WebResourceCollection;
import com.tssap.j2ee.core.webapp.namegen.WebResourceCollectionNameGen;
import com.tssap.j2ee.internal.core.descriptor.AbstractDeltaProvider;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ExistenceProviderEx;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;

public final class WebResourceCollectionProvider
extends AbstractProvider
implements EntityExistenceProvider,
ExistenceProviderEx,
ChildrenProvider {
    private static final String[] DEFAULT_URL_PATTERNS = new String[]{"index.jsp"};
    private static final String[] DEFAULT_HTTP_METHODS = new String[]{"GET", "POST"};

    public boolean isDeleteProviderApplicable(Element element) {
        return WebAppModelMetaInfo.isWebResourceCollection(element.getUniqueName());
    }

    public boolean isDeleted(Element element) {
        return WebAppModelAccess.getWebResourceCollection(this.getModel(), element.getUniqueName()) == null;
    }

    public boolean exists(UniqueName uin) {
        if (!WebAppModelMetaInfo.isWebResourceCollection(uin)) {
            return false;
        }
        return WebAppModelAccess.getWebResourceCollection(this.getModel(), uin) != null;
    }

    private String genName(SecurityConstraint constraint, String name) {
        WebResourceCollectionNameGen gen = new WebResourceCollectionNameGen(constraint);
        return gen.getUniqueName(name == null ? "wrc1" : name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        String[] httpMethods;
        String[] urlPatterns;
        String description;
        String name;
        if (!"com.tssap.j2ee.core.webapp.WebResourceCollection".equals(shapeType)) {
            return false;
        }
        if (!WebAppModelMetaInfo.isSecurityConstraint(parent.getUniqueName())) {
            return false;
        }
        SecurityConstraint constraint = WebAppModelAccess.getSecurityConstraint(this.getModel(), parent.getUniqueName());
        if (constraint == null) {
            return false;
        }
        WebApp webApp = (WebApp)constraint.getParent();
        if (webApp == null) {
            return false;
        }
        if (template == null) {
            name = this.genName(constraint, null);
            description = null;
            urlPatterns = DEFAULT_URL_PATTERNS;
            httpMethods = DEFAULT_HTTP_METHODS;
            return constraint.canCreateWebResourceCollection(name, description, urlPatterns, httpMethods);
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            name = this.genName(constraint, template.getPropertyValue("$name"));
            description = template.getPropertyValue("description");
            Object urlPatternsObj = template.getObjectPropertyValue("urlPatterns");
            if (urlPatternsObj != null) {
                if (!(urlPatternsObj instanceof String[])) return false;
                urlPatterns = (String[])urlPatternsObj;
            } else {
                urlPatterns = null;
            }
            Object httpMethodsObj = template.getObjectPropertyValue("httpMethods");
            if (httpMethodsObj != null) {
                if (!(httpMethodsObj instanceof String[])) return false;
                httpMethods = (String[])httpMethodsObj;
                return constraint.canCreateWebResourceCollection(name, description, urlPatterns, httpMethods);
            } else {
                httpMethods = null;
            }
        }
        return constraint.canCreateWebResourceCollection(name, description, urlPatterns, httpMethods);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        Object httpMethods;
        Object urlPatterns;
        String description;
        String name;
        SecurityConstraint constraint = WebAppModelAccess.getSecurityConstraint(this.getModel(), parent.getUniqueName());
        if (template == null) {
            name = this.genName(constraint, null);
            description = null;
            urlPatterns = DEFAULT_URL_PATTERNS;
            httpMethods = DEFAULT_HTTP_METHODS;
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            name = this.genName(constraint, template.getPropertyValue("$name"));
            description = template.getPropertyValue("description");
            Object urlPatternsObj = template.getObjectPropertyValue("urlPatterns");
            urlPatterns = urlPatternsObj != null ? (String[])urlPatternsObj : null;
            Object httpMethodsObj = template.getObjectPropertyValue("httpMethods");
            httpMethods = httpMethodsObj != null ? (String[])httpMethodsObj : null;
        }
        WebResourceCollection wrc = constraint.createWebResourceCollection(name, description, urlPatterns, httpMethods);
        if (wrc == null) {
            return null;
        }
        WebApp webApp = (WebApp)constraint.getParent();
        return WebAppModelMetaInfo.getWebResourceCollection(webApp.getFile(), constraint.getSyntheticName(), wrc.getName());
    }

    public boolean canDelete(Element element) {
        WebResourceCollection collection = WebAppModelAccess.getWebResourceCollection(this.getModel(), element.getUniqueName());
        return collection != null && collection.canDelete();
    }

    public void delete(Element element) {
        WebResourceCollection collection = WebAppModelAccess.getWebResourceCollection(this.getModel(), element.getUniqueName());
        collection.delete();
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return WebAppModelMetaInfo.isSecurityConstraint(parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        SecurityConstraint constraint = WebAppModelAccess.getSecurityConstraint(this.getModel(), parent.getUniqueName());
        if (constraint == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        WebResourceCollection[] collections = constraint.getWebResourceCollections();
        if (collections == null || collections.length == 0) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        WebApp webApp = (WebApp)constraint.getParent();
        ArrayList<UniqueName> uins = new ArrayList<UniqueName>(collections.length);
        int i = 0;
        while (i < collections.length) {
            UniqueName uin = WebAppModelMetaInfo.getWebResourceCollection(webApp.getFile(), constraint.getSyntheticName(), collections[i].getName());
            collections[i].setUserData(AbstractDeltaProvider.DELTA_KEY, (Object)uin);
            uins.add(uin);
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }
}

