/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp;

import com.tssap.j2ee.core.utils.UtilsPlugin;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public final class WebAppProvidersPlugin
extends Plugin {
    private boolean myTracing;
    private boolean myDebuggingDelta;
    private static WebAppProvidersPlugin ourInstance;

    public WebAppProvidersPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        ourInstance = this;
        this.myTracing = UtilsPlugin.getTraceDebugOption((IPluginDescriptor)descriptor);
        this.myDebuggingDelta = UtilsPlugin.getDeltaDebugOption((IPluginDescriptor)descriptor);
    }

    public static WebAppProvidersPlugin getDefault() {
        return ourInstance;
    }

    public boolean isTracing() {
        return this.myTracing;
    }

    public boolean isDebuggingDelta() {
        return this.myDebuggingDelta;
    }

    public static void logInfo(String text) {
        WebAppProvidersPlugin instance = WebAppProvidersPlugin.getDefault();
        if (instance == null) {
            return;
        }
        if (!instance.isDebugging()) {
            return;
        }
        WebAppProvidersPlugin.log(1, text);
    }

    public static void logError(String text) {
        WebAppProvidersPlugin.log(4, text);
    }

    public static void logError(String text, Throwable cause) {
        WebAppProvidersPlugin.log(4, text, cause);
    }

    public static void logWarning(String text) {
        WebAppProvidersPlugin.log(2, text);
    }

    public static void logWarning(String text, Throwable cause) {
        WebAppProvidersPlugin.log(2, text, cause);
    }

    protected static void log(int type, String text) {
        WebAppProvidersPlugin instance = WebAppProvidersPlugin.getDefault();
        if (instance != null && instance.isTracing()) {
            WebAppProvidersPlugin.log(type, text, new Throwable());
        } else {
            WebAppProvidersPlugin.log(type, text, null);
        }
    }

    protected static void log(int type, String text, Throwable cause) {
        WebAppProvidersPlugin instance = WebAppProvidersPlugin.getDefault();
        if (instance == null) {
            System.err.println(text);
            if (cause != null) {
                cause.printStackTrace(System.err);
            }
        } else {
            String id = instance.getDescriptor().getUniqueIdentifier();
            Status status = new Status(type, id, 0, text, cause);
            instance.getLog().log((IStatus)status);
        }
    }
}

