/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp;

import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.core.webapp.WebAppProject;
import com.tssap.j2ee.internal.core.descriptor.AbstractDeltaProvider;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ExistenceProviderEx;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.ModelUinSupport;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public final class WebAppProvider
extends AbstractProvider
implements EntityExistenceProvider,
ExistenceProviderEx,
ChildrenProvider {
    public boolean isDeleteProviderApplicable(Element element) {
        return WebAppModelMetaInfo.isWebApp(element.getUniqueName());
    }

    public boolean isDeleted(Element element) {
        return WebAppModelAccess.getWebApp(this.getModel(), element.getUniqueName()) == null;
    }

    public boolean exists(UniqueName uin) {
        if (!WebAppModelMetaInfo.isWebApp(uin)) {
            return false;
        }
        return WebAppModelAccess.getWebApp(this.getModel(), uin) != null;
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        if (!"com.tssap.j2ee.core.webapp.WebApp".equals(shapeType)) {
            return false;
        }
        if (!ModelUinSupport.isModelUin((UniqueName)parent.getUniqueName())) {
            return false;
        }
        if (!template.hasProperty("$file")) {
            return false;
        }
        String fileName = template.getPropertyValue("$file");
        if (!fileName.endsWith("web.xml")) {
            return false;
        }
        IFile file = this.getProject().getFile(fileName);
        if (file.exists()) {
            return false;
        }
        IContainer container = file.getParent();
        if (!container.isAccessible()) {
            return false;
        }
        return WebAppModelAccess.getWebApp(this.getModel(), WebAppModelMetaInfo.getWebApp(file)) == null;
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        IFile file = this.getProject().getFile(template.getPropertyValue("$file"));
        WebAppProject.getInstance((IProject)this.getProject()).createWebApp(file);
        return WebAppModelMetaInfo.getWebApp(file);
    }

    public boolean canDelete(Element element) {
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), element.getUniqueName());
        return webApp != null && webApp.canDelete();
    }

    public void delete(Element element) {
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), element.getUniqueName());
        webApp.delete();
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return ModelUinSupport.isModelUin((UniqueName)parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        WebAppProject webAppProject = WebAppProject.getInstance((IProject)this.getProject());
        if (webAppProject == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        WebApp[] webApps = webAppProject.getWebApps();
        if (webApps == null || webApps.length == 0) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        ArrayList<UniqueName> uins = new ArrayList<UniqueName>();
        int i = 0;
        while (i < webApps.length) {
            UniqueName uin = WebAppModelMetaInfo.getWebApp(webApps[i].getFile());
            webApps[i].setUserData(AbstractDeltaProvider.DELTA_KEY, (Object)uin);
            uins.add(uin);
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }
}

