/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp;

import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.util.extension.AbstractPropertyWriter;

public final class WebAppPropertyProvider
extends AbstractPropertyWriter {
    public WebAppPropertyProvider() {
        this.getPropertyNames().add("$enableGenericPaste");
        this.getPropertyNames().add("invalid");
        this.getPropertyNames().add("specVersion");
        this.getPropertyNames().add("id");
        this.getPropertyNames().add("description");
        this.getPropertyNames().add("distributable");
        this.getPropertyNames().add("sessionTimeout");
        this.getPropertyNames().add("authMethod");
        this.getPropertyNames().add("realmName");
        this.getPropertyNames().add("formErrorPage");
        this.getPropertyNames().add("formLoginPage");
        this.getPropertyNames().add("displayName");
        this.getPropertyNames().add("largeIcon");
        this.getPropertyNames().add("smallIcon");
    }

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        if (element instanceof ReferenceCollection && (element = element.getParent()) == null) {
            return false;
        }
        if (!WebAppModelMetaInfo.isWebApp(element.getUniqueName())) {
            return false;
        }
        return this.getPropertyNames().contains(propertyName);
    }

    public String getPropertyValue(Element element, String propertyName) {
        WebApp webApp;
        if ("$enableGenericPaste".equals(propertyName)) {
            if (element instanceof ReferenceCollection) {
                return null;
            }
            return Boolean.TRUE.toString();
        }
        if (element instanceof ReferenceCollection) {
            element = element.getParent();
        }
        if ((webApp = WebAppModelAccess.getWebApp(this.getModel(), element.getUniqueName())) == null) {
            return null;
        }
        if ("invalid".equals(propertyName)) {
            return String.valueOf(!webApp.isRecognized());
        }
        if ("specVersion".equals(propertyName)) {
            return webApp.getSpecVersion();
        }
        if ("id".equals(propertyName)) {
            return webApp.getId();
        }
        if ("description".equals(propertyName)) {
            return webApp.getDescription();
        }
        if ("distributable".equals(propertyName)) {
            return String.valueOf(webApp.isDistributable());
        }
        if ("sessionTimeout".equals(propertyName)) {
            Integer timeout = webApp.getSessionTimeout();
            return timeout == null ? null : timeout.toString();
        }
        if ("authMethod".equals(propertyName)) {
            return webApp.getLoginConfig().getAuthMethod();
        }
        if ("realmName".equals(propertyName)) {
            return webApp.getLoginConfig().getRealmName();
        }
        if ("formErrorPage".equals(propertyName)) {
            return webApp.getLoginConfig().getFormErrorPage();
        }
        if ("formLoginPage".equals(propertyName)) {
            return webApp.getLoginConfig().getFormLoginPage();
        }
        if ("displayName".equals(propertyName)) {
            return webApp.getUserInterface().getDisplayName();
        }
        if ("largeIcon".equals(propertyName)) {
            return webApp.getUserInterface().getLargeIcon();
        }
        if ("smallIcon".equals(propertyName)) {
            return webApp.getUserInterface().getSmallIcon();
        }
        return this.unknownProperty(propertyName);
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        WebApp webApp;
        if (element instanceof ReferenceCollection) {
            element = element.getParent();
        }
        if ((webApp = WebAppModelAccess.getWebApp(this.getModel(), element.getUniqueName())) == null) {
            return false;
        }
        if ("id".equals(propertyName)) {
            return webApp.canSetId(propertyValue);
        }
        if ("description".equals(propertyName)) {
            return webApp.canSetDescription(propertyValue);
        }
        if ("distributable".equals(propertyName)) {
            return true;
        }
        if ("sessionTimeout".equals(propertyName)) {
            Integer timeout = null;
            if (propertyValue != null && propertyValue.length() > 0) {
                try {
                    timeout = Integer.valueOf(propertyValue);
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            }
            return webApp.canSetSessionTimeout(timeout);
        }
        if ("authMethod".equals(propertyName)) {
            if (propertyValue != null && propertyValue.length() == 0) {
                propertyValue = null;
            }
            return webApp.getLoginConfig().canSetAuthMethod(propertyValue);
        }
        if ("realmName".equals(propertyName)) {
            return webApp.getLoginConfig().canSetRealmName(propertyValue);
        }
        if ("formErrorPage".equals(propertyName)) {
            return webApp.getLoginConfig().canSetFormErrorPage(propertyValue);
        }
        if ("formLoginPage".equals(propertyName)) {
            return webApp.getLoginConfig().canSetFormLoginPage(propertyValue);
        }
        if ("displayName".equals(propertyName)) {
            return webApp.getUserInterface().canSetDisplayName(propertyValue);
        }
        if ("largeIcon".equals(propertyName)) {
            return webApp.getUserInterface().canSetLargeIcon(propertyValue);
        }
        if ("smallIcon".equals(propertyName)) {
            return webApp.getUserInterface().canSetSmallIcon(propertyValue);
        }
        return false;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        if (element instanceof ReferenceCollection) {
            element = element.getParent();
        }
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), element.getUniqueName());
        if ("id".equals(propertyName)) {
            webApp.setId(propertyValue);
            return;
        }
        if ("description".equals(propertyName)) {
            webApp.setDescription(propertyValue);
            return;
        }
        if ("distributable".equals(propertyName)) {
            webApp.setDistributable(new Boolean(propertyValue).booleanValue());
            return;
        }
        if ("sessionTimeout".equals(propertyName)) {
            Integer timeout = null;
            if (propertyValue != null && propertyValue.length() > 0) {
                timeout = Integer.valueOf(propertyValue);
            }
            webApp.setSessionTimeout(timeout);
            return;
        }
        if ("authMethod".equals(propertyName)) {
            if (propertyValue != null && propertyValue.length() == 0) {
                propertyValue = null;
            }
            webApp.getLoginConfig().setAuthMethod(propertyValue);
            return;
        }
        if ("realmName".equals(propertyName)) {
            webApp.getLoginConfig().setRealmName(propertyValue);
            return;
        }
        if ("formErrorPage".equals(propertyName)) {
            webApp.getLoginConfig().setFormErrorPage(propertyValue);
            return;
        }
        if ("formLoginPage".equals(propertyName)) {
            webApp.getLoginConfig().setFormLoginPage(propertyValue);
            return;
        }
        if ("displayName".equals(propertyName)) {
            webApp.getUserInterface().setDisplayName(propertyValue);
            return;
        }
        if ("largeIcon".equals(propertyName)) {
            webApp.getUserInterface().setLargeIcon(propertyValue);
            return;
        }
        if ("smallIcon".equals(propertyName)) {
            webApp.getUserInterface().setSmallIcon(propertyValue);
            return;
        }
        this.unknownProperty(propertyName);
    }
}

