/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp;

import com.tssap.j2ee.core.descriptor.SecurityRole;
import com.tssap.j2ee.core.descriptor.SecurityRoleRef;
import com.tssap.j2ee.core.providers.web.WebModelMetaInfo;
import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.web.IFilter;
import com.tssap.j2ee.core.web.IJSP;
import com.tssap.j2ee.core.web.IServlet;
import com.tssap.j2ee.core.web.IWebElement;
import com.tssap.j2ee.core.web.IWebListener;
import com.tssap.j2ee.core.webapp.ContextParameter;
import com.tssap.j2ee.core.webapp.ErrorPage;
import com.tssap.j2ee.core.webapp.Filter;
import com.tssap.j2ee.core.webapp.FilterMapping;
import com.tssap.j2ee.core.webapp.InitParameter;
import com.tssap.j2ee.core.webapp.Listener;
import com.tssap.j2ee.core.webapp.MimeMapping;
import com.tssap.j2ee.core.webapp.SecurityConstraint;
import com.tssap.j2ee.core.webapp.Servlet;
import com.tssap.j2ee.core.webapp.ServletMapping;
import com.tssap.j2ee.core.webapp.TagLibrary;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.core.webapp.WebAppProject;
import com.tssap.j2ee.core.webapp.WebResourceCollection;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppProvidersPlugin;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.providers.proxy.ProxyMetaInfo;
import com.tssap.selena.model.util.ModelUinSupport;
import com.tssap.selena.model.util.UinEscaper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class WebAppModelAccess {
    private WebAppModelAccess() {
    }

    public static WebApp getWebApp(Model model, UniqueName uin) {
        if (model == null || model.isDeleted()) {
            return null;
        }
        IProject project = ModelUinSupport.getProject((UniqueName)model.getUniqueName());
        if (project == null || !project.isAccessible()) {
            return null;
        }
        WebAppProject webAppProject = WebAppProject.getInstance((IProject)project);
        if (webAppProject == null) {
            return null;
        }
        IFile file = project.getFile(WebAppModelMetaInfo.getWebAppFileName(uin));
        return webAppProject.getWebApp(file);
    }

    public static ContextParameter getContextParameter(Model model, UniqueName uin) {
        WebApp webApp = WebAppModelAccess.getWebApp(model, uin);
        if (webApp == null) {
            return null;
        }
        return webApp.getContextParameter(WebAppModelMetaInfo.getContextParameterName(uin));
    }

    public static ErrorPage getErrorPage(Model model, UniqueName uin) {
        WebApp webApp = WebAppModelAccess.getWebApp(model, uin);
        if (webApp == null) {
            return null;
        }
        Integer code = WebAppModelMetaInfo.getErrorPageCode(uin);
        if (code != null) {
            return webApp.getErrorPage(code.intValue());
        }
        return webApp.getErrorPage(WebAppModelMetaInfo.getErrorPageException(uin));
    }

    public static MimeMapping getMimeMapping(Model model, UniqueName uin) {
        WebApp webApp = WebAppModelAccess.getWebApp(model, uin);
        if (webApp == null) {
            return null;
        }
        return webApp.getMimeMapping(UinEscaper.unescape((String)uin.getName()));
    }

    public static SecurityConstraint getSecurityConstraint(Model model, UniqueName uin) {
        WebApp webApp = WebAppModelAccess.getWebApp(model, uin);
        if (webApp == null) {
            return null;
        }
        return webApp.getSecurityConstraint(WebAppModelMetaInfo.getSecurityConstraintName(uin));
    }

    public static SecurityRole getSecurityRole(Model model, UniqueName uin) {
        WebApp webApp = WebAppModelAccess.getWebApp(model, uin);
        if (webApp == null) {
            return null;
        }
        return webApp.getSecurityRole(WebAppModelMetaInfo.getSecurityRoleName(uin));
    }

    public static TagLibrary getTagLibrary(Model model, UniqueName uin) {
        WebApp webApp = WebAppModelAccess.getWebApp(model, uin);
        if (webApp == null) {
            return null;
        }
        return webApp.getTagLibrary(WebAppModelMetaInfo.getTagLibraryUri(uin));
    }

    public static WebResourceCollection getWebResourceCollection(Model model, UniqueName uin) {
        WebApp webApp = WebAppModelAccess.getWebApp(model, uin);
        if (webApp == null) {
            return null;
        }
        String scName = WebAppModelMetaInfo.getWebResourceCollectionSecurityConstraintName(uin);
        SecurityConstraint constraint = webApp.getSecurityConstraint(scName);
        if (constraint == null) {
            return null;
        }
        return constraint.getWebResourceCollection(WebAppModelMetaInfo.getWebResourceCollectionName(uin));
    }

    public static FilterMapping getFilterMapping(Model model, UniqueName uin) {
        WebApp webApp = WebAppModelAccess.getWebApp(model, uin);
        if (webApp == null) {
            return null;
        }
        return webApp.getFilterMapping(WebAppModelMetaInfo.getFilterMappingSyntheticName(uin));
    }

    public static ServletMapping getServletMapping(Model model, UniqueName uin) {
        WebApp webApp = WebAppModelAccess.getWebApp(model, uin);
        if (webApp == null) {
            return null;
        }
        return webApp.getServletMapping(WebAppModelMetaInfo.getServletMappingSyntheticName(uin));
    }

    public static Filter getFilter(Model model, UniqueName uin) {
        if (!ProxyMetaInfo.isProxyUniqueName((UniqueName)uin)) {
            return null;
        }
        UniqueName webAppUin = ProxyMetaInfo.getParentUniqueName((UniqueName)uin);
        if (!WebAppModelMetaInfo.isWebApp(webAppUin)) {
            return null;
        }
        WebApp webApp = WebAppModelAccess.getWebApp(model, webAppUin);
        if (webApp == null) {
            return null;
        }
        if (ProxyMetaInfo.getParametersCount((UniqueName)uin) < 1) {
            return null;
        }
        String filterName = WebAppModelMetaInfo.getFilterName(uin);
        if (filterName == null) {
            return null;
        }
        UniqueName filterUin = ProxyMetaInfo.getSourceUniqueName((UniqueName)uin);
        if (!WebModelMetaInfo.isFilterUniqueName((UniqueName)filterUin)) {
            return null;
        }
        return webApp.getFilter(filterName);
    }

    public static Listener getListener(Model model, UniqueName uin) {
        if (!ProxyMetaInfo.isProxyUniqueName((UniqueName)uin)) {
            return null;
        }
        UniqueName webAppUin = ProxyMetaInfo.getParentUniqueName((UniqueName)uin);
        if (!WebAppModelMetaInfo.isWebApp(webAppUin)) {
            return null;
        }
        WebApp webApp = WebAppModelAccess.getWebApp(model, webAppUin);
        if (webApp == null) {
            return null;
        }
        UniqueName listenerUin = ProxyMetaInfo.getSourceUniqueName((UniqueName)uin);
        if (!WebModelMetaInfo.isWebListener((UniqueName)listenerUin)) {
            return null;
        }
        String className = listenerUin.getName();
        String packageName = listenerUin.getLocation();
        if (packageName != null && packageName.trim().length() > 0) {
            className = packageName + '.' + className;
        }
        return webApp.getListener(className);
    }

    public static Servlet getServlet(Model model, UniqueName uin) {
        if (!ProxyMetaInfo.isProxyUniqueName((UniqueName)uin)) {
            return null;
        }
        UniqueName webAppUin = ProxyMetaInfo.getParentUniqueName((UniqueName)uin);
        if (!WebAppModelMetaInfo.isWebApp(webAppUin)) {
            return null;
        }
        WebApp webApp = WebAppModelAccess.getWebApp(model, webAppUin);
        if (webApp == null) {
            return null;
        }
        if (ProxyMetaInfo.getParametersCount((UniqueName)uin) < 1) {
            return null;
        }
        String servletName = WebAppModelMetaInfo.getServletName(uin);
        if (servletName == null) {
            return null;
        }
        UniqueName servletUin = ProxyMetaInfo.getSourceUniqueName((UniqueName)uin);
        if (!WebModelMetaInfo.isServletUniqueName((UniqueName)servletUin) && !WebModelMetaInfo.isJSPUniqueName((UniqueName)servletUin)) {
            return null;
        }
        return webApp.getServlet(servletName);
    }

    public static Filter getContainingFilter(Model model, UniqueName uin) {
        WebApp webApp = WebAppModelAccess.getWebApp(model, uin);
        if (webApp == null) {
            return null;
        }
        if (uin.getParametersCount() < 1) {
            return null;
        }
        String filterName = UinEscaper.unescape((String)uin.getParameter(0));
        if (filterName == null) {
            return null;
        }
        return webApp.getFilter(filterName);
    }

    public static Servlet getContainingServlet(Model model, UniqueName uin) {
        WebApp webApp = WebAppModelAccess.getWebApp(model, uin);
        if (webApp == null) {
            return null;
        }
        if (uin.getParametersCount() < 1) {
            return null;
        }
        String servletName = UinEscaper.unescape((String)uin.getParameter(0));
        if (servletName == null) {
            return null;
        }
        return webApp.getServlet(servletName);
    }

    public static InitParameter getFilterInitParameter(Model model, UniqueName uin) {
        Filter filter = WebAppModelAccess.getContainingFilter(model, uin);
        if (filter == null) {
            return null;
        }
        String parameterName = WebAppModelMetaInfo.getInitParameterName(uin);
        if (parameterName == null) {
            return null;
        }
        return filter.getInitialization().getInitParameter(parameterName);
    }

    public static InitParameter getServletInitParameter(Model model, UniqueName uin) {
        Servlet servlet = WebAppModelAccess.getContainingServlet(model, uin);
        if (servlet == null) {
            return null;
        }
        String parameterName = WebAppModelMetaInfo.getInitParameterName(uin);
        if (parameterName == null) {
            return null;
        }
        return servlet.getInitialization().getInitParameter(parameterName);
    }

    public static SecurityRoleRef getSecurityRoleRef(Model model, UniqueName uin) {
        Servlet servlet = WebAppModelAccess.getContainingServlet(model, uin);
        if (servlet == null) {
            return null;
        }
        String refName = WebAppModelMetaInfo.getSecurityRoleRefName(uin);
        if (refName == null) {
            return null;
        }
        return servlet.getSecurityRoleReference(refName);
    }

    public static UniqueName getFilterUniqueName(IFilter filterRef, String filterName, UniqueName webAppUin) {
        return WebAppModelAccess.getFilterUniqueName(filterRef, filterName, webAppUin, false);
    }

    public static UniqueName getFilterUniqueName(IFilter filterRef, String filterName, UniqueName webAppUin, boolean acceptNonExistent) {
        UniqueName source = WebModelMetaInfo.getUniqueName((IFilter)filterRef);
        if (source == null) {
            return null;
        }
        IProject webProject = filterRef.getWebProject().getProject();
        if (webProject == null) {
            return null;
        }
        UniqueName sourceModel = ModelUinSupport.createModelUin((String)webProject.getName());
        if (!acceptNonExistent && ModelAccess.getModel((UniqueName)sourceModel).findEntity(source) == null) {
            WebAppProvidersPlugin.logWarning("Filter [" + source.getName() + "] is not provided in the model");
            return null;
        }
        return WebAppModelMetaInfo.getFilter(ModelAccess.getModel((UniqueName)sourceModel), source, webAppUin, filterName);
    }

    public static UniqueName getServletUniqueName(IServlet servletRef, String servletName, UniqueName webAppUin) {
        return WebAppModelAccess.getServletUniqueName(servletRef, servletName, webAppUin, false);
    }

    public static UniqueName getServletUniqueName(IServlet servletRef, String servletName, UniqueName webAppUin, boolean acceptNonExistent) {
        UniqueName source = WebModelMetaInfo.getUniqueName((IServlet)servletRef);
        if (source == null) {
            return null;
        }
        IProject webProject = servletRef.getWebProject().getProject();
        if (webProject == null) {
            return null;
        }
        UniqueName sourceModel = ModelUinSupport.createModelUin((String)webProject.getName());
        if (!acceptNonExistent && ModelAccess.getModel((UniqueName)sourceModel).findEntity(source) == null) {
            WebAppProvidersPlugin.logWarning("Servlet [" + source.getName() + "] is not provided in the model");
            return null;
        }
        return WebAppModelMetaInfo.getServlet(ModelAccess.getModel((UniqueName)sourceModel), source, webAppUin, servletName);
    }

    public static UniqueName getJspUniqueName(IJSP jspRef, String jspName, UniqueName webAppUin) {
        return WebAppModelAccess.getJspUniqueName(jspRef, jspName, webAppUin, false);
    }

    public static UniqueName getJspUniqueName(IJSP jspRef, String jspName, UniqueName webAppUin, boolean acceptNonExistent) {
        UniqueName source = WebModelMetaInfo.getUniqueName((IJSP)jspRef);
        if (source == null) {
            return null;
        }
        IProject webProject = jspRef.getWebProject().getProject();
        if (webProject == null) {
            return null;
        }
        UniqueName sourceModel = ModelUinSupport.createModelUin((String)webProject.getName());
        if (!acceptNonExistent && ModelAccess.getModel((UniqueName)sourceModel).findEntity(source) == null) {
            WebAppProvidersPlugin.logWarning("Jsp [" + source.getName() + "] is not provided in the model");
            return null;
        }
        return WebAppModelMetaInfo.getJsp(ModelAccess.getModel((UniqueName)sourceModel), source, webAppUin, jspName);
    }

    public static UniqueName getListenerUniqueName(IWebListener listenerRef, UniqueName webAppUin) {
        return WebAppModelAccess.getListenerUniqueName(listenerRef, webAppUin, false);
    }

    public static UniqueName getListenerUniqueName(IWebListener listenerRef, UniqueName webAppUin, boolean acceptNonExistent) {
        UniqueName source = WebModelMetaInfo.getUniqueName((IWebElement)listenerRef);
        if (source == null) {
            return null;
        }
        IProject webProject = listenerRef.getWebProject().getProject();
        if (webProject == null) {
            return null;
        }
        UniqueName sourceModel = ModelUinSupport.createModelUin((String)webProject.getName());
        if (!acceptNonExistent && ModelAccess.getModel((UniqueName)sourceModel).findEntity(source) == null) {
            WebAppProvidersPlugin.logWarning("Listener [" + source.getName() + "] is not provided in the model");
            return null;
        }
        return WebAppModelMetaInfo.getListener(ModelAccess.getModel((UniqueName)sourceModel), source, webAppUin);
    }
}

