/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp;

import com.tssap.j2ee.core.descriptor.AbstractJ2eeDescriptorProject;
import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.descriptor.Environment;
import com.tssap.j2ee.core.descriptor.SecurityRoleRef;
import com.tssap.j2ee.core.descriptor.UserInterface;
import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.utils.ArrayUtils;
import com.tssap.j2ee.core.webapp.ContextParameter;
import com.tssap.j2ee.core.webapp.Initialization;
import com.tssap.j2ee.core.webapp.LoginConfig;
import com.tssap.j2ee.core.webapp.MimeMapping;
import com.tssap.j2ee.core.webapp.SecurityConstraint;
import com.tssap.j2ee.core.webapp.Servlet;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.core.webapp.WebAppProject;
import com.tssap.j2ee.internal.core.descriptor.AbstractDeltaProvider;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppModelAccess;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppUinSupport;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.delta.DefaultModelDeltaNode;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import org.eclipse.core.resources.IProject;

public final class WebAppDeltaProvider
extends AbstractDeltaProvider {
    public static final String DELTA_KEY_SECURITY_ROLE = "deltaSecurityRole";

    protected UniqueName getUniqueName(DescriptorEntity entity) {
        if (entity instanceof SecurityRoleRef) {
            return null;
        }
        return WebAppUinSupport.getUniqueName(entity);
    }

    protected AbstractJ2eeDescriptorProject getJ2eeProject() {
        return WebAppProject.getInstance((IProject)this.getProject());
    }

    protected DescriptorEntity getProvidedDescriptorEntity(DescriptorEntity entity) {
        if (entity instanceof Environment) {
            return entity.getParent();
        }
        if (entity instanceof UserInterface) {
            return entity.getParent();
        }
        if (entity instanceof LoginConfig) {
            return entity.getParent();
        }
        if (entity instanceof Initialization) {
            return entity.getParent();
        }
        return entity;
    }

    protected UniqueName getParentUin(DescriptorEntity entity) {
        if (entity instanceof MimeMapping) {
            WebApp webApp = (WebApp)entity.getParent();
            return WebAppModelMetaInfo.getMimeMappingRegistry(webApp.getFile());
        }
        if (entity instanceof ContextParameter) {
            WebApp webApp = (WebApp)entity.getParent();
            return WebAppModelMetaInfo.getContextParameterRegistry(webApp.getFile());
        }
        if (entity instanceof WebApp) {
            return this.getModel().getUniqueName();
        }
        return super.getParentUin(entity);
    }

    public void descriptorEntityChanged(DescriptorEntity entity) {
        if ((entity = this.getProvidedDescriptorEntity(entity)) instanceof Servlet) {
            this.processServletChanged((Servlet)entity);
        } else if (entity instanceof SecurityConstraint) {
            this.processSecurityConstraintChanged((SecurityConstraint)entity);
        }
        super.descriptorEntityChanged(entity);
    }

    private void processServletChanged(Servlet servlet) {
        UniqueName parent = (UniqueName)servlet.getUserData(AbstractDeltaProvider.DELTA_KEY);
        UniqueName prev = (UniqueName)servlet.getUserData((Object)DELTA_KEY_SECURITY_ROLE);
        String roleName = servlet.getRunAsRoleName();
        if (roleName == null || roleName.trim().length() == 0) {
            if (prev == null) {
                return;
            }
            servlet.setUserData((Object)DELTA_KEY_SECURITY_ROLE, null);
            this.addDeltaNode(this.getModel(), parent, prev, ModelDeltaNodeKind.DELETED);
            return;
        }
        WebApp webApp = (WebApp)servlet.getParent();
        UniqueName curr = WebAppModelMetaInfo.getServletSecurityRoleLink(webApp.getFile(), roleName, servlet.getName());
        if (prev == null) {
            servlet.setUserData((Object)DELTA_KEY_SECURITY_ROLE, (Object)curr);
            this.addDeltaNode(this.getModel(), parent, curr, ModelDeltaNodeKind.NEW);
            return;
        }
        if (prev.equals(curr)) {
            return;
        }
        servlet.setUserData((Object)DELTA_KEY_SECURITY_ROLE, (Object)curr);
        DefaultModelDeltaNode node = this.addDeltaNode(this.getModel(), parent, curr, prev, ModelDeltaNodeKind.NEW);
        this.addDeltaNode(this.getModel(), node.getParentUniqueName(), prev, curr, ModelDeltaNodeKind.DELETED);
    }

    private void processSecurityConstraintChanged(SecurityConstraint constraint) {
        UniqueName[] added;
        UniqueName parent = (UniqueName)constraint.getUserData(AbstractDeltaProvider.DELTA_KEY);
        WebApp webApp = (WebApp)constraint.getParent();
        Object[] prevNames = (UniqueName[])constraint.getUserData((Object)DELTA_KEY_SECURITY_ROLE);
        String[] roleNames = constraint.getAuthConstraintSecurityRoles();
        Object[] currNames = null;
        if (roleNames != null && roleNames.length > 0) {
            currNames = new UniqueName[roleNames.length];
            int i = 0;
            while (i < roleNames.length) {
                currNames[i] = WebAppModelMetaInfo.getSecurityConstraintSecurityRoleLink(webApp.getFile(), roleNames[i], constraint.getSyntheticName());
                ++i;
            }
        }
        constraint.setUserData((Object)DELTA_KEY_SECURITY_ROLE, currNames);
        UniqueName[] removed = (UniqueName[])ArrayUtils.subtract((Object[])prevNames, (Object[])currNames);
        if (removed != null && removed.length > 0) {
            int i = 0;
            while (i < removed.length) {
                this.addDeltaNode(this.getModel(), parent, removed[i], ModelDeltaNodeKind.DELETED);
                ++i;
            }
        }
        if ((added = (UniqueName[])ArrayUtils.subtract((Object[])currNames, (Object[])prevNames)) != null && added.length > 0) {
            int i = 0;
            while (i < added.length) {
                this.addDeltaNode(this.getModel(), parent, added[i], ModelDeltaNodeKind.NEW);
                ++i;
            }
        }
    }

    protected DefaultModelDeltaNode addDeltaNode(Model model, UniqueName parentUin, UniqueName uin, UniqueName originalUin, ModelDeltaNodeKind kind) {
        if (parentUin != null && WebAppModelMetaInfo.isMimeMappingRegistry(parentUin)) {
            WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parentUin);
            UniqueName webAppUin = WebAppModelMetaInfo.getWebApp(webApp.getFile());
            super.addDeltaNode(model, webAppUin, parentUin, ModelDeltaNodeKind.CHANGED);
        }
        return super.addDeltaNode(model, parentUin, uin, originalUin, kind);
    }
}

