/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp;

import com.tssap.j2ee.core.descriptor.AbstractJ2eeDescriptorProject;
import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.descriptor.Environment;
import com.tssap.j2ee.core.descriptor.SecurityRoleRef;
import com.tssap.j2ee.core.descriptor.UserInterface;
import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.utils.ArrayUtils;
import com.tssap.j2ee.core.webapp.ContextParameter;
import com.tssap.j2ee.core.webapp.FilterMapping;
import com.tssap.j2ee.core.webapp.Initialization;
import com.tssap.j2ee.core.webapp.LoginConfig;
import com.tssap.j2ee.core.webapp.MimeMapping;
import com.tssap.j2ee.core.webapp.SecurityConstraint;
import com.tssap.j2ee.core.webapp.Servlet;
import com.tssap.j2ee.core.webapp.ServletMapping;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.core.webapp.WebAppProject;
import com.tssap.j2ee.internal.core.descriptor.AbstractDeferredDeltaProvider;
import com.tssap.j2ee.internal.core.descriptor.DescriptorChangesTracker;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppModelAccess;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppUinSupport;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.delta.DefaultModelDeltaNode;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import com.tssap.selena.model.util.delta.RootModelDeltaNode;
import org.eclipse.core.resources.IProject;

public final class WebAppDeferredDeltaProvider
extends AbstractDeferredDeltaProvider {
    public static final String DELTA_KEY_SECURITY_ROLE = "deltaSecurityRole";

    protected UniqueName getUniqueName(DescriptorEntity entity) {
        if (entity instanceof SecurityRoleRef) {
            return null;
        }
        return WebAppUinSupport.getUniqueName(entity);
    }

    protected AbstractJ2eeDescriptorProject getJ2eeProject() {
        return WebAppProject.getInstance((IProject)this.getProject());
    }

    protected DescriptorEntity getProvidedDescriptorEntity(DescriptorEntity entity) {
        if (entity instanceof Environment) {
            return entity.getParent();
        }
        if (entity instanceof UserInterface) {
            return entity.getParent();
        }
        if (entity instanceof LoginConfig) {
            return entity.getParent();
        }
        if (entity instanceof Initialization) {
            return entity.getParent();
        }
        return entity;
    }

    protected UniqueName getParentUin(DescriptorEntity entity) {
        if (entity instanceof MimeMapping) {
            WebApp webApp = (WebApp)entity.getParent();
            return WebAppModelMetaInfo.getMimeMappingRegistry(webApp.getFile());
        }
        if (entity instanceof ContextParameter) {
            WebApp webApp = (WebApp)entity.getParent();
            return WebAppModelMetaInfo.getContextParameterRegistry(webApp.getFile());
        }
        if (entity instanceof FilterMapping || entity instanceof ServletMapping) {
            WebApp webApp = (WebApp)entity.getParent();
            return WebAppModelMetaInfo.getMappingsRegistry(webApp.getFile());
        }
        if (entity instanceof WebApp) {
            return this.getModel().getUniqueName();
        }
        return super.getParentUin(entity);
    }

    protected DescriptorChangesTracker.ChangeRecord createChangeRecord(DescriptorEntity entity) {
        if (entity instanceof Servlet) {
            ServletChangeRecord cr = new ServletChangeRecord();
            cr.mySecurityRoleOldUin = (UniqueName)entity.getUserData((Object)DELTA_KEY_SECURITY_ROLE);
            Servlet servlet = (Servlet)entity;
            String roleName = servlet.getRunAsRoleName();
            if (roleName != null) {
                WebApp webApp = (WebApp)servlet.getParent();
                cr.mySecurityRoleNewUin = WebAppModelMetaInfo.getServletSecurityRoleLink(webApp.getFile(), roleName, servlet.getName());
            }
            entity.setUserData((Object)DELTA_KEY_SECURITY_ROLE, (Object)cr.mySecurityRoleNewUin);
            return cr;
        }
        if (entity instanceof SecurityConstraint) {
            SecurityConstraintChangeRecord cr = new SecurityConstraintChangeRecord();
            cr.mySecurityRoleOldUins = (UniqueName[])entity.getUserData((Object)DELTA_KEY_SECURITY_ROLE);
            SecurityConstraint constraint = (SecurityConstraint)entity;
            WebApp webApp = (WebApp)constraint.getParent();
            String[] roleNames = constraint.getAuthConstraintSecurityRoles();
            if (roleNames != null && roleNames.length > 0) {
                cr.mySecurityRoleNewUins = new UniqueName[roleNames.length];
                int i = 0;
                while (i < roleNames.length) {
                    cr.mySecurityRoleNewUins[i] = WebAppModelMetaInfo.getSecurityConstraintSecurityRoleLink(webApp.getFile(), roleNames[i], constraint.getSyntheticName());
                    ++i;
                }
            }
            constraint.setUserData((Object)DELTA_KEY_SECURITY_ROLE, (Object)cr.mySecurityRoleNewUins);
            return cr;
        }
        return super.createChangeRecord(entity);
    }

    protected void handleChangedDescriptorEntity(RootModelDeltaNode deltaRoot, DescriptorChangesTracker.ChangeRecord cr) {
        DescriptorEntity entity = cr.myEntity;
        if (entity instanceof Servlet) {
            if (cr instanceof ServletChangeRecord) {
                ServletChangeRecord xcr = (ServletChangeRecord)cr;
                this.handleChangedServlet(deltaRoot, xcr);
            } else {
                DescriptorChangesTracker.invalidChangeRecord((DescriptorChangesTracker.ChangeRecord)cr);
            }
        } else if (entity instanceof SecurityConstraint) {
            if (cr instanceof SecurityConstraintChangeRecord) {
                SecurityConstraintChangeRecord xcr = (SecurityConstraintChangeRecord)cr;
                this.handleChangedSecurityConstraint(deltaRoot, xcr);
            } else {
                DescriptorChangesTracker.invalidChangeRecord((DescriptorChangesTracker.ChangeRecord)cr);
            }
        }
        super.handleChangedDescriptorEntity(deltaRoot, cr);
    }

    private void handleChangedServlet(RootModelDeltaNode deltaRoot, ServletChangeRecord cr) {
        UniqueName parent = cr.myOldUin;
        UniqueName prev = cr.mySecurityRoleOldUin;
        UniqueName curr = cr.mySecurityRoleNewUin;
        if (curr == null) {
            if (prev == null) {
                return;
            }
            this.addDeltaNode(deltaRoot, this.getModel(), parent, prev, ModelDeltaNodeKind.DELETED);
            return;
        }
        if (prev == null) {
            this.addDeltaNode(deltaRoot, this.getModel(), parent, curr, ModelDeltaNodeKind.NEW);
            return;
        }
        if (prev.equals(curr)) {
            return;
        }
        DefaultModelDeltaNode node = this.addDeltaNode(deltaRoot, this.getModel(), parent, curr, prev, ModelDeltaNodeKind.NEW);
        this.addDeltaNode(deltaRoot, this.getModel(), node.getParentUniqueName(), prev, curr, ModelDeltaNodeKind.DELETED);
    }

    private void handleChangedSecurityConstraint(RootModelDeltaNode deltaRoot, SecurityConstraintChangeRecord cr) {
        UniqueName[] added;
        UniqueName parent = cr.myOldUin;
        Object[] prevNames = cr.mySecurityRoleOldUins;
        Object[] currNames = cr.mySecurityRoleNewUins;
        UniqueName[] removed = (UniqueName[])ArrayUtils.subtract((Object[])prevNames, (Object[])currNames);
        if (removed != null && removed.length > 0) {
            int i = 0;
            while (i < removed.length) {
                this.addDeltaNode(deltaRoot, this.getModel(), parent, removed[i], ModelDeltaNodeKind.DELETED);
                ++i;
            }
        }
        if ((added = (UniqueName[])ArrayUtils.subtract((Object[])currNames, (Object[])prevNames)) != null && added.length > 0) {
            int i = 0;
            while (i < added.length) {
                this.addDeltaNode(deltaRoot, this.getModel(), parent, added[i], ModelDeltaNodeKind.NEW);
                ++i;
            }
        }
    }

    protected DefaultModelDeltaNode addDeltaNode(RootModelDeltaNode deltaRoot, Model model, UniqueName parentUin, UniqueName uin, UniqueName originalUin, ModelDeltaNodeKind kind) {
        if (parentUin != null && WebAppModelMetaInfo.isMimeMappingRegistry(parentUin)) {
            WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parentUin);
            UniqueName webAppUin = WebAppModelMetaInfo.getWebApp(webApp.getFile());
            super.addDeltaNode(deltaRoot, model, webAppUin, parentUin, ModelDeltaNodeKind.CHANGED);
        }
        return super.addDeltaNode(deltaRoot, model, parentUin, uin, originalUin, kind);
    }

    private static class SecurityConstraintChangeRecord
    extends DescriptorChangesTracker.ChangeRecord {
        public UniqueName[] mySecurityRoleOldUins;
        public UniqueName[] mySecurityRoleNewUins;

        private SecurityConstraintChangeRecord() {
        }

        public String toString() {
            StringBuffer s = new StringBuffer(super.toString());
            s.append(" ");
            s.append(DescriptorChangesTracker.toString((UniqueName[])this.mySecurityRoleOldUins));
            s.append(" -> ");
            s.append(DescriptorChangesTracker.toString((UniqueName[])this.mySecurityRoleNewUins));
            return s.toString();
        }
    }

    private static class ServletChangeRecord
    extends DescriptorChangesTracker.ChangeRecord {
        public UniqueName mySecurityRoleOldUin;
        public UniqueName mySecurityRoleNewUin;

        private ServletChangeRecord() {
        }

        public String toString() {
            StringBuffer s = new StringBuffer(super.toString());
            s.append(" ");
            s.append(this.mySecurityRoleOldUin);
            s.append(" -> ");
            s.append(this.mySecurityRoleNewUin);
            return s.toString();
        }
    }
}

