/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp;

import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.webapp.TagLibrary;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.core.webapp.namegen.TagLibraryNameGen;
import com.tssap.j2ee.internal.core.descriptor.AbstractDeltaProvider;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ExistenceProviderEx;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;

public final class TagLibraryProvider
extends AbstractProvider
implements EntityExistenceProvider,
ExistenceProviderEx,
ChildrenProvider {
    private static final String DEFAULT_LOCATION = "util.tld";

    public boolean isDeleteProviderApplicable(Element element) {
        return WebAppModelMetaInfo.isTagLibrary(element.getUniqueName());
    }

    public boolean isDeleted(Element element) {
        return WebAppModelAccess.getTagLibrary(this.getModel(), element.getUniqueName()) == null;
    }

    public boolean exists(UniqueName uin) {
        if (!WebAppModelMetaInfo.isTagLibrary(uin)) {
            return false;
        }
        return WebAppModelAccess.getTagLibrary(this.getModel(), uin) != null;
    }

    private String genName(WebApp webApp, String name) {
        TagLibraryNameGen gen = new TagLibraryNameGen(webApp);
        return gen.getUniqueName(name == null ? "/util1" : name);
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        String location;
        String uri;
        if (!"com.tssap.j2ee.core.webapp.TagLibrary".equals(shapeType)) {
            return false;
        }
        if (!WebAppModelMetaInfo.isWebApp(parent.getUniqueName())) {
            return false;
        }
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (webApp == null) {
            return false;
        }
        if (template == null) {
            uri = this.genName(webApp, null);
            location = DEFAULT_LOCATION;
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            uri = this.genName(webApp, template.getPropertyValue("uri"));
            location = template.getPropertyValue("location");
        }
        return webApp.canCreateTagLibrary(uri, location);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        String location;
        String uri;
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (template == null) {
            uri = this.genName(webApp, null);
            location = DEFAULT_LOCATION;
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            uri = this.genName(webApp, template.getPropertyValue("uri"));
            location = template.getPropertyValue("location");
        }
        TagLibrary library = webApp.createTagLibrary(uri, location);
        if (library == null) {
            return null;
        }
        return WebAppModelMetaInfo.getTagLibrary(webApp.getFile(), library.getUri());
    }

    public boolean canDelete(Element element) {
        TagLibrary library = WebAppModelAccess.getTagLibrary(this.getModel(), element.getUniqueName());
        return library != null && library.canDelete();
    }

    public void delete(Element element) {
        TagLibrary library = WebAppModelAccess.getTagLibrary(this.getModel(), element.getUniqueName());
        library.delete();
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return WebAppModelMetaInfo.isWebApp(parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (webApp == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        TagLibrary[] libraries = webApp.getTagLibraries();
        if (libraries == null || libraries.length == 0) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        ArrayList<UniqueName> uins = new ArrayList<UniqueName>(libraries.length);
        int i = 0;
        while (i < libraries.length) {
            UniqueName uin = WebAppModelMetaInfo.getTagLibrary(webApp.getFile(), libraries[i].getUri());
            libraries[i].setUserData(AbstractDeltaProvider.DELTA_KEY, (Object)uin);
            uins.add(uin);
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }
}

