/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp;

import com.tssap.j2ee.core.descriptor.SecurityRole;
import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.core.webapp.namegen.SecurityRoleNameGen;
import com.tssap.j2ee.internal.core.descriptor.AbstractDeltaProvider;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ExistenceProviderEx;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;

public final class SecurityRoleProvider
extends AbstractProvider
implements EntityExistenceProvider,
ExistenceProviderEx,
ChildrenProvider {
    public boolean isDeleteProviderApplicable(Element element) {
        return WebAppModelMetaInfo.isSecurityRole(element.getUniqueName());
    }

    public boolean isDeleted(Element element) {
        return WebAppModelAccess.getSecurityRole(this.getModel(), element.getUniqueName()) == null;
    }

    public boolean exists(UniqueName uin) {
        if (!WebAppModelMetaInfo.isSecurityRole(uin)) {
            return false;
        }
        return WebAppModelAccess.getSecurityRole(this.getModel(), uin) != null;
    }

    private String genName(WebApp webApp, String name) {
        SecurityRoleNameGen gen = new SecurityRoleNameGen(webApp);
        return gen.getUniqueName(name == null ? "role1" : name);
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        String description;
        String name;
        if (!"com.tssap.j2ee.core.webapp.SecurityRole".equals(shapeType)) {
            return false;
        }
        if (!WebAppModelMetaInfo.isWebApp(parent.getUniqueName())) {
            return false;
        }
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (webApp == null) {
            return false;
        }
        if (template == null) {
            name = this.genName(webApp, null);
            description = null;
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            name = this.genName(webApp, template.getPropertyValue("$name"));
            description = template.getPropertyValue("description");
        }
        return webApp.canCreateSecurityRole(name, description);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        String description;
        String name;
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (template == null) {
            name = this.genName(webApp, null);
            description = null;
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            name = this.genName(webApp, template.getPropertyValue("$name"));
            description = template.getPropertyValue("description");
        }
        SecurityRole role = webApp.createSecurityRole(name, description);
        if (role == null) {
            return null;
        }
        return WebAppModelMetaInfo.getSecurityRole(webApp.getFile(), role.getName());
    }

    public boolean canDelete(Element element) {
        SecurityRole role = WebAppModelAccess.getSecurityRole(this.getModel(), element.getUniqueName());
        return role != null && role.canDelete();
    }

    public void delete(Element element) {
        SecurityRole role = WebAppModelAccess.getSecurityRole(this.getModel(), element.getUniqueName());
        role.delete();
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return WebAppModelMetaInfo.isWebApp(parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (webApp == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        SecurityRole[] roles = webApp.getSecurityRoles();
        if (roles == null || roles.length == 0) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        ArrayList<UniqueName> uins = new ArrayList<UniqueName>(roles.length);
        int i = 0;
        while (i < roles.length) {
            UniqueName uin = WebAppModelMetaInfo.getSecurityRole(webApp.getFile(), roles[i].getName());
            roles[i].setUserData(AbstractDeltaProvider.DELTA_KEY, (Object)uin);
            uins.add(uin);
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }
}

