/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp;

import com.tssap.j2ee.core.descriptor.SecurityRole;
import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.utils.ArrayUtils;
import com.tssap.j2ee.core.webapp.SecurityConstraint;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ElementEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ExistenceProviderEx;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;

public final class SecurityConstraintSecurityRoleProvider
extends AbstractProvider
implements EntityExistenceProvider,
ExistenceProviderEx,
ChildrenProvider {
    public boolean isDeleteProviderApplicable(Element element) {
        return WebAppModelMetaInfo.isSecurityConstraintSecurityRoleLink(element.getUniqueName());
    }

    private boolean linkExists(UniqueName uin) {
        UniqueName roleUin = WebAppModelMetaInfo.getSecurityConstraintSecurityRoleLinkSecurityRole(uin);
        SecurityRole role = WebAppModelAccess.getSecurityRole(this.getModel(), roleUin);
        if (role == null) {
            return false;
        }
        String constraintName = WebAppModelMetaInfo.getSecurityConstraintSecurityRoleLinkSecurityConstraintName(uin);
        if (constraintName == null) {
            return false;
        }
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), uin);
        if (webApp == null) {
            return false;
        }
        SecurityConstraint constraint = webApp.getSecurityConstraint(constraintName);
        if (constraint == null) {
            return false;
        }
        return ArrayUtils.contains((Object[])constraint.getAuthConstraintSecurityRoles(), (Object)role.getName());
    }

    public boolean isDeleted(Element element) {
        return !this.linkExists(element.getUniqueName());
    }

    public boolean exists(UniqueName uin) {
        if (!WebAppModelMetaInfo.isSecurityConstraintSecurityRoleLink(uin)) {
            return false;
        }
        return this.linkExists(uin);
    }

    private SecurityRole readLink(Entity template) {
        ElementEnumeration roleEnum = template.participants("Supplier");
        if (!roleEnum.hasMoreElements()) {
            return null;
        }
        Element roleElement = roleEnum.next();
        UniqueName roleUin = roleElement.getUniqueName();
        if (!WebAppModelMetaInfo.isSecurityRole(roleUin)) {
            return null;
        }
        return WebAppModelAccess.getSecurityRole(this.getModel(), roleUin);
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        String link;
        if (!"com.tssap.j2ee.core.webapp.SecurityRoleLink".equals(shapeType)) {
            return false;
        }
        if (!WebAppModelMetaInfo.isSecurityConstraint(parent.getUniqueName())) {
            return false;
        }
        SecurityConstraint constraint = WebAppModelAccess.getSecurityConstraint(this.getModel(), parent.getUniqueName());
        if (constraint == null) {
            return false;
        }
        WebApp webApp = (WebApp)constraint.getParent();
        if (webApp == null) {
            return false;
        }
        if (template == null) {
            return false;
        }
        Object pastedRole = template.getObjectPropertyValue("$pastedElement");
        Object source = template.getObjectPropertyValue("$elementToClone");
        if (source instanceof Entity) {
            template = (Entity)source;
        }
        if (pastedRole instanceof Entity) {
            link = ((Entity)pastedRole).getPropertyValue("$name");
        } else {
            link = template.getPropertyValue("roleLink");
            SecurityRole linkedRole = this.readLink(template);
            if (linkedRole != null) {
                link = linkedRole.getName();
            }
        }
        String[] roles = ArrayUtils.addString((String[])constraint.getAuthConstraintSecurityRoles(), (String)link);
        return constraint.canSetAuthConstraintSecurityRoles(roles);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        String link;
        SecurityConstraint constraint = WebAppModelAccess.getSecurityConstraint(this.getModel(), parent.getUniqueName());
        WebApp webApp = (WebApp)constraint.getParent();
        Object pastedRole = template.getObjectPropertyValue("$pastedElement");
        Object source = template.getObjectPropertyValue("$elementToClone");
        if (source instanceof Entity) {
            template = (Entity)source;
        }
        if (pastedRole instanceof Entity) {
            link = ((Entity)pastedRole).getPropertyValue("$name");
        } else {
            link = template.getPropertyValue("roleLink");
            SecurityRole linkedRole = this.readLink(template);
            if (linkedRole != null) {
                link = linkedRole.getName();
            }
        }
        String[] roles = ArrayUtils.addString((String[])constraint.getAuthConstraintSecurityRoles(), (String)link);
        constraint.setAuthConstraintSecurityRoles(roles);
        return WebAppModelMetaInfo.getSecurityConstraintSecurityRoleLink(webApp.getFile(), link, constraint.getSyntheticName());
    }

    public boolean canDelete(Element element) {
        Entity constraintEntity = element.getParent();
        if (constraintEntity == null) {
            return false;
        }
        SecurityConstraint constraint = WebAppModelAccess.getSecurityConstraint(this.getModel(), constraintEntity.getUniqueName());
        if (constraint == null) {
            return false;
        }
        String link = WebAppModelMetaInfo.getSecurityConstraintSecurityRoleLinkSecurityRoleName(element.getUniqueName());
        String[] roles = ArrayUtils.removeString((String[])constraint.getAuthConstraintSecurityRoles(), (String)link);
        return constraint.canSetAuthConstraintSecurityRoles(roles);
    }

    public void delete(Element element) {
        Entity constraintEntity = element.getParent();
        SecurityConstraint constraint = WebAppModelAccess.getSecurityConstraint(this.getModel(), constraintEntity.getUniqueName());
        String link = WebAppModelMetaInfo.getSecurityConstraintSecurityRoleLinkSecurityRoleName(element.getUniqueName());
        String[] roles = ArrayUtils.removeString((String[])constraint.getAuthConstraintSecurityRoles(), (String)link);
        constraint.setAuthConstraintSecurityRoles(roles);
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return WebAppModelMetaInfo.isSecurityConstraint(parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        SecurityConstraint constraint = WebAppModelAccess.getSecurityConstraint(this.getModel(), parent.getUniqueName());
        if (constraint == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        String[] links = constraint.getAuthConstraintSecurityRoles();
        if (links == null || links.length == 0) {
            constraint.setUserData((Object)"deltaSecurityRole", null);
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        WebApp webApp = (WebApp)constraint.getParent();
        ArrayList<UniqueName> uins = new ArrayList<UniqueName>(links.length);
        int i = 0;
        while (i < links.length) {
            uins.add(WebAppModelMetaInfo.getSecurityConstraintSecurityRoleLink(webApp.getFile(), links[i], constraint.getSyntheticName()));
            ++i;
        }
        constraint.setUserData((Object)"deltaSecurityRole", (Object)uins.toArray(new UniqueName[uins.size()]));
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }
}

