/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp;

import com.tssap.j2ee.core.descriptor.SecurityRole;
import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.utils.ArrayUtils;
import com.tssap.j2ee.core.webapp.SecurityConstraint;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.extension.AbstractLinkProvider;

public final class SecurityConstraintSecurityRoleLinkProvider
extends AbstractLinkProvider {
    public boolean isLinkProviderApplicable(Entity link) {
        return WebAppModelMetaInfo.isSecurityConstraintSecurityRoleLink(link.getUniqueName());
    }

    protected UniqueName getClient(Entity link) {
        Entity constraint = link.getParent();
        if (constraint == null) {
            return null;
        }
        return constraint.getUniqueName();
    }

    protected UniqueName getSupplier(Entity link) {
        SecurityConstraint constraint = WebAppModelAccess.getSecurityConstraint(this.getModel(), link.getUniqueName());
        if (constraint == null) {
            return null;
        }
        WebApp webApp = (WebApp)constraint.getParent();
        if (webApp == null) {
            return null;
        }
        String roleName = WebAppModelMetaInfo.getSecurityConstraintSecurityRoleLinkSecurityRoleName(link.getUniqueName());
        if (roleName == null || webApp.getSecurityRole(roleName) == null) {
            return null;
        }
        return WebAppModelMetaInfo.getSecurityRole(webApp.getFile(), roleName);
    }

    protected boolean canSetSupplier(Entity link, Element oldParticipant, Element newParticipant) {
        if (!WebAppModelMetaInfo.isSecurityRole(newParticipant.getUniqueName())) {
            return false;
        }
        SecurityRole securityRole = WebAppModelAccess.getSecurityRole(this.getModel(), newParticipant.getUniqueName());
        if (securityRole == null) {
            return false;
        }
        Entity constraintEntity = link.getParent();
        if (constraintEntity == null) {
            return false;
        }
        SecurityConstraint constraint = WebAppModelAccess.getSecurityConstraint(this.getModel(), constraintEntity.getUniqueName());
        if (constraint == null) {
            return false;
        }
        String oldRole = WebAppModelMetaInfo.getSecurityConstraintSecurityRoleLinkSecurityRoleName(link.getUniqueName());
        String[] roles = ArrayUtils.replaceString((String[])constraint.getAuthConstraintSecurityRoles(), (String)oldRole, (String)securityRole.getName());
        return constraint.canSetAuthConstraintSecurityRoles(roles);
    }

    protected void setSupplier(Entity link, Element oldParticipant, Element newParticipant) {
        SecurityRole securityRole = WebAppModelAccess.getSecurityRole(this.getModel(), newParticipant.getUniqueName());
        Entity constraintEntity = link.getParent();
        SecurityConstraint constraint = WebAppModelAccess.getSecurityConstraint(this.getModel(), constraintEntity.getUniqueName());
        String oldRole = WebAppModelMetaInfo.getSecurityConstraintSecurityRoleLinkSecurityRoleName(link.getUniqueName());
        String[] roles = ArrayUtils.replaceString((String[])constraint.getAuthConstraintSecurityRoles(), (String)oldRole, (String)securityRole.getName());
        constraint.setAuthConstraintSecurityRoles(roles);
    }
}

