/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp;

import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.webapp.SecurityConstraint;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.internal.core.descriptor.AbstractDeltaProvider;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ExistenceProviderEx;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;

public final class SecurityConstraintProvider
extends AbstractProvider
implements EntityExistenceProvider,
ExistenceProviderEx,
ChildrenProvider {
    public boolean isDeleteProviderApplicable(Element element) {
        return WebAppModelMetaInfo.isSecurityConstraint(element.getUniqueName());
    }

    public boolean isDeleted(Element element) {
        return WebAppModelAccess.getSecurityConstraint(this.getModel(), element.getUniqueName()) == null;
    }

    public boolean exists(UniqueName uin) {
        if (!WebAppModelMetaInfo.isSecurityConstraint(uin)) {
            return false;
        }
        return WebAppModelAccess.getSecurityConstraint(this.getModel(), uin) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        String dcTransportGuarantee;
        String dcDescription;
        String[] acSecurityRoles;
        String acDescription;
        String displayName;
        if (!"com.tssap.j2ee.core.webapp.SecurityConstraint".equals(shapeType)) {
            return false;
        }
        if (!WebAppModelMetaInfo.isWebApp(parent.getUniqueName())) {
            return false;
        }
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (webApp == null) {
            return false;
        }
        if (template == null) {
            displayName = null;
            acDescription = null;
            acSecurityRoles = null;
            dcDescription = null;
            dcTransportGuarantee = null;
            return webApp.canCreateSecurityConstraint(displayName, acDescription, acSecurityRoles, dcDescription, dcTransportGuarantee);
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            displayName = template.getPropertyValue("displayName");
            acDescription = template.getPropertyValue("authConstraintDescription");
            Object acSecurityRolesObj = template.getObjectPropertyValue("authConstraintSecurityRoles");
            if (acSecurityRolesObj != null) {
                if (!(acSecurityRolesObj instanceof String[])) return false;
                acSecurityRoles = (String[])acSecurityRolesObj;
            } else {
                acSecurityRoles = null;
            }
            dcDescription = template.getPropertyValue("userDataConstraintDescription");
            dcTransportGuarantee = template.getPropertyValue("userDataConstraintTransportGuarantee");
        }
        return webApp.canCreateSecurityConstraint(displayName, acDescription, acSecurityRoles, dcDescription, dcTransportGuarantee);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        String dcTransportGuarantee;
        String dcDescription;
        String[] acSecurityRoles;
        String acDescription;
        String displayName;
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (template == null) {
            displayName = null;
            acDescription = null;
            acSecurityRoles = null;
            dcDescription = null;
            dcTransportGuarantee = null;
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            displayName = template.getPropertyValue("displayName");
            acDescription = template.getPropertyValue("authConstraintDescription");
            Object acSecurityRolesObj = template.getObjectPropertyValue("authConstraintSecurityRoles");
            acSecurityRoles = acSecurityRolesObj != null ? (String[])acSecurityRolesObj : null;
            dcDescription = template.getPropertyValue("userDataConstraintDescription");
            dcTransportGuarantee = template.getPropertyValue("userDataConstraintTransportGuarantee");
        }
        SecurityConstraint constraint = webApp.createSecurityConstraint(displayName, acDescription, acSecurityRoles, dcDescription, dcTransportGuarantee);
        if (constraint == null) {
            return null;
        }
        return WebAppModelMetaInfo.getSecurityConstraint(webApp.getFile(), constraint.getSyntheticName());
    }

    public boolean canDelete(Element element) {
        SecurityConstraint constraint = WebAppModelAccess.getSecurityConstraint(this.getModel(), element.getUniqueName());
        return constraint != null && constraint.canDelete();
    }

    public void delete(Element element) {
        SecurityConstraint constraint = WebAppModelAccess.getSecurityConstraint(this.getModel(), element.getUniqueName());
        constraint.delete();
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return WebAppModelMetaInfo.isWebApp(parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (webApp == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        SecurityConstraint[] constraints = webApp.getSecurityConstraints();
        if (constraints == null || constraints.length == 0) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        ArrayList<UniqueName> uins = new ArrayList<UniqueName>(constraints.length);
        int i = 0;
        while (i < constraints.length) {
            UniqueName uin = WebAppModelMetaInfo.getSecurityConstraint(webApp.getFile(), constraints[i].getSyntheticName());
            constraints[i].setUserData(AbstractDeltaProvider.DELTA_KEY, (Object)uin);
            uins.add(uin);
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }
}

