/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp;

import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.webapp.MimeMapping;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.core.webapp.namegen.MimeMappingNameGen;
import com.tssap.j2ee.internal.core.descriptor.AbstractDeltaProvider;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ExistenceProviderEx;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;

public final class MimeMappingProvider
extends AbstractProvider
implements EntityExistenceProvider,
ExistenceProviderEx,
ChildrenProvider {
    private static final String DEFAULT_TYPE = "text/plain";

    public boolean isDeleteProviderApplicable(Element element) {
        return WebAppModelMetaInfo.isMimeMapping(element.getUniqueName());
    }

    public boolean isDeleted(Element element) {
        return WebAppModelAccess.getMimeMapping(this.getModel(), element.getUniqueName()) == null;
    }

    public boolean exists(UniqueName uin) {
        if (!WebAppModelMetaInfo.isMimeMapping(uin)) {
            return false;
        }
        return WebAppModelAccess.getMimeMapping(this.getModel(), uin) != null;
    }

    private String genName(WebApp webApp, String name) {
        MimeMappingNameGen gen = new MimeMappingNameGen(webApp);
        return gen.getUniqueName(name == null ? "txt" : name);
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        String type;
        String extension;
        if (!"com.tssap.j2ee.core.webapp.MimeMapping".equals(shapeType)) {
            return false;
        }
        if (!WebAppModelMetaInfo.isMimeMappingRegistry(parent.getUniqueName())) {
            return false;
        }
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (webApp == null) {
            return false;
        }
        if (template == null) {
            extension = this.genName(webApp, null);
            type = DEFAULT_TYPE;
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            extension = this.genName(webApp, template.getPropertyValue("extension"));
            type = template.getPropertyValue("mimeType");
        }
        return webApp.canCreateMimeMapping(extension, type);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        String type;
        String extension;
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (template == null) {
            extension = this.genName(webApp, null);
            type = DEFAULT_TYPE;
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            extension = this.genName(webApp, template.getPropertyValue("extension"));
            type = template.getPropertyValue("mimeType");
        }
        MimeMapping map = webApp.createMimeMapping(extension, type);
        if (map == null) {
            return null;
        }
        return WebAppModelMetaInfo.getMimeMapping(webApp.getFile(), map.getExtension());
    }

    public boolean canDelete(Element element) {
        MimeMapping map = WebAppModelAccess.getMimeMapping(this.getModel(), element.getUniqueName());
        return map != null && map.canDelete();
    }

    public void delete(Element element) {
        MimeMapping map = WebAppModelAccess.getMimeMapping(this.getModel(), element.getUniqueName());
        map.delete();
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return WebAppModelMetaInfo.isMimeMappingRegistry(parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (webApp == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        MimeMapping[] maps = webApp.getMimeMappings();
        if (maps == null || maps.length == 0) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        ArrayList<UniqueName> uins = new ArrayList<UniqueName>(maps.length);
        int i = 0;
        while (i < maps.length) {
            UniqueName uin = WebAppModelMetaInfo.getMimeMapping(webApp.getFile(), maps[i].getExtension());
            maps[i].setUserData(AbstractDeltaProvider.DELTA_KEY, (Object)uin);
            uins.add(uin);
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }
}

