/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp;

import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.webapp.FilterMapping;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.internal.core.descriptor.AbstractDeltaProvider;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ExistenceProviderEx;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;

public final class FilterMappingProvider
extends AbstractProvider
implements EntityExistenceProvider,
ExistenceProviderEx,
ChildrenProvider {
    public static final String DEFAULT_FILTER_NAME = "filter1";
    public static final String DEFAULT_URL_PATTERN = "/filter1";

    public boolean isDeleteProviderApplicable(Element element) {
        return WebAppModelMetaInfo.isFilterMapping(element.getUniqueName());
    }

    public boolean isDeleted(Element element) {
        return WebAppModelAccess.getFilterMapping(this.getModel(), element.getUniqueName()) == null;
    }

    public boolean exists(UniqueName uin) {
        if (!WebAppModelMetaInfo.isFilterMapping(uin)) {
            return false;
        }
        return WebAppModelAccess.getFilterMapping(this.getModel(), uin) != null;
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        String servletName;
        String urlPattern;
        String filterName;
        if (!"com.tssap.j2ee.core.webapp.FilterMapping".equals(shapeType)) {
            return false;
        }
        if (!WebAppModelMetaInfo.isMappingsRegistry(parent.getUniqueName())) {
            return false;
        }
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (webApp == null) {
            return false;
        }
        if (template == null) {
            filterName = DEFAULT_FILTER_NAME;
            urlPattern = DEFAULT_URL_PATTERN;
            servletName = null;
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            filterName = template.getPropertyValue("filterName");
            urlPattern = template.getPropertyValue("urlPattern");
            servletName = template.getPropertyValue("servletName");
        }
        return webApp.canCreateFilterMapping(filterName, urlPattern, servletName);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        String servletName;
        String urlPattern;
        String filterName;
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (template == null) {
            filterName = DEFAULT_FILTER_NAME;
            urlPattern = DEFAULT_URL_PATTERN;
            servletName = null;
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            filterName = template.getPropertyValue("filterName");
            urlPattern = template.getPropertyValue("urlPattern");
            servletName = template.getPropertyValue("servletName");
        }
        FilterMapping mapping = webApp.createFilterMapping(filterName, urlPattern, servletName);
        if (mapping == null) {
            return null;
        }
        return WebAppModelMetaInfo.getFilterMapping(webApp.getFile(), mapping.getSyntheticName());
    }

    public boolean canDelete(Element element) {
        FilterMapping mapping = WebAppModelAccess.getFilterMapping(this.getModel(), element.getUniqueName());
        return mapping != null && mapping.canDelete();
    }

    public void delete(Element element) {
        FilterMapping mapping = WebAppModelAccess.getFilterMapping(this.getModel(), element.getUniqueName());
        mapping.delete();
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return WebAppModelMetaInfo.isMappingsRegistry(parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (webApp == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        FilterMapping[] mappings = webApp.getFilterMappings();
        if (mappings == null || mappings.length == 0) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        ArrayList<UniqueName> uins = new ArrayList<UniqueName>(mappings.length);
        int i = 0;
        while (i < mappings.length) {
            UniqueName uin = WebAppModelMetaInfo.getFilterMapping(webApp.getFile(), mappings[i].getSyntheticName());
            mappings[i].setUserData(AbstractDeltaProvider.DELTA_KEY, (Object)uin);
            uins.add(uin);
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }
}

