/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp;

import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.utils.ArrayUtils;
import com.tssap.j2ee.core.webapp.FilterMapping;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.util.extension.AbstractPropertyWriter;

public final class FilterMappingPropertyProvider
extends AbstractPropertyWriter {
    public FilterMappingPropertyProvider() {
        this.getPropertyNames().add("$ro-name");
        this.getPropertyNames().add("$enableGenericCopy");
        this.getPropertyNames().add("$enableGenericCut");
        this.getPropertyNames().add("id");
        this.getPropertyNames().add("filterName");
        this.getPropertyNames().add("urlPattern");
        this.getPropertyNames().add("servletName");
        this.getPropertyNames().add("mappingOrder");
    }

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        if (!WebAppModelMetaInfo.isFilterMapping(element.getUniqueName())) {
            return false;
        }
        return this.getPropertyNames().contains(propertyName);
    }

    public String getPropertyValue(Element element, String propertyName) {
        FilterMapping mapping = WebAppModelAccess.getFilterMapping(this.getModel(), element.getUniqueName());
        if (mapping == null) {
            return null;
        }
        if ("$ro-name".equals(propertyName)) {
            return Boolean.TRUE.toString();
        }
        if ("$enableGenericCopy".equals(propertyName)) {
            return Boolean.TRUE.toString();
        }
        if ("$enableGenericCut".equals(propertyName)) {
            return Boolean.TRUE.toString();
        }
        if ("id".equals(propertyName)) {
            return mapping.getId();
        }
        if ("filterName".equals(propertyName)) {
            return mapping.getFilterName();
        }
        if ("urlPattern".equals(propertyName)) {
            return mapping.getUrlPattern();
        }
        if ("servletName".equals(propertyName)) {
            return mapping.getServletName();
        }
        if ("mappingOrder".equals(propertyName)) {
            WebApp webApp = (WebApp)mapping.getParent();
            if (webApp == null) {
                return null;
            }
            Object[] mappings = webApp.getFilterMappings();
            int order = ArrayUtils.indexOf((Object[])mappings, (Object)mapping);
            if (order < 0) {
                return null;
            }
            return String.valueOf(order);
        }
        return this.unknownProperty(propertyName);
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        FilterMapping mapping = WebAppModelAccess.getFilterMapping(this.getModel(), element.getUniqueName());
        if (mapping == null) {
            return false;
        }
        if ("id".equals(propertyName)) {
            return mapping.canSetId(propertyValue);
        }
        if ("filterName".equals(propertyName)) {
            return mapping.canSetFilterName(propertyValue);
        }
        if ("urlPattern".equals(propertyName)) {
            return mapping.canSetUrlPattern(propertyValue);
        }
        if ("servletName".equals(propertyName)) {
            return mapping.canSetServletName(propertyValue);
        }
        if ("mappingOrder".equals(propertyName)) {
            int order;
            try {
                order = Integer.parseInt(propertyValue);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            WebApp webApp = (WebApp)mapping.getParent();
            if (webApp == null) {
                return false;
            }
            Object[] mappings = webApp.getFilterMappings();
            if (order < 0 || order >= mappings.length) {
                return false;
            }
            ArrayUtils.move((Object[])mappings, (Object)mapping, (int)order);
            return webApp.canSetFilterMappings((FilterMapping[])mappings);
        }
        return false;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        FilterMapping mapping = WebAppModelAccess.getFilterMapping(this.getModel(), element.getUniqueName());
        if ("id".equals(propertyName)) {
            mapping.setId(propertyValue);
            return;
        }
        if ("filterName".equals(propertyName)) {
            mapping.setFilterName(propertyValue);
            return;
        }
        if ("urlPattern".equals(propertyName)) {
            mapping.setUrlPattern(propertyValue);
            return;
        }
        if ("servletName".equals(propertyName)) {
            mapping.setServletName(propertyValue);
            return;
        }
        if ("mappingOrder".equals(propertyName)) {
            int order;
            try {
                order = Integer.parseInt(propertyValue);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalStateException();
            }
            WebApp webApp = (WebApp)mapping.getParent();
            Object[] mappings = webApp.getFilterMappings();
            ArrayUtils.move((Object[])mappings, (Object)mapping, (int)order);
            webApp.setFilterMappings((FilterMapping[])mappings);
            return;
        }
        this.unknownProperty(propertyName);
    }
}

