/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp;

import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.webapp.ErrorPage;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyUniqueNameProvider;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.SingleEnumeration;
import com.tssap.selena.model.util.extension.AbstractPropertyReader;

public final class ErrorPageReasonProvider
extends AbstractPropertyReader
implements PropertyUniqueNameProvider {
    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        if (!WebAppModelMetaInfo.isErrorPage(element.getUniqueName())) {
            return false;
        }
        return "errorCode".equals(propertyName) || "exceptionType".equals(propertyName);
    }

    public String getPropertyValue(Element element, String propertyName) {
        ErrorPage page = WebAppModelAccess.getErrorPage(this.getModel(), element.getUniqueName());
        if (page == null) {
            return null;
        }
        if ("errorCode".equals(propertyName)) {
            Integer code = page.getCode();
            if (code == null) {
                return null;
            }
            return code.toString();
        }
        return page.getException();
    }

    public PropertyEnumeration properties(Element element) {
        Property code = this.getProperty(element, "errorCode");
        if (code != null) {
            return SingleEnumeration.createPropertyEnumeration((Property)code);
        }
        Property exception = this.getProperty(element, "exceptionType");
        if (exception != null) {
            return SingleEnumeration.createPropertyEnumeration((Property)exception);
        }
        return EmptyEnumeration.getPropertyEnumeration();
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        ErrorPage page = WebAppModelAccess.getErrorPage(this.getModel(), element.getUniqueName());
        if (page == null) {
            return false;
        }
        WebApp webApp = (WebApp)page.getParent();
        if (webApp == null) {
            return false;
        }
        if ("errorCode".equals(propertyName)) {
            Integer code;
            try {
                code = Integer.valueOf(propertyValue);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            return page.canSetReason(code, null);
        }
        if ("exceptionType".equals(propertyName)) {
            return page.canSetReason(null, propertyValue);
        }
        return false;
    }

    public UniqueName setPropertyValue(Element element, String propertyName, String propertyValue) {
        ErrorPage page = WebAppModelAccess.getErrorPage(this.getModel(), element.getUniqueName());
        WebApp webApp = (WebApp)page.getParent();
        if ("errorCode".equals(propertyName)) {
            Integer code;
            try {
                code = Integer.valueOf(propertyValue);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalStateException();
            }
            page.setReason(code, null);
        } else if ("exceptionType".equals(propertyName)) {
            page.setReason(null, propertyValue);
        } else {
            throw new IllegalStateException();
        }
        Integer code = page.getCode();
        UniqueName uin = code != null ? WebAppModelMetaInfo.getErrorPage(webApp.getFile(), code) : WebAppModelMetaInfo.getErrorPage(webApp.getFile(), page.getException());
        return uin;
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        return null;
    }
}

