/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.webapp;

import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.webapp.ErrorPage;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.core.webapp.namegen.ErrorPageNameGen;
import com.tssap.j2ee.internal.core.descriptor.AbstractDeltaProvider;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ExistenceProviderEx;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;

public final class ErrorPageProvider
extends AbstractProvider
implements EntityExistenceProvider,
ExistenceProviderEx,
ChildrenProvider {
    private static final String DEFAULT_LOCATION = "/errorpage.html";

    public boolean isDeleteProviderApplicable(Element element) {
        return WebAppModelMetaInfo.isErrorPage(element.getUniqueName());
    }

    public boolean isDeleted(Element element) {
        return WebAppModelAccess.getErrorPage(this.getModel(), element.getUniqueName()) == null;
    }

    public boolean exists(UniqueName uin) {
        if (!WebAppModelMetaInfo.isErrorPage(uin)) {
            return false;
        }
        return WebAppModelAccess.getErrorPage(this.getModel(), uin) != null;
    }

    private String genName(WebApp webApp, String name) {
        ErrorPageNameGen gen = new ErrorPageNameGen(webApp);
        return gen.getUniqueName(name == null ? "400" : name);
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        String location;
        String exception;
        Integer code;
        if (!"com.tssap.j2ee.core.webapp.ErrorPage".equals(shapeType)) {
            return false;
        }
        if (!WebAppModelMetaInfo.isWebApp(parent.getUniqueName())) {
            return false;
        }
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (webApp == null) {
            return false;
        }
        if (template == null) {
            String name = this.genName(webApp, null);
            try {
                code = Integer.valueOf(name);
                exception = null;
            }
            catch (NumberFormatException nfe) {
                code = null;
                exception = name;
            }
            location = DEFAULT_LOCATION;
        } else {
            String codeStr;
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            if ((codeStr = template.getPropertyValue("errorCode")) != null) {
                codeStr = this.genName(webApp, codeStr);
                try {
                    code = Integer.valueOf(codeStr);
                }
                catch (NumberFormatException nfe) {
                    code = null;
                }
            } else {
                code = null;
            }
            if ((exception = template.getPropertyValue("exceptionType")) != null) {
                exception = this.genName(webApp, exception);
            }
            location = template.getPropertyValue("location");
        }
        if (code != null) {
            return webApp.canCreateErrorPage(code.intValue(), location);
        }
        return webApp.canCreateErrorPage(exception, location);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        ErrorPage page;
        String location;
        String exception;
        Integer code;
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (template == null) {
            String name = this.genName(webApp, null);
            try {
                code = Integer.valueOf(name);
                exception = null;
            }
            catch (NumberFormatException nfe) {
                code = null;
                exception = name;
            }
            location = DEFAULT_LOCATION;
        } else {
            String codeStr;
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            if ((codeStr = template.getPropertyValue("errorCode")) != null) {
                codeStr = this.genName(webApp, codeStr);
                try {
                    code = Integer.valueOf(codeStr);
                }
                catch (NumberFormatException nfe) {
                    code = null;
                }
            } else {
                code = null;
            }
            if ((exception = template.getPropertyValue("exceptionType")) != null) {
                exception = this.genName(webApp, exception);
            }
            location = template.getPropertyValue("location");
        }
        if (code != null) {
            page = webApp.createErrorPage(code.intValue(), location);
            if (page == null) {
                return null;
            }
            return WebAppModelMetaInfo.getErrorPage(webApp.getFile(), page.getCode());
        }
        page = webApp.createErrorPage(exception, location);
        if (page == null) {
            return null;
        }
        return WebAppModelMetaInfo.getErrorPage(webApp.getFile(), page.getException());
    }

    public boolean canDelete(Element element) {
        ErrorPage page = WebAppModelAccess.getErrorPage(this.getModel(), element.getUniqueName());
        return page != null && page.canDelete();
    }

    public void delete(Element element) {
        ErrorPage page = WebAppModelAccess.getErrorPage(this.getModel(), element.getUniqueName());
        page.delete();
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return WebAppModelMetaInfo.isWebApp(parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        WebApp webApp = WebAppModelAccess.getWebApp(this.getModel(), parent.getUniqueName());
        if (webApp == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        ErrorPage[] pages = webApp.getErrorPages();
        if (pages == null || pages.length == 0) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        ArrayList<UniqueName> uins = new ArrayList<UniqueName>(pages.length);
        int i = 0;
        while (i < pages.length) {
            ErrorPage page = pages[i];
            Integer code = page.getCode();
            String exception = page.getException();
            UniqueName uin = code != null ? WebAppModelMetaInfo.getErrorPage(webApp.getFile(), code) : WebAppModelMetaInfo.getErrorPage(webApp.getFile(), exception);
            pages[i].setUserData(AbstractDeltaProvider.DELTA_KEY, (Object)uin);
            uins.add(uin);
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }
}

