/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dii.dtri.util;

import com.tssap.dii.dtri.util.AddToSourceControlDialog;
import com.tssap.dii.dtri.util.CheckoutDialog;
import com.tssap.dii.dtri.util.DtrActionDialog;
import com.tssap.dii.dtri.util.MessageUtil;
import com.tssap.dii.dtri.util.RepositoryServiceException;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.eclipse.ui.SelectActivityDialog;
import com.tssap.dtr.client.eclipse.ui.util.WorkspacesWithDefaultActivity;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.PlatformUI;

public class RepositoryObject {
    public static final int ACTION_NONE = -1;
    public static final int ACTION_ADD_TO_SOURCE_CONTROLL = 0;
    public static final int ACTION_CHECK_OUT_FOR_EDIT = 1;
    public static final int ACTION_CHECK_OUT_FOR_EDIT_EXCLUSIVE = 2;
    public static final int ACTION_CHECK_OUT_FOR_DELETE = 3;
    public static final int ACTION_PING_SERVER = 4;
    public static final int ACTION_REVERT = 5;
    private TracerI theTracer = TracingManager.getTracer((Class)(class$com$tssap$dii$dtri$util$RepositoryObject == null ? (class$com$tssap$dii$dtri$util$RepositoryObject = RepositoryObject.class$("com.tssap.dii.dtri.util.RepositoryObject")) : class$com$tssap$dii$dtri$util$RepositoryObject));
    private String theType;
    private String theName;
    private IProject theProject;
    private DAVTeamProvider theDAVTeamProvider;
    private IVersionedFileSystemManager theVfsManager;
    private IVfsWorkspace theWorkSpace;
    private ArrayList theFilesAndFolders;
    private ArrayList theVfsFolderItems;
    private ArrayList theVfsActivityRecordedFolderItems;
    private ArrayList theVfsFiles;
    private ArrayList theVfsFolders;
    private IVfsActivity theVfsActivity;
    private int theActionPerformed = -1;
    private ResourceRepositoryStatus[] theAddToSourceControlStati;
    private ResourceRepositoryStatus[] theCheckOutForEditStati;
    private ResourceRepositoryStatus[] theCheckOutForEditExclStati;
    private ResourceRepositoryStatus[] theCheckOutForDeleteStati;
    static /* synthetic */ Class class$com$tssap$dii$dtri$util$RepositoryObject;

    public RepositoryObject(String type, String name, IProject project) throws RepositoryServiceException {
        this.theProject = project;
        RepositoryProvider theTeamProvider = RepositoryProvider.getProvider((IProject)project);
        if (theTeamProvider == null) {
            throw new RepositoryServiceException(0);
        }
        this.theDAVTeamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)this.theProject);
        if (this.theDAVTeamProvider == null) {
            throw new RepositoryServiceException(10);
        }
        this.theVfsManager = this.theDAVTeamProvider.getVFSManager();
        if (this.theVfsManager == null) {
            throw new RepositoryServiceException(9);
        }
        this.theType = type;
        this.theName = name;
        this.theFilesAndFolders = new ArrayList();
        this.theVfsFolderItems = new ArrayList();
        this.theVfsActivityRecordedFolderItems = new ArrayList();
        this.theVfsFiles = new ArrayList();
        this.theVfsFolders = new ArrayList();
    }

    public boolean isUserLoggedOn() {
        IVfsContext vfsContext = this.theVfsManager.getCurrentContext();
        if (vfsContext == null) {
            return false;
        }
        String absoluteProjectPath = this.theProject.getLocation().toOSString();
        IVfsRemoteLocator vfsRemoteLocator = vfsContext.getRemoteLocator(absoluteProjectPath);
        boolean isUserLoggedOn = vfsContext.ping(vfsRemoteLocator, 10, 1000, 30000);
        return isUserLoggedOn;
    }

    public ResourceRepositoryStatus getDTRStatus() {
        ResourceRepositoryStatus aStatus = new ResourceRepositoryStatus();
        aStatus.actionId = 4;
        aStatus.status = true;
        aStatus.message = "Okay";
        IVfsContext vfsContext = this.theVfsManager.getCurrentContext();
        if (vfsContext == null) {
            aStatus.message = MessageUtil.getString("Message.Action.Ping.Server.VFSContext.Not.Found");
            aStatus.status = false;
            return aStatus;
        }
        String absoluteProjectPath = this.theProject.getLocation().toOSString();
        IVfsRemoteLocator vfsRemoteLocator = vfsContext.getRemoteLocator(absoluteProjectPath);
        int httpReturnCode = vfsContext.httpPing(vfsRemoteLocator, 10, 1000, 30000);
        if (httpReturnCode >= 400) {
            aStatus.status = false;
            aStatus.message = MessageUtil.format("Message.Action.Ping.Server.HttpErrorCode", new Object[]{new Integer(httpReturnCode)});
        }
        return aStatus;
    }

    public synchronized ResourceRepositoryStatus checkOutForDelete(boolean withDialog, IVfsActivity anActivity) throws RepositoryServiceException {
        if (this.theActionPerformed != -1) {
            ResourceRepositoryStatus aStatus = new ResourceRepositoryStatus();
            aStatus.actionId = 3;
            aStatus.status = false;
            aStatus.message = MessageUtil.getString("Warning.Other.DTR.Action.Already.Performed.For.Objects");
            return aStatus;
        }
        ResourceRepositoryStatus[] result = this.getActionStatus(3, false);
        ResourceRepositoryStatus aStatus = RepositoryObject.buildStatusSummary(result);
        boolean checkOutForDelete = aStatus.status;
        if (withDialog) {
            String title = "";
            title = MessageUtil.getString("Message.Check.Out.For.Delete");
            DtrActionDialog anActionDialog = new DtrActionDialog(title, this, 3);
            anActionDialog.open();
            boolean temp = checkOutForDelete;
            checkOutForDelete = anActionDialog.getActionOkayControll();
            if (checkOutForDelete != temp) {
                aStatus.message = MessageUtil.getString("Message.Action.User.Cancel");
                aStatus.status = checkOutForDelete;
            }
        }
        if (checkOutForDelete) {
            this.deleteResourcesFromSourceControl(withDialog, anActivity, result);
        }
        if (checkOutForDelete) {
            this.theActionPerformed = 3;
        }
        return aStatus;
    }

    void deleteResourcesFromSourceControl(boolean withDialog, IVfsActivity anActivity, ResourceRepositoryStatus[] statiForCheckOutForDelete) throws RepositoryServiceException {
        IVfsActivity vfsActivity = anActivity;
        boolean result = true;
        StringBuffer message = new StringBuffer("");
        int size = this.theFilesAndFolders.size();
        int i = 0;
        while (i < size) {
            IResource aResource = (IResource)this.theFilesAndFolders.get(i);
            IVfsFolderItem aVfsFolderItem = (IVfsFolderItem)this.theVfsFolderItems.get(i);
            VfsFolderItemLocationState aLocationState = aVfsFolderItem.getLocationState();
            IVfsActivityRecordedFolderItem aVfsActivityRecordedFolderItem = (IVfsActivityRecordedFolderItem)this.theVfsActivityRecordedFolderItems.get(i);
            if (statiForCheckOutForDelete[i].status) {
                String aMessage;
                if (aLocationState == VfsFolderItemLocationState.LOCAL_ONLY) {
                    try {
                        aResource.delete(true, null);
                    }
                    catch (CoreException ce) {
                        result = false;
                        aMessage = MessageUtil.format("Error.Exception.Deleting.Local.Only.Resource", new Object[]{aResource.getName()});
                        message.append(aMessage);
                        message.append("\n");
                        this.theTracer.error(aMessage, (Throwable)ce);
                    }
                } else {
                    if (vfsActivity == null) {
                        vfsActivity = this.getActivity();
                    }
                    if (vfsActivity == null) {
                        throw new RepositoryServiceException(8);
                    }
                    try {
                        aVfsActivityRecordedFolderItem.checkOutAndDelete(vfsActivity);
                    }
                    catch (VfsException e) {
                        result = false;
                        aMessage = MessageUtil.format("Error.Exception.Checking.Out.For.Delete.Resource.From.DTR", new Object[]{aResource.getName(), e.getMessage()});
                        message.append(aMessage);
                        message.append("\n");
                        this.theTracer.error(aMessage, (Throwable)e);
                    }
                }
            }
            ++i;
        }
        if (!result && withDialog) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openError((Shell)shell, (String)MessageUtil.getString("Message.Dtr.Integration.Plugin"), (String)message.toString());
        }
    }

    public synchronized ResourceRepositoryStatus checkOut(boolean withDialog, IVfsActivity anActivity) throws RepositoryServiceException {
        return this.checkOut(withDialog, false, anActivity);
    }

    public synchronized ResourceRepositoryStatus checkOut(boolean withDialog, boolean exclusive, IVfsActivity anActivity) throws RepositoryServiceException {
        if (this.theActionPerformed != -1) {
            ResourceRepositoryStatus aStatus = new ResourceRepositoryStatus();
            aStatus.actionId = exclusive ? 2 : 1;
            aStatus.status = false;
            aStatus.message = MessageUtil.getString("Warning.Other.DTR.Action.Already.Performed.For.Objects");
            return aStatus;
        }
        ArrayList<IResource> toBeCheckedOut = new ArrayList<IResource>();
        int size = this.theFilesAndFolders.size();
        int i = 0;
        while (i < size) {
            IResource aResource = (IResource)this.theFilesAndFolders.get(i);
            if (aResource.isReadOnly()) {
                toBeCheckedOut.add(aResource);
            }
            ++i;
        }
        if (toBeCheckedOut.size() < 1) {
            ResourceRepositoryStatus aOkay = new ResourceRepositoryStatus();
            aOkay.status = true;
            aOkay.actionId = exclusive ? 2 : 1;
            aOkay.message = "Okay";
            return aOkay;
        }
        ResourceRepositoryStatus[] result = this.getActionStatus(exclusive ? 2 : 1, false);
        ResourceRepositoryStatus aStatus = RepositoryObject.buildStatusSummary(result);
        boolean checkOutForEdit = aStatus.status;
        if (withDialog) {
            String title = "";
            title = !exclusive ? MessageUtil.getString("Message.Check.Out.For.Edit") : MessageUtil.getString("Message.Check.Out.For.Edit.Exclusive");
            CheckoutDialog aCheckoutDialog = new CheckoutDialog(title, this);
            aCheckoutDialog.open();
            checkOutForEdit = aCheckoutDialog.getCheckOutControll();
        }
        if (checkOutForEdit) {
            this.checkOutResourcesFromSourceControl(withDialog, exclusive, anActivity, result);
        }
        aStatus.status = checkOutForEdit;
        if (checkOutForEdit) {
            this.theActionPerformed = exclusive ? 2 : 1;
        }
        return aStatus;
    }

    private ResourceRepositoryStatus[] getCheckOutForDeleteStatus(boolean useCached) {
        if (this.theCheckOutForDeleteStati != null && useCached) {
            return this.theCheckOutForDeleteStati;
        }
        int size = this.theFilesAndFolders.size();
        ResourceRepositoryStatus[] result = new ResourceRepositoryStatus[size];
        int i = 0;
        while (i < size) {
            ResourceRepositoryStatus status;
            result[i] = status = new ResourceRepositoryStatus();
            status.actionId = 3;
            IResource aResource = (IResource)this.theFilesAndFolders.get(i);
            IVfsFolderItem aVfsFolderItem = (IVfsFolderItem)this.theVfsFolderItems.get(i);
            IVfsFile aVfsFile = (IVfsFile)this.theVfsFiles.get(i);
            IVfsFolder aVfsFolder = (IVfsFolder)this.theVfsFolders.get(i);
            VfsFolderItemLocationState aLocationState = aVfsFolderItem.getLocationState();
            if (aLocationState == VfsFolderItemLocationState.LOCAL_ONLY) {
                if (aResource.isReadOnly()) {
                    status.status = false;
                    status.message = MessageUtil.format("Info.File.Is.Local.Only.Add.Read.Only", new Object[]{aResource.getName()});
                } else {
                    status.status = true;
                    status.message = MessageUtil.format("Info.File.Is.Local.Only", new Object[]{aResource.getName()});
                }
            } else if (aVfsFile != null && aLocationState != VfsFolderItemLocationState.SYNCED_TO_LATEST) {
                status.status = false;
                status.message = MessageUtil.format("Error.File.Not.Synched.To.Latest.Revision", new Object[]{aResource.getName()});
            } else {
                boolean isCheckedOutByOther = false;
                isCheckedOutByOther = aVfsFile != null ? aVfsFile.isCheckedOutByOthers() : aVfsFolder.isCheckedOutByOthers();
                if (isCheckedOutByOther) {
                    status.status = false;
                    status.message = MessageUtil.format("Error.File.Checked.Out.by.Others", new Object[]{aResource.getName()});
                } else {
                    VfsActionOnFolderItem[] vfsActionsOnFolderItem = aVfsFolderItem.getActionsForCurrentState();
                    status.status = false;
                    status.message = MessageUtil.format("Error.Could.Not.Delete.From.SourceControll.InternalError", new Object[]{aResource.getName(), 1 == aResource.getType() ? "File" : "Folder"});
                    int k = 0;
                    while (k < vfsActionsOnFolderItem.length) {
                        VfsActionOnFolderItem action = vfsActionsOnFolderItem[k];
                        if (action == VfsActionOnFolderItem.CHECKOUT_AND_DELETE) {
                            status.status = true;
                            status.message = MessageUtil.getString("Message.Okay");
                            break;
                        }
                        ++k;
                    }
                }
            }
            ++i;
        }
        this.theCheckOutForDeleteStati = result;
        return result;
    }

    private void sort() {
    }

    /*
     * Unable to fully structure code
     */
    private ResourceRepositoryStatus[] getCheckOutExclusiveForEditStatus(boolean useCached) {
        if (this.theCheckOutForEditExclStati != null && useCached) {
            return this.theCheckOutForEditExclStati;
        }
        size = this.theFilesAndFolders.size();
        result = new ResourceRepositoryStatus[size];
        j = 0;
        while (j < size) {
            block9: {
                block10: {
                    block8: {
                        result[j] = status = new ResourceRepositoryStatus();
                        status.actionId = 2;
                        aResource = (IResource)this.theFilesAndFolders.get(j);
                        aVfsFolderItem = (IVfsFolderItem)this.theVfsFolderItems.get(j);
                        aVfsFile = (IVfsFile)this.theVfsFiles.get(j);
                        aVfsFolder = (IVfsFolder)this.theVfsFolders.get(j);
                        aLocationState = aVfsFolderItem.getLocationState();
                        if (aLocationState != VfsFolderItemLocationState.LOCAL_ONLY) break block8;
                        status.status = false;
                        status.message = MessageUtil.format("Error.File.Is.Local.Only.Add.To.Source.Control.First", new Object[]{aResource.getName()});
                        break block9;
                    }
                    if (aVfsFile == null) break block10;
                    if (aLocationState == VfsFolderItemLocationState.SYNCED_TO_LATEST) ** GOTO lbl-1000
                    status.status = false;
                    status.message = MessageUtil.format("Error.File.Not.Synched.To.Latest.Revision", new Object[]{aResource.getName()});
                    break block9;
                }
                if (aLocationState != VfsFolderItemLocationState.MOUNTED) {
                    status.status = false;
                    status.message = MessageUtil.format("Error.Folder.Not.Mounted", new Object[]{aResource.getName()});
                } else lbl-1000:
                // 2 sources

                {
                    isCheckedOutByOther = false;
                    isCheckedOutByOther = aVfsFile != null ? aVfsFile.isCheckedOutByOthers() : aVfsFolder.isCheckedOutByOthers();
                    if (isCheckedOutByOther) {
                        status.status = false;
                        status.message = MessageUtil.format("Error.File.Checked.Out.by.Others", new Object[]{aResource.getName()});
                    } else {
                        vfsActionsOnFolderItem = aVfsFolderItem.getActionsForCurrentState();
                        status.status = false;
                        status.message = MessageUtil.format("Error.Could.Not.CheckOut.From.SourceControll.InternalError", new Object[]{aResource.getName(), 1 == aResource.getType() ? "File" : "Folder"});
                        i = 0;
                        while (i < vfsActionsOnFolderItem.length) {
                            action = vfsActionsOnFolderItem[i];
                            if (action == VfsActionOnFolderItem.CHECKOUT_FOR_EDIT_EXCLUSIVE) {
                                status.status = true;
                                status.message = MessageUtil.getString("Message.Okay");
                                break;
                            }
                            ++i;
                        }
                    }
                }
            }
            ++j;
        }
        this.theCheckOutForEditExclStati = result;
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private ResourceRepositoryStatus[] getCheckOutForEditStatus(boolean useCached) {
        if (this.theCheckOutForEditStati != null && useCached) {
            return this.theCheckOutForEditStati;
        }
        size = this.theFilesAndFolders.size();
        result = new ResourceRepositoryStatus[size];
        j = 0;
        while (j < size) {
            block9: {
                block10: {
                    block8: {
                        result[j] = status = new ResourceRepositoryStatus();
                        status.actionId = 1;
                        aResource = (IResource)this.theFilesAndFolders.get(j);
                        aVfsFolderItem = (IVfsFolderItem)this.theVfsFolderItems.get(j);
                        aVfsFile = (IVfsFile)this.theVfsFiles.get(j);
                        aVfsFolder = (IVfsFolder)this.theVfsFolders.get(j);
                        aLocationState = aVfsFolderItem.getLocationState();
                        if (aLocationState != VfsFolderItemLocationState.LOCAL_ONLY) break block8;
                        status.status = false;
                        status.message = MessageUtil.format("Error.File.Is.Local.Only.Add.To.Source.Control.First", new Object[]{aResource.getName()});
                        break block9;
                    }
                    if (aVfsFile == null) break block10;
                    if (aLocationState == VfsFolderItemLocationState.SYNCED_TO_LATEST) ** GOTO lbl-1000
                    status.status = false;
                    status.message = MessageUtil.format("Error.File.Not.Synched.To.Latest.Revision", new Object[]{aResource.getName()});
                    break block9;
                }
                if (aLocationState != VfsFolderItemLocationState.MOUNTED) {
                    status.status = false;
                    status.message = MessageUtil.format("Error.Folder.Not.Mounted", new Object[]{aResource.getName()});
                } else lbl-1000:
                // 2 sources

                {
                    isCheckedOutByOther = false;
                    isCheckedOutByOther = aVfsFile != null ? aVfsFile.isCheckedOutByOthers() : aVfsFolder.isCheckedOutByOthers();
                    if (isCheckedOutByOther) {
                        status.status = false;
                        status.message = MessageUtil.format("Error.File.Checked.Out.by.Others", new Object[]{aResource.getName()});
                    } else {
                        vfsActionsOnFolderItem = aVfsFolderItem.getActionsForCurrentState();
                        status.status = false;
                        status.message = MessageUtil.format("Error.Could.Not.CheckOut.From.SourceControll.InternalError", new Object[]{aResource.getName()});
                        i = 0;
                        while (i < vfsActionsOnFolderItem.length) {
                            action = vfsActionsOnFolderItem[i];
                            if (action == VfsActionOnFolderItem.CHECKOUT_FOR_EDIT) {
                                status.status = true;
                                status.message = MessageUtil.getString("Message.Okay");
                                break;
                            }
                            ++i;
                        }
                    }
                }
            }
            ++j;
        }
        this.theCheckOutForEditStati = result;
        return result;
    }

    public synchronized ResourceRepositoryStatus addToSourceControll(boolean withDialog, IVfsActivity anActivity) throws RepositoryServiceException {
        if (this.theActionPerformed != -1) {
            ResourceRepositoryStatus aStatus = new ResourceRepositoryStatus();
            aStatus.actionId = 0;
            aStatus.status = false;
            aStatus.message = MessageUtil.getString("Warning.Other.DTR.Action.Already.Performed.For.Objects");
            return aStatus;
        }
        ResourceRepositoryStatus[] result = this.getActionStatus(0, false);
        ResourceRepositoryStatus aResult = RepositoryObject.buildStatusSummary(result);
        boolean addToSourceControll = aResult.status;
        if (withDialog) {
            String title = MessageUtil.getString("Message.Add.To.DTR");
            AddToSourceControlDialog dialog = new AddToSourceControlDialog(title, this);
            dialog.open();
            addToSourceControll = dialog.getAddToSourceControll();
        }
        if (addToSourceControll) {
            this.addResourcesToSourceControl(withDialog, anActivity, result);
        }
        aResult.status = addToSourceControll;
        if (addToSourceControll) {
            this.theActionPerformed = 0;
        }
        return aResult;
    }

    private static ResourceRepositoryStatus buildStatusSummary(ResourceRepositoryStatus[] aListOfStati) {
        ResourceRepositoryStatus result = new ResourceRepositoryStatus();
        result.status = true;
        result.actionId = aListOfStati.length == 0 ? -1 : aListOfStati[0].actionId;
        result.message = "Okay";
        int size = aListOfStati.length;
        int i = 0;
        while (i < size) {
            if (!aListOfStati[i].status) {
                result = aListOfStati[i];
                break;
            }
            ++i;
        }
        return result;
    }

    private ResourceRepositoryStatus[] getAddToSourceControllStatus(boolean useCached) {
        if (this.theAddToSourceControlStati != null && useCached) {
            return this.theAddToSourceControlStati;
        }
        int size = this.theFilesAndFolders.size();
        ResourceRepositoryStatus[] result = new ResourceRepositoryStatus[size];
        int j = 0;
        while (j < size) {
            ResourceRepositoryStatus status;
            result[j] = status = new ResourceRepositoryStatus();
            status.actionId = 0;
            IResource aResource = (IResource)this.theFilesAndFolders.get(j);
            IVfsFolderItem aVfsFolderItem = (IVfsFolderItem)this.theVfsFolderItems.get(j);
            IVfsActivityRecordedFolderItem aVfsActRepFolderItem = (IVfsActivityRecordedFolderItem)this.theVfsActivityRecordedFolderItems.get(j);
            if (aVfsActRepFolderItem.hasLocalRemoteNameClash()) {
                status.status = false;
                status.message = MessageUtil.format("Error.Local.Remote.Name.Clash", new Object[]{aResource.getName()});
                this.theTracer.error(status.message);
            } else {
                VfsFolderItemLocationState aLocationState = aVfsFolderItem.getLocationState();
                VfsFolderItemActivityState aActivityState = aVfsActRepFolderItem.getActivityState();
                if (aLocationState != VfsFolderItemLocationState.LOCAL_ONLY || aActivityState == VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE) {
                    status.status = false;
                    status.message = MessageUtil.format("Error.IFile.Already.CheckedIn", new Object[]{aResource.getName()});
                    this.theTracer.error(status.message);
                } else {
                    VfsActionOnFolderItem[] vfsActionsOnFolderItem = aVfsFolderItem.getActionsForCurrentState();
                    status.status = false;
                    status.message = MessageUtil.format("Error.Could.Not.Add.To.SourceControll.InternalError", new Object[]{aResource.getName(), 1 == aResource.getType() ? "File" : "Folder"});
                    int i = 0;
                    while (i < vfsActionsOnFolderItem.length) {
                        VfsActionOnFolderItem action = vfsActionsOnFolderItem[i];
                        if (action == VfsActionOnFolderItem.CREATE_AND_CHECKOUT || action == VfsActionOnFolderItem.ADD_0) {
                            status.status = true;
                            status.message = MessageUtil.getString("Message.Okay");
                            break;
                        }
                        ++i;
                    }
                }
            }
            ++j;
        }
        this.theAddToSourceControlStati = result;
        return result;
    }

    public ResourceRepositoryStatus[] getActionStatus(int actionId) throws RepositoryServiceException {
        return this.getActionStatus(actionId, true);
    }

    public ResourceRepositoryStatus[] getActionStatus(int actionId, boolean useCached) throws RepositoryServiceException {
        ResourceRepositoryStatus[] result = new ResourceRepositoryStatus[]{};
        this.refreshDTRStatus();
        switch (actionId) {
            case 1: {
                result = this.getCheckOutForEditStatus(useCached);
                break;
            }
            case 2: {
                result = this.getCheckOutExclusiveForEditStatus(useCached);
                break;
            }
            case 0: {
                result = this.getAddToSourceControllStatus(useCached);
                break;
            }
            case 3: {
                result = this.getCheckOutForDeleteStatus(useCached);
                break;
            }
        }
        return result;
    }

    public synchronized IVfsActivity getActivity() throws RepositoryServiceException {
        if (this.theVfsActivity != null) {
            return this.theVfsActivity;
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (this.theWorkSpace != null) {
            if (WorkspacesWithDefaultActivity.usingDefaultActivity((IVfsWorkspace)this.theWorkSpace)) {
                try {
                    this.theVfsActivity = this.theWorkSpace.getDefaultActivity();
                }
                catch (VfsException e) {
                    this.theTracer.error(MessageUtil.getString("Warning.Could.Not.Get.Default.Activity"), (Throwable)e);
                    throw new RepositoryServiceException(14);
                }
            }
            if (this.theVfsActivity == null) {
                SelectActivityDialog selectActivityDialog = new SelectActivityDialog(shell, this.theWorkSpace);
                if (selectActivityDialog.open() == 0) {
                    IVfsActivity[] activities = selectActivityDialog.getActivitySelection();
                    if (activities.length > 0) {
                        this.theVfsActivity = activities[0];
                    }
                } else {
                    throw new RepositoryServiceException(13);
                }
            }
        }
        return this.theVfsActivity;
    }

    public synchronized void setActivity(IVfsActivity anActivity) {
        if (this.theVfsActivity == null) {
            this.theVfsActivity = anActivity;
        }
    }

    private int actionPerformed() {
        return this.theActionPerformed;
    }

    public synchronized ResourceRepositoryStatus revert() throws RepositoryServiceException {
        if (this.theVfsActivity == null) {
            ResourceRepositoryStatus aStatus = new ResourceRepositoryStatus();
            aStatus.actionId = 5;
            aStatus.status = false;
            aStatus.message = MessageUtil.getString("Warning.No.Activity.To.Revert");
            return aStatus;
        }
        if (this.theActionPerformed == -1) {
            ResourceRepositoryStatus aStatus = new ResourceRepositoryStatus();
            aStatus.actionId = 5;
            aStatus.status = false;
            aStatus.message = MessageUtil.getString("Warning.No.Action.Performed.Yet");
            return aStatus;
        }
        Iterator anIter = ((AbstractList)this.theVfsActivityRecordedFolderItems).iterator();
        while (anIter.hasNext()) {
            IVfsActivityRecordedFolderItem anARFI = (IVfsActivityRecordedFolderItem)anIter.next();
            try {
                anARFI.uncheckout(this.theVfsActivity);
            }
            catch (VfsException ie) {
                this.theTracer.error(MessageUtil.getString("Error.Reverting.CheckOut.Failed"), (Throwable)ie);
            }
        }
        this.theActionPerformed = -1;
        ResourceRepositoryStatus aStatus = new ResourceRepositoryStatus();
        aStatus.actionId = 5;
        aStatus.status = true;
        aStatus.message = "Okay";
        return aStatus;
    }

    void addResourcesToSourceControl(boolean withDialog, IVfsActivity anActivity, ResourceRepositoryStatus[] statiForAddToSourceControll) throws RepositoryServiceException {
        IVfsActivity vfsActivity = anActivity;
        if (vfsActivity == null) {
            vfsActivity = this.getActivity();
        }
        if (vfsActivity == null) {
            throw new RepositoryServiceException(8);
        }
        boolean result = true;
        StringBuffer message = new StringBuffer("");
        int size = this.theFilesAndFolders.size();
        int i = 0;
        while (i < size) {
            IResource aFile = (IResource)this.theFilesAndFolders.get(i);
            IVfsActivityRecordedFolderItem aVfsActivityRecordedFolderItem = (IVfsActivityRecordedFolderItem)this.theVfsActivityRecordedFolderItems.get(i);
            if (statiForAddToSourceControll[i].status) {
                try {
                    aVfsActivityRecordedFolderItem.createAndCheckout(vfsActivity);
                }
                catch (VfsException e) {
                    result = false;
                    String aMessage = MessageUtil.format("Error.Exception.Adding.Resource.To.DTR", new Object[]{aFile.getName()});
                    message.append(aMessage);
                    message.append("\n");
                    this.theTracer.error(aMessage, (Throwable)e);
                }
            }
            ++i;
        }
        if (!result && withDialog) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openError((Shell)shell, (String)MessageUtil.getString("Message.Dtr.Integration.Plugin"), (String)message.toString());
        }
    }

    void checkOutResourcesFromSourceControl(boolean withDialog, boolean exclusive, IVfsActivity anActivity, ResourceRepositoryStatus[] statiForCheckOutFromSourceControll) throws RepositoryServiceException {
        IVfsActivity vfsActivity = anActivity;
        if (vfsActivity == null) {
            vfsActivity = this.getActivity();
        }
        if (vfsActivity == null) {
            throw new RepositoryServiceException(8);
        }
        boolean result = true;
        StringBuffer message = new StringBuffer("");
        int size = this.theFilesAndFolders.size();
        int i = 0;
        while (i < size) {
            IResource aResource = (IResource)this.theFilesAndFolders.get(i);
            IVfsActivityRecordedFolderItem aVfsActivityRecordedFolderItem = (IVfsActivityRecordedFolderItem)this.theVfsActivityRecordedFolderItems.get(i);
            if (statiForCheckOutFromSourceControll[i].status) {
                try {
                    aVfsActivityRecordedFolderItem.checkOutForEdit(vfsActivity, exclusive);
                }
                catch (VfsException e) {
                    result = false;
                    String aMessage = MessageUtil.format("Error.Exception.Checking.Out.Resource.From.DTR", new Object[]{aResource.getName()});
                    message.append(aMessage);
                    message.append("\n");
                    this.theTracer.error(aMessage, (Throwable)e);
                    RepositoryServiceException ex = new RepositoryServiceException(15);
                    throw ex;
                }
            }
            ++i;
        }
        if (!result && withDialog) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openError((Shell)shell, (String)MessageUtil.getString("Message.Dtr.Integration.Plugin"), (String)message.toString());
        }
    }

    public IProject getProject() {
        return this.theProject;
    }

    public String getType() {
        return this.theType;
    }

    public String getName() {
        return this.theName;
    }

    public synchronized void addlResource(IResource aResource) throws RepositoryServiceException {
        if (aResource == null || !aResource.exists()) {
            this.theTracer.error(MessageUtil.getString("Error.IResource.Does.Not.Exist"));
            throw new RepositoryServiceException(12);
        }
        IVfsFolderItem folderItem = this.getVfsFolderItem(aResource);
        IVfsActivityRecordedFolderItem aCtivityReportedFolderItem = this.getVfsActivityRecordedFolderItem(folderItem);
        IVfsFile vfsFile = aCtivityReportedFolderItem.asFile();
        IVfsFolder vfsFolder = aCtivityReportedFolderItem.asFolder();
        if (vfsFile == null && vfsFolder == null) {
            this.theTracer.error(MessageUtil.getString("Error.No.Vfs.File.Or.Folder.For.Vfs.Activity.Recorded.Folder.Item"));
            throw new RepositoryServiceException(3);
        }
        if (aResource != null && !this.containslResource(aResource) && folderItem != null && aCtivityReportedFolderItem != null) {
            if (this.theWorkSpace == null) {
                this.theWorkSpace = aCtivityReportedFolderItem.getWorkspace();
                if (this.theWorkSpace == null) {
                    throw new RepositoryServiceException(7);
                }
            }
            this.theFilesAndFolders.add(aResource);
            this.theVfsFolderItems.add(folderItem);
            this.theVfsActivityRecordedFolderItems.add(aCtivityReportedFolderItem);
        }
        if (vfsFile != null) {
            this.theVfsFiles.add(vfsFile);
            this.theVfsFolders.add(null);
        } else if (vfsFolder != null) {
            this.theVfsFiles.add(null);
            this.theVfsFolders.add(vfsFolder);
        } else if (this.theTracer.debug()) {
            this.theTracer.debug("The resource could not be added to this:" + aResource.getLocation().toOSString());
        }
    }

    public synchronized void addlResource(IPath path) throws RepositoryServiceException {
        IResource aResource = this.theProject.findMember(path);
        this.addlResource(aResource);
    }

    private IVfsActivityRecordedFolderItem getVfsActivityRecordedFolderItem(IVfsFolderItem aFolderItem) throws RepositoryServiceException {
        IVfsActivityRecordedFolderItem vfsActivityRecordedFolderItem = aFolderItem.asActivityRecordedFolderItem();
        if (vfsActivityRecordedFolderItem == null) {
            this.theTracer.error("Error.No.VfsActivityRecordedFolderItem.For.FolderItem");
            throw new RepositoryServiceException(2);
        }
        return vfsActivityRecordedFolderItem;
    }

    private IVfsFolderItem getVfsFolderItem(IResource aResource) throws RepositoryServiceException {
        IVfsFolderItem folderItem = this.theDAVTeamProvider.getFolderItem(aResource);
        if (folderItem == null) {
            this.theTracer.error(MessageUtil.getString("Error.No.Vfs.Folder.Item.For.Resource"));
            throw new RepositoryServiceException(1);
        }
        return folderItem;
    }

    public int getlResourcesCount() {
        return this.theFilesAndFolders.size();
    }

    public IResource getlResource(int index) {
        IResource aResource = (IResource)this.theFilesAndFolders.get(index);
        return aResource;
    }

    public IFile getFile(String absolutePath) {
        Path path = new Path(absolutePath);
        IPath location = this.theProject.getLocation();
        int nrOfMatchingSegments = path.matchingFirstSegments(location);
        if (nrOfMatchingSegments <= 0) {
            return null;
        }
        IPath lPath = path.removeFirstSegments(nrOfMatchingSegments);
        IFile file = this.theProject.getFile(lPath);
        return file;
    }

    public IFolder getFolder(String absolutePath) {
        Path path = new Path(absolutePath);
        IPath location = this.theProject.getLocation();
        int nrOfMatchingSegments = path.matchingFirstSegments(location);
        if (nrOfMatchingSegments <= 0) {
            return null;
        }
        IPath lPath = path.removeFirstSegments(nrOfMatchingSegments);
        IFolder aFolder = this.theProject.getFolder(lPath);
        return aFolder;
    }

    public IResource[] getResources() {
        int size = this.theFilesAndFolders.size();
        return this.theFilesAndFolders.toArray(new IResource[size]);
    }

    public boolean containslResource(IResource aResource) {
        int size = this.theFilesAndFolders.size();
        int i = 0;
        while (i < size) {
            IResource resource = (IResource)this.theFilesAndFolders.get(i);
            if (aResource.equals((Object)resource)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private void refreshDTRStatus() throws RepositoryServiceException {
        alreadyRefreshedFolders = new HashSet<String>();
        size = this.theFilesAndFolders.size();
        i = 0;
        while (i < size) {
            vfsFile = (IVfsFile)this.theVfsFiles.get(i);
            vfsParentToBeRefreshed = null;
            vfsFolder = (IVfsFolder)this.theVfsFolders.get(i);
            if (vfsFile != null) {
                try {
                    parent = vfsFile.getParent();
                    if (parent == null) ** GOTO lbl25
                    vfsParentToBeRefreshed = parent.asFolder();
                }
                catch (VfsException e) {
                    this.theTracer.error(MessageUtil.getString("Error.No.Parent.For.Vfs.File"), (Throwable)e);
                    throw new RepositoryServiceException(4);
                }
            } else {
                try {
                    parent = vfsFolder.getParent();
                    if (parent != null) {
                        vfsParentToBeRefreshed = parent.asFolder();
                    }
                }
                catch (VfsException e) {
                    this.theTracer.error(MessageUtil.getString("Error.No.Parent.For.Vfs.File"), (Throwable)e);
                    throw new RepositoryServiceException(4);
                }
            }
lbl25:
            // 3 sources

            if (vfsParentToBeRefreshed == null) {
                this.theTracer.error(MessageUtil.getString("Error.No.Parent.For.Vfs.File"));
                throw new RepositoryServiceException(4);
            }
            path = vfsParentToBeRefreshed.getAbsoluteRemotePath();
            if (!alreadyRefreshedFolders.contains(path)) {
                try {
                    vfsParentToBeRefreshed.refreshFolderItems();
                }
                catch (VfsException e) {
                    this.theTracer.error(MessageUtil.getString("Error.Could.Not.Refresh.Vfs.Folder"), (Throwable)e);
                    throw new RepositoryServiceException(5);
                }
                alreadyRefreshedFolders.add(path);
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ResourceRepositoryStatus {
        public int actionId;
        public String message;
        public boolean status;
    }
}

