/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dii.dtri.util;

import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class MessageUtil {
    private static final String RESOURCE_BUNDLE = "com.tssap.dii.dtri.util.messages";
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.tssap.dii.dtri.util.messages");
    private static TracerI theTracer = TracingManager.getTracer((Class)(class$com$tssap$dii$dtri$util$MessageUtil == null ? (class$com$tssap$dii$dtri$util$MessageUtil = MessageUtil.class$("com.tssap.dii.dtri.util.MessageUtil")) : class$com$tssap$dii$dtri$util$MessageUtil));
    public static final int info = 0;
    public static final int help = 1;
    public static final int input = 2;
    public static final int search = 3;
    public static final int warning = 4;
    public static final int error = 5;
    private static final String[] imageLocations = new String[]{"icons/info.gif", "icons/help.gif", "icons/input.gif", "icons/search.gif", "icons/warning.gif", "icons/error.gif"};
    private static Image[] images;
    static /* synthetic */ Class class$com$tssap$dii$dtri$util$MessageUtil;

    private MessageUtil() {
    }

    public static synchronized void initResources() {
        Class clazz;
        Class clazz2 = clazz = class$com$tssap$dii$dtri$util$MessageUtil == null ? (class$com$tssap$dii$dtri$util$MessageUtil = MessageUtil.class$("com.tssap.dii.dtri.util.MessageUtil")) : class$com$tssap$dii$dtri$util$MessageUtil;
        if (resourceBundle != null) {
            try {
                if (images == null) {
                    images = new Image[imageLocations.length];
                    int i = 0;
                    while (i < imageLocations.length) {
                        ImageData source = new ImageData(clazz.getResourceAsStream(imageLocations[i]));
                        ImageData mask = source.getTransparencyMask();
                        MessageUtil.images[i] = new Image(null, source, mask);
                        ++i;
                    }
                }
            }
            catch (Throwable t) {
                theTracer.error(MessageUtil.getString("Exception.Occured"), t);
                MessageUtil.freeResources();
                throw new RuntimeException(MessageUtil.getString("Error.CouldNotLoadResources"));
            }
        }
    }

    private static void freeResources() {
        if (images != null) {
            int i = 0;
            while (i < images.length) {
                Image image = images[i];
                if (image != null) {
                    image.dispose();
                }
                ++i;
            }
            images = null;
        }
    }

    public static String format(String key, Object[] args) {
        return MessageFormat.format(MessageUtil.getString(key), args);
    }

    public static String getString(String key) {
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            theTracer.error("No rescource for key: " + key, (Throwable)e);
            return "!" + key + "!";
        }
    }

    public static synchronized Image getImage(int key) {
        return images[key];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

