/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dii.dtri.util;

import com.tssap.dii.dtri.util.RepositoryObject;
import com.tssap.dii.dtri.util.RepositoryObjectList;
import com.tssap.dii.dtri.util.RepositoryServiceException;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class AddToSourceControlDialog
extends Dialog {
    private static int ADD_TO_SOURCE_CONTROLL_BUTTON_ID = 1025;
    private Text theTextField = null;
    private String theMessage = null;
    private String theTitle = null;
    private boolean addToSourceControllEnabled = true;
    private boolean addToSourceControll = false;

    public AddToSourceControlDialog(String title, RepositoryObject anRespositoryObject) throws RepositoryServiceException {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.theTitle = title;
        this.theMessage = this.buildMessage(anRespositoryObject);
        this.setShellStyle(67696);
    }

    public AddToSourceControlDialog(String title, RepositoryObjectList aListOfRespositoryObjects) throws RepositoryServiceException {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        StringBuffer aBuffer = new StringBuffer();
        int size = aListOfRespositoryObjects.getSize();
        int i = 0;
        while (i < size) {
            aBuffer.append(this.buildMessage(aListOfRespositoryObjects.getItem(i)));
            aBuffer.append("\n");
            ++i;
        }
        this.theMessage = aBuffer.toString();
        this.theTitle = title;
        this.setShellStyle(67696);
    }

    private String buildMessage(RepositoryObject anRespositoryObject) throws RepositoryServiceException {
        RepositoryObject.ResourceRepositoryStatus[] stati = anRespositoryObject.getActionStatus(0);
        int size = stati.length;
        IResource[] resources = anRespositoryObject.getResources();
        StringBuffer aBuffer = new StringBuffer(anRespositoryObject.getName());
        aBuffer.append(":").append(anRespositoryObject.getType());
        aBuffer.append("\n");
        int i = 0;
        while (i < size) {
            aBuffer.append("\t");
            this.addToSourceControllEnabled = this.addToSourceControllEnabled && stati[i].status;
            IResource aResource = resources[i];
            aBuffer.append(aResource.getName());
            aBuffer.append(" Status: ").append(stati[i].status ? "Okay" : "Failed");
            if (!stati[i].status) {
                aBuffer.append(" Message:").append(stati[i].message);
            }
            aBuffer.append("\n");
            ++i;
        }
        return aBuffer.toString();
    }

    public boolean getAddToSourceControll() {
        return this.addToSourceControll;
    }

    protected void buttonPressed(int id) {
        if (id == ADD_TO_SOURCE_CONTROLL_BUTTON_ID) {
            this.addToSourceControll = true;
            this.close();
        }
        super.buttonPressed(id);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.theTitle);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        boolean defaultButton = true;
        if (this.addToSourceControllEnabled) {
            this.createButton(parent, ADD_TO_SOURCE_CONTROLL_BUTTON_ID, "Add", true);
            defaultButton = false;
        }
        this.createButton(parent, 0, IDialogConstants.CANCEL_LABEL, defaultButton);
    }

    protected final Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        ((GridLayout)parentComposite.getLayout()).numColumns = 2;
        Image image = JFaceResources.getImageRegistry().get("dialog_info_image");
        if (image != null) {
            Label label = new Label(parentComposite, 0);
            image.setBackground(label.getBackground());
            label.setImage(image);
            label.setLayoutData((Object)new GridData(66));
        }
        IGridLayoutPane userArea = PaneFactory.createGridLayoutPane((Composite)parentComposite, (int)1);
        GridData userAreaData = new GridData(1808);
        userArea.setLayoutData((Object)userAreaData);
        IGridLayoutData gridLayoutData = userArea.createGridLayoutData(4, 4, true, false);
        this.theTextField = userArea.addTextPane(this.theMessage, true, true, gridLayoutData);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 150;
        gridData.widthHint = 800;
        this.theTextField.setLayoutData((Object)gridData);
        return parentComposite;
    }
}

