/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dii.dtri.actions;

import com.sap.tc.logging.Location;
import com.tssap.dii.dtri.DtriPropertySetter;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.actions.BaseAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import java.util.Enumeration;
import java.util.Properties;

public class AddAction
extends BaseAction {
    IVfsFolder m_folder;
    IVfsActivityRecordedFolderItem[] m_folderItems;
    IVfsActivity m_activity;
    int m_depth;
    IVfsProgressMonitor m_progressMonitor;
    DtriPropertySetter.Data[] m_properties;
    volatile boolean m_hasFinished = false;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dii$dtri$actions$AddAction == null ? (class$com$tssap$dii$dtri$actions$AddAction = AddAction.class$("com.tssap.dii.dtri.actions.AddAction")) : class$com$tssap$dii$dtri$actions$AddAction));
    static /* synthetic */ Class class$com$tssap$dii$dtri$actions$AddAction;

    public AddAction(IVfsFolder folder, IVfsActivity activity, int depth) {
        this(folder, activity, depth, null);
    }

    public AddAction(IVfsFolder folder, IVfsActivity activity, int depth, IVfsProgressMonitor progressMonitor) {
        super(folder.getVersionedFileSystemManager());
        this.m_folder = folder;
        this.m_activity = activity;
        this.m_depth = depth;
        this.m_progressMonitor = progressMonitor;
    }

    public AddAction(IVfsActivityRecordedFolderItem[] folderItems, IVfsActivity activity, DtriPropertySetter.Data[] properties, int depth) {
        this(folderItems, activity, properties, depth, null);
    }

    public AddAction(IVfsActivityRecordedFolderItem[] folderItems, IVfsActivity activity, DtriPropertySetter.Data[] properties, int depth, IVfsProgressMonitor progressMonitor) {
        super(activity.getVersionedFileSystemManager());
        this.m_folderItems = folderItems;
        this.m_activity = activity;
        this.m_properties = properties;
        this.m_depth = depth;
        this.m_progressMonitor = progressMonitor;
    }

    public void execute() {
        if (this.m_progressMonitor != null) {
            this.m_progressMonitor.onStart();
        }
        VfsActionRecorder.getRecorder().start();
        Exception throwable = null;
        try {
            if (this.m_folder != null) {
                this.m_folder.createAndCheckout(this.m_activity, this.m_depth);
            } else if (this.m_folderItems != null && this.m_folderItems.length > 0 && this.m_folderItems[0] != null) {
                this.m_folderItems[0].getWorkspace().createAndCheckout(this.m_folderItems, this.m_activity, this.m_depth);
                if (this.m_properties != null) {
                    int i = 0;
                    while (i < this.m_properties.length) {
                        Object obj = this.m_properties[i].getObject();
                        if (obj instanceof IVfsActivityRecordedFolderItem) {
                            IVfsActivityRecordedFolderItem item = (IVfsActivityRecordedFolderItem)obj;
                            Properties props = this.m_properties[i].getProperty();
                            Enumeration<?> it = props.propertyNames();
                            while (it.hasMoreElements()) {
                                String key = (String)it.nextElement();
                                String value = props.getProperty(key);
                                item.setProperty(key, value, this.m_activity);
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception x) {
            throwable = x;
            LogUtil.logException((Location)LOCATION, (Throwable)x);
        }
        VfsActionRecorder.getRecorder().finish();
        if (this.m_progressMonitor != null) {
            this.m_progressMonitor.onFinish((Throwable)throwable);
        }
        AddAction addAction = this;
        synchronized (addAction) {
            this.m_hasFinished = true;
            ((Object)((Object)this)).notify();
        }
    }

    public boolean hasFinished() {
        return this.m_hasFinished;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

