/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dii.component;

import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.util.SelenaElementUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class DCUtil {
    public static boolean isDCMetaData(Element element) {
        boolean ret = false;
        String domain = element.getUniqueName().getDomain();
        if ("com.sap.ide.eclipse.component.DCMetaData".equals(domain)) {
            ret = true;
        }
        return ret;
    }

    public static boolean isDCMetaDataFolder(Element element) {
        boolean ret = false;
        String subDomain = element.getUniqueName().getSubDomain();
        if (DCUtil.isDCMetaData(element) && "com.sap.ide.eclipse.component.DCMetaData.Folder".equals(subDomain)) {
            ret = true;
        }
        return ret;
    }

    public static boolean isDCProject(IProject project) {
        if (project == null || !project.isAccessible()) {
            return false;
        }
        try {
            if (project.hasNature("com.sap.ide.eclipse.component.provider.dcnature")) {
                return true;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isDCProject(UniqueName uName) {
        if (SelenaElementUtil.isProjectModelUniqueName((UniqueName)uName)) {
            String projectName = uName.getName();
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            return DCUtil.isDCProject(project);
        }
        return false;
    }

    public static boolean isDCProject(Element element) {
        return DCUtil.isDCProject(element.getUniqueName());
    }

    public static Model getProjectModel(IProject project) {
        UniqueName modelUName = ModelAccess.createModelUniqueName((String)project.getName());
        Model model = ModelAccess.getModel((UniqueName)modelUName);
        return model;
    }

    public static IVfsFolderItem getVfsFolderItem(Element element) {
        Object obj = element.getObjectPropertyValue("com.sap.ide.eclipse.component.object_vfs.folder.item");
        if (obj instanceof IVfsFolderItem) {
            return (IVfsFolderItem)obj;
        }
        return null;
    }
}

