/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg.renderable;

import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.lang.ref.SoftReference;
import org.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.util.ParsedURL;

public class MultiResRable
extends AbstractRable {
    SoftReference[] srcs;
    ParsedURL[] srcURLs;
    Dimension[] sizes;
    Rectangle2D bounds;

    public MultiResRable(ParsedURL[] parsedURLArray, Dimension[] dimensionArray) {
        super((Filter)null);
        this.srcURLs = new ParsedURL[parsedURLArray.length];
        this.sizes = new Dimension[parsedURLArray.length];
        int n = 0;
        while (n < parsedURLArray.length) {
            this.srcURLs[n] = parsedURLArray[n];
            if (n < dimensionArray.length) {
                this.sizes[n] = dimensionArray[n];
            }
            ++n;
        }
        this.srcs = new SoftReference[parsedURLArray.length];
        this.bounds = new Rectangle2D.Float(0.0f, 0.0f, dimensionArray[0].width, dimensionArray[0].height);
    }

    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    public RenderedImage getImage(int n, RenderContext renderContext) {
        RenderingHints renderingHints;
        Filter filter = null;
        if (this.srcs[n] != null && (renderingHints = this.srcs[n].get()) != null) {
            filter = (Filter)renderingHints;
        }
        if (filter == null) {
            filter = ImageTagRegistry.getRegistry().readURL(this.srcURLs[n]);
            this.srcs[n] = new SoftReference<Filter>(filter);
        }
        if ((renderingHints = renderContext.getRenderingHints()) == null) {
            renderingHints = new RenderingHints(null);
        }
        double d = this.bounds.getWidth() / (double)filter.getWidth();
        double d2 = this.bounds.getHeight() / (double)filter.getHeight();
        AffineTransform affineTransform = renderContext.getTransform();
        affineTransform.scale(d, d2);
        Shape shape = renderContext.getAreaOfInterest();
        if (shape != null) {
            AffineTransform affineTransform2 = AffineTransform.getScaleInstance(1.0 / d, 1.0 / d2);
            shape = affineTransform2.createTransformedShape(shape);
        }
        return filter.createRendering(new RenderContext(affineTransform, shape, renderingHints));
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        AffineTransform affineTransform = renderContext.getTransform();
        double d = Math.sqrt(affineTransform.getDeterminant());
        if (d >= 1.0) {
            return this.getImage(0, renderContext);
        }
        double d2 = this.bounds.getWidth() * d;
        int n = 1;
        while (n < this.sizes.length) {
            if (d2 > (double)this.sizes[n].width) {
                return this.getImage(n - 1, renderContext);
            }
            ++n;
        }
        return this.getImage(this.srcURLs.length - 1, renderContext);
    }
}

