/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.SVGImageElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.extension.svg.BatikExtConstants;
import org.apache.batik.extension.svg.renderable.MultiResRable;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ImageNode;
import org.apache.batik.gvt.RasterImageNode;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;

public class BatikMultiImageElementBridge
extends SVGImageElementBridge
implements BatikExtConstants {
    BatikMultiImageElementBridge() {
    }

    public String getNamespaceURI() {
        return "http://xml.apache.org/batik/ext";
    }

    public String getLocalName() {
        return "multiImage";
    }

    public Bridge getInstance() {
        return new BatikMultiImageElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        Cloneable cloneable;
        Object object;
        if (!SVGUtilities.matchUserAgent((Element)element, (UserAgent)bridgeContext.getUserAgent())) {
            return null;
        }
        ImageNode imageNode = (ImageNode)this.instantiateGraphicsNode();
        String string = element.getAttributeNS(null, "transform");
        if (string.length() != 0) {
            imageNode.setTransform(SVGUtilities.convertTransform((Element)element, (String)"transform", (String)string));
        }
        imageNode.setVisible(CSSUtilities.convertVisibility((Element)element));
        RasterImageNode rasterImageNode = new RasterImageNode();
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        this.addInfo(element, linkedList, linkedList2);
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 && (object = (Element)node).getNamespaceURI().equals("http://xml.apache.org/batik/ext") && object.getLocalName().equals("subImage")) {
                this.addInfo((Element)object, linkedList, linkedList2);
            }
            node = node.getNextSibling();
        }
        object = new Dimension[linkedList2.size()];
        ParsedURL[] parsedURLArray = new ParsedURL[linkedList2.size()];
        Iterator iterator = linkedList.iterator();
        Iterator iterator2 = linkedList2.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            cloneable = (Dimension)iterator.next();
            int n2 = 0;
            while (n2 < n) {
                if (((Dimension)cloneable).width > ((Dimension)object[n2]).width) break;
                ++n2;
            }
            int n3 = n;
            while (n3 > n2) {
                object[n3] = object[n3 - 1];
                parsedURLArray[n3] = parsedURLArray[n3 - 1];
                --n3;
            }
            object[n2] = cloneable;
            parsedURLArray[n2] = (ParsedURL)iterator2.next();
            ++n;
        }
        MultiResRable multiResRable = new MultiResRable(parsedURLArray, (Dimension[])object);
        cloneable = multiResRable.getBounds2D();
        Rectangle2D rectangle2D = SVGImageElementBridge.getImageBounds((BridgeContext)bridgeContext, (Element)element);
        rasterImageNode.setImage((Filter)multiResRable);
        rasterImageNode.setImageBounds((Rectangle2D)cloneable);
        float[] fArray = new float[]{0.0f, 0.0f, (float)((RectangularShape)cloneable).getWidth(), (float)((RectangularShape)cloneable).getHeight()};
        SVGImageElementBridge.initializeViewport((BridgeContext)bridgeContext, (Element)element, (GraphicsNode)rasterImageNode, (float[])fArray, (Rectangle2D)rectangle2D);
        imageNode.setImage((GraphicsNode)rasterImageNode);
        return imageNode;
    }

    protected void addInfo(Element element, Collection collection, Collection collection2) {
        Dimension dimension = this.getElementPixelSize(element);
        String string = XLinkSupport.getXLinkHref((Element)element);
        if (string.length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"xlink:href"});
        }
        SVGDocument sVGDocument = (SVGDocument)element.getOwnerDocument();
        URL uRL = ((SVGOMDocument)sVGDocument).getURLObject();
        ParsedURL parsedURL = new ParsedURL(uRL, string);
        collection.add(dimension);
        collection2.add(parsedURL);
    }

    protected Dimension getElementPixelSize(Element element) {
        int n = 0;
        int n2 = 0;
        String string = element.getAttributeNS(null, "pixel-width");
        if (string.length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"pixel-width"});
        }
        try {
            n = (int)SVGUtilities.convertSVGNumber((String)string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(element, "attribute.malformed", new Object[]{"pixel-width", string});
        }
        string = element.getAttributeNS(null, "pixel-height");
        if (string.length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"pixel-height"});
        }
        try {
            n2 = (int)SVGUtilities.convertSVGNumber((String)string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(element, "attribute.malformed", new Object[]{"pixel-height", string});
        }
        return new Dimension(n, n2);
    }
}

