/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.ui.wizards.imports.internal;

import com.tssap.tools.ui.ToolsUIPlugin;
import com.tssap.tools.ui.wizards.imports.internal.ExtensionFilenameFilter;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class FilteredFileSeeker
implements IRunnableWithProgress {
    private FileFilter[] fileFilter = null;
    private File baseFile = null;
    private File[] foundFiles = new File[0];
    private IProgressMonitor myProgressMonitor;
    private int searchdepth = Integer.MAX_VALUE;

    public FilteredFileSeeker(int depth) {
        this(new FileFilter[0], depth);
    }

    public FilteredFileSeeker(String ext, int depth) {
        this(new ExtensionFilenameFilter(ext.startsWith(".") ? ext : "." + ext), depth);
    }

    public FilteredFileSeeker(FileFilter filter, int depth) {
        this(new FileFilter[]{filter}, depth);
    }

    public FilteredFileSeeker(FileFilter[] filter, int depth) {
        this.fileFilter = filter;
        this.searchdepth = depth;
    }

    public File[] getAllFiles(File baseFile) {
        this.baseFile = baseFile;
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(null);
            pmd.run(true, true, (IRunnableWithProgress)this);
        }
        catch (InvocationTargetException e) {
            ToolsUIPlugin.getTracer().error(this.getClass(), "getAllFiles(File baseFile)", "Error searching for project files", (Throwable)e);
        }
        catch (InterruptedException e) {
            ToolsUIPlugin.getTracer().error(this.getClass(), "getAllFiles(File baseFile)", "Error searching for project files", (Throwable)e);
        }
        return this.foundFiles;
    }

    private ArrayList createFileList(File base) {
        ArrayList<File> fileList = new ArrayList<File>();
        if (base.isDirectory()) {
            this.addFiles(base, fileList, 0);
        } else if (this.isAccepted(base)) {
            fileList.add(base);
        }
        return fileList;
    }

    private void addFiles(File file, ArrayList fileList, int depth) {
        if (file.isDirectory()) {
            File[] cont = file.listFiles();
            if (cont != null) {
                int i = 0;
                while (i < cont.length) {
                    if (this.isAccepted(cont[i]) && depth <= this.searchdepth && this.myProgressMonitor != null && !this.myProgressMonitor.isCanceled()) {
                        this.addFiles(cont[i], fileList, depth + 1);
                    }
                    ++i;
                }
            }
        } else {
            fileList.add(file);
            if (this.myProgressMonitor != null) {
                this.myProgressMonitor.subTask("found: " + fileList.size());
            }
        }
    }

    private boolean isAccepted(File f) {
        boolean ret = true;
        int i = 0;
        while (i < this.fileFilter.length & ret) {
            ret &= this.fileFilter[i].accept(f);
            ++i;
        }
        return ret;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.myProgressMonitor = monitor;
        monitor.beginTask("Searching for Projects in " + this.baseFile.getAbsolutePath(), -1);
        monitor.subTask("found: 0");
        this.foundFiles = this.createFileList(this.baseFile).toArray(new File[0]);
    }
}

