/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.ui.wizards.imports;

import com.tssap.tools.XMLUtil;
import com.tssap.tools.ui.wizards.imports.ExtProjImportWizard;
import com.tssap.tools.ui.wizards.imports.internal.ExtensionFilenameFilter;
import com.tssap.tools.ui.wizards.imports.internal.FilteredFileSeeker;
import com.tssap.util.ui.ITooltipProvider;
import com.tssap.util.ui.ToolTipSupport;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.internal.WorkbenchImages;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ExtProjWizardPage
extends WizardDataTransferPage
implements ICheckStateListener {
    private static final String SOURCE_FOLDER_HISTORY_SETTING_ID = "ExtProjWizardPage.sourceHistory";
    private static final String OPEN_PROJ_SETTING_ID = "OpenProjSetting";
    private static final String DEEP_SEARCH_SETTINGS_ID = "DeepSearchSetting";
    private static final String SELECT_SOURCE_MESSAGE = "My Selection Message";
    private static final String SOURCE_ROOT_LABLE_TEXT = "Select base folder";
    private static final String PAGE_MESSAGE = "Import Projects";
    private static final String PAGE_DESCRIPTION = "Create new projects from existing project directories";
    private static final String PAGE_TITLE = "Import";
    private static final String OPTION_GROUP_TXT = "Options";
    private static final String BROWSER_BUTTON_TXT = "Bro&wse";
    private static final String SELECT_ALL_BUTTON_TXT = "&Select All";
    private static final String DESELECT_ALL_BUTTON_TXT = "&Deselect All";
    private static final String DEEP_SEARCH_CHECKBOX_TXT = "S&earch for Projects in all Subfolders";
    private static final String OPEN_CHECKBOX_TXT = "&Open Projects after import";
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 400;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 150;
    private boolean entryChanged = false;
    protected Combo sourceNameField;
    private Button sourceBrowseButton;
    private Button selectAllButton;
    private Button deselectAllButton;
    private Button deepSearchCheckbox;
    private Button openProjectsCheckbox;
    private HashMap pluginFileNameMap = new HashMap();
    private List allreadyContainedPrjNames;
    private CheckboxTableViewer listViewer;
    private IStructuredContentProvider listContentProvider = new MyListContentProvider();
    private ILabelProvider listLabelProvider = new MyListLableProvider();
    private boolean deepsearch = false;
    private boolean openProjects = false;

    protected ExtProjWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName);
    }

    private List getContainedPrj() {
        if (this.allreadyContainedPrjNames == null) {
            this.allreadyContainedPrjNames = new ArrayList();
            IProject[] prjs = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < prjs.length) {
                this.allreadyContainedPrjNames.add(prjs[i].getName());
                ++i;
            }
        }
        return this.allreadyContainedPrjNames;
    }

    protected boolean allowNewContainerName() {
        return false;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.sourceBrowseButton) {
            this.handleSourceBrowseButtonPressed();
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        super.setDescription(PAGE_DESCRIPTION);
        super.setImageDescriptor(SapIdeUtilImages.getImageDescriptorFromIconsDirectory((String)"com.tssap.tools.ui", (String)"import_big.gif"));
        super.setPageComplete(false);
        super.setTitle(PAGE_MESSAGE);
        this.createSourceGroup(composite);
        this.createSpacer(composite);
        this.createOptionsGroup(composite);
        this.restoreWidgetValues();
        this.setControl((Control)composite);
    }

    protected void createOptionsGroup(Composite parent) {
        Group optionsGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        optionsGroup.setLayout((Layout)layout);
        optionsGroup.setLayoutData((Object)new GridData(768));
        optionsGroup.setText(OPTION_GROUP_TXT);
        this.createOptionsGroupButtons(optionsGroup);
    }

    protected void createSourceGroup(Composite parent) {
        this.createRootDirectoryGroup(parent);
        this.createFileSelectionGroup(parent);
        this.createButtonsGroup(parent);
    }

    private void createFileSelectionGroup(Composite parent) {
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        GridData data = new GridData(1808);
        data.widthHint = 400;
        data.heightHint = 150;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.setContentProvider((IContentProvider)this.listContentProvider);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.listLabelProvider);
        this.listViewer.addCheckStateListener((ICheckStateListener)this);
        ToolTipSupport.activateToolTips((ContentViewer)this.listViewer);
    }

    protected void createRootDirectoryGroup(Composite parent) {
        Composite sourceContainerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        sourceContainerGroup.setLayout((Layout)layout);
        sourceContainerGroup.setLayoutData((Object)new GridData(768));
        new Label(sourceContainerGroup, 0).setText(SOURCE_ROOT_LABLE_TEXT);
        this.sourceNameField = new Combo(sourceContainerGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.sourceNameField.setLayoutData((Object)data);
        this.sourceNameField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtProjWizardPage.this.updateFromSourceField();
            }
        });
        this.sourceNameField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                ExtProjWizardPage.this.entryChanged = true;
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.sourceNameField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (ExtProjWizardPage.this.entryChanged) {
                    ExtProjWizardPage.this.entryChanged = false;
                    ExtProjWizardPage.this.updateFromSourceField();
                }
            }
        });
        this.sourceBrowseButton = new Button(sourceContainerGroup, 8);
        this.sourceBrowseButton.setText(BROWSER_BUTTON_TXT);
        this.sourceBrowseButton.addListener(13, (Listener)this);
        this.sourceBrowseButton.setLayoutData((Object)new GridData(256));
        this.sourceNameField.setFocus();
    }

    protected final void createButtonsGroup(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(80));
        this.selectAllButton = new Button(buttonComposite, 131080);
        this.selectAllButton.setText(SELECT_ALL_BUTTON_TXT);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtProjWizardPage.this.handleSelectAllButtonPressed();
            }
        };
        this.selectAllButton.addSelectionListener((SelectionListener)listener);
        this.deselectAllButton = new Button(buttonComposite, 131080);
        this.deselectAllButton.setText(DESELECT_ALL_BUTTON_TXT);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtProjWizardPage.this.handleDeselectAllButtonPressed();
            }
        };
        this.deselectAllButton.addSelectionListener((SelectionListener)listener);
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        this.deepSearchCheckbox = new Button((Composite)optionsGroup, 32);
        this.deepSearchCheckbox.setSelection(this.deepsearch);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtProjWizardPage.this.deepsearch = ExtProjWizardPage.this.deepsearch ^ true;
                ExtProjWizardPage.this.updateFromSourceField();
            }
        };
        this.deepSearchCheckbox.addSelectionListener((SelectionListener)listener);
        this.deepSearchCheckbox.setText(DEEP_SEARCH_CHECKBOX_TXT);
        this.openProjectsCheckbox = new Button((Composite)optionsGroup, 32);
        this.openProjectsCheckbox.setSelection(this.openProjects);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtProjWizardPage.this.openProjects = ExtProjWizardPage.this.openProjects ^ true;
            }
        };
        this.openProjectsCheckbox.addSelectionListener((SelectionListener)listener);
        this.openProjectsCheckbox.setText(OPEN_CHECKBOX_TXT);
    }

    private void updateFromSourceField() {
        FilteredFileSeeker ffs = this.deepsearch ? new FilteredFileSeeker(new ExtensionFilenameFilter(".project"), Integer.MAX_VALUE) : new FilteredFileSeeker(new ExtensionFilenameFilter(".project"), 1);
        File rootFolderFile = new File(this.sourceNameField.getText());
        File[] foundProjectFiles = new File[]{};
        if (rootFolderFile.exists()) {
            foundProjectFiles = ffs.getAllFiles(rootFolderFile);
            ArrayList<File> al = new ArrayList<File>();
            int i = 0;
            while (i < foundProjectFiles.length) {
                if (this.getProjectName(foundProjectFiles[i]) != null) {
                    al.add(foundProjectFiles[i]);
                }
                ++i;
            }
            foundProjectFiles = al.toArray(new File[al.size()]);
            if (foundProjectFiles.length > 0) {
                super.setPageComplete(true);
            }
            this.refreshTree(foundProjectFiles);
        }
        this.setSourceName(this.sourceNameField.getText());
        this.updateWidgetEnablements();
    }

    protected void updateWidgetEnablements() {
        super.updateWidgetEnablements();
    }

    protected void handleSourceBrowseButtonPressed() {
        String currentSource = this.sourceNameField.getText();
        DirectoryDialog dialog = new DirectoryDialog(this.sourceNameField.getShell(), 8192);
        dialog.setMessage(SELECT_SOURCE_MESSAGE);
        dialog.setFilterPath(this.getSourceDirectoryName(currentSource));
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            this.sourceNameField.setText(selectedDirectory);
            this.sourceNameField.setFocus();
            this.updateFromSourceField();
        }
    }

    protected void handleSelectAllButtonPressed() {
        this.listViewer.setAllChecked(true);
        Object[] checked = this.listViewer.getCheckedElements();
        int i = 0;
        while (i < checked.length) {
            if (this.getContainedPrj().contains(this.getProjectName((File)checked[i]))) {
                this.listViewer.setChecked(checked[i], false);
            }
            ++i;
        }
        this.updatePageStatus();
    }

    private void updatePageStatus() {
        Object[] checkedEl = this.listViewer.getCheckedElements();
        ArrayList<String> al = new ArrayList<String>();
        String msg = null;
        int i = 0;
        while (i < checkedEl.length && msg == null) {
            File f = (File)checkedEl[i];
            if (al.contains(this.getProjectName(f))) {
                msg = "Double selection of project " + this.getProjectName(f);
            }
            al.add(this.getProjectName(f));
            ++i;
        }
        super.setMessage(msg, msg == null ? 0 : 3);
        super.setPageComplete(msg == null && checkedEl.length > 0);
    }

    protected void handleDeselectAllButtonPressed() {
        this.listViewer.setAllChecked(false);
        this.updatePageStatus();
    }

    public File[] getSelectedProjectFiles() {
        Object[] selectedElements = this.listViewer.getCheckedElements();
        File[] ret = new File[selectedElements.length];
        int i = 0;
        while (i < selectedElements.length) {
            ret[i] = (File)selectedElements[i];
            ++i;
        }
        return ret;
    }

    protected void setSourceName(String path) {
        if (path.length() > 0) {
            String[] currentItems = this.sourceNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(path)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = path;
                this.sourceNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.sourceNameField.select(selectionIndex);
        }
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(SOURCE_FOLDER_HISTORY_SETTING_ID);
            if (sourceNames == null) {
                return;
            }
            int i = 0;
            while (i < sourceNames.length) {
                this.sourceNameField.add(sourceNames[i]);
                ++i;
            }
            this.openProjects = settings.getBoolean(OPEN_PROJ_SETTING_ID);
            this.openProjectsCheckbox.setSelection(this.openProjects);
            this.deepsearch = settings.getBoolean(DEEP_SEARCH_SETTINGS_ID);
            this.deepSearchCheckbox.setSelection(this.deepsearch);
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(SOURCE_FOLDER_HISTORY_SETTING_ID);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            sourceNames = this.addToHistory(sourceNames, this.getSourceDirectoryName());
            settings.put(SOURCE_FOLDER_HISTORY_SETTING_ID, sourceNames);
            settings.put(OPEN_PROJ_SETTING_ID, this.openProjects);
            settings.put(DEEP_SEARCH_SETTINGS_ID, this.deepsearch);
        }
    }

    protected File getSourceDirectory() {
        return this.getSourceDirectory(this.sourceNameField.getText());
    }

    private File getSourceDirectory(String path) {
        File sourceDirectory = new File(this.getSourceDirectoryName(path));
        if (!sourceDirectory.exists() || !sourceDirectory.isDirectory()) {
            return null;
        }
        return sourceDirectory;
    }

    private String getSourceDirectoryName() {
        return this.getSourceDirectoryName(this.sourceNameField.getText());
    }

    private String getSourceDirectoryName(String sourceName) {
        Path result = new Path(sourceName.trim());
        result = result.getDevice() != null && result.segmentCount() == 0 ? result.addTrailingSeparator() : result.removeTrailingSeparator();
        return result.toOSString();
    }

    public boolean isOpenProjects() {
        return this.openProjects;
    }

    public String getProjectName(File projFile) {
        String ret = null;
        String errMsg = null;
        ProjFileContent cont = (ProjFileContent)this.pluginFileNameMap.get(projFile);
        if (cont != null && cont.getTimeStamp() == projFile.lastModified()) {
            return cont.getProjName();
        }
        try {
            Element root = XMLUtil.parse((File)projFile).getDocumentElement();
            if (!root.getTagName().equals("projectDescription")) {
                errMsg = "Invalid .plugin file(" + projFile.getAbsolutePath() + "): Roottag must be 'projectDescription'";
            }
            Element[] firstLevelChildren = XMLUtil.getElementsFromNodeList((NodeList)root.getChildNodes());
            int i = 0;
            while (i < firstLevelChildren.length) {
                NodeList nl;
                if (firstLevelChildren[i].getTagName().equals("name") && (nl = firstLevelChildren[i].getChildNodes()).getLength() == 1 && nl.item(0).getNodeType() == 3) {
                    ret = nl.item(0).getNodeValue();
                }
                ++i;
            }
        }
        catch (Exception e) {
            ExtProjImportWizard.tracer.error(((Object)((Object)this)).getClass(), "getProjectName(File projFile)", "Error reading project name from project file " + projFile.getAbsolutePath(), (Throwable)e);
        }
        if (errMsg != null) {
            ExtProjImportWizard.tracer.warning(((Object)((Object)this)).getClass(), "getProjectName(File projFile)", errMsg);
        }
        if (ret == null) {
            ExtProjImportWizard.tracer.warning(((Object)((Object)this)).getClass(), "getProjectName(File projFile)", "Unable to find project name in .project file:" + projFile.getAbsolutePath());
        } else {
            this.pluginFileNameMap.put(projFile, new ProjFileContent(projFile.lastModified(), ret));
        }
        return ret;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        if (this.listViewer.getGrayed(event.getElement())) {
            this.listViewer.setChecked(event.getElement(), false);
        }
        this.updatePageStatus();
    }

    private void refreshTree(File[] newInput) {
        this.listViewer.setInput((Object)newInput);
        TableItem[] items = this.listViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            File f = (File)items[i].getData();
            if (this.getContainedPrj().contains(this.getProjectName(f))) {
                this.listViewer.setGrayed((Object)f, true);
            }
            ++i;
        }
        this.updatePageStatus();
    }

    class ProjFileContent {
        long timeStamp;
        String projName;

        ProjFileContent(long timeStamp, String projName) {
            this.projName = projName;
            this.timeStamp = timeStamp;
        }

        public String getProjName() {
            return this.projName;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public void setProjName(String projName) {
            this.projName = projName;
        }

        public void setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }
    }

    class MyListLableProvider
    implements ILabelProvider,
    ITooltipProvider {
        private final Image image = WorkbenchImages.getImage((String)"IMG_OBJ_PROJECT");

        public Image getImage(Object element) {
            return this.image;
        }

        public String getText(Object element) {
            return element instanceof File ? ExtProjWizardPage.this.getProjectName((File)element) : "???";
        }

        public String getTooltipText(Object element) {
            String fullPath;
            String basePath = ExtProjWizardPage.this.sourceNameField.getText();
            String string = fullPath = element instanceof File ? ((File)element).getAbsolutePath() : "???";
            if (basePath.length() > 1 && fullPath.startsWith(basePath) && fullPath.endsWith(".project")) {
                fullPath = fullPath.substring(basePath.length(), fullPath.length() - 8);
            }
            return fullPath;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class MyListContentProvider
    implements IStructuredContentProvider {
        private File[] prjFiles;

        MyListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.prjFiles;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null && newInput instanceof File[]) {
                this.prjFiles = (File[])newInput;
            }
        }
    }
}

