/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.ui.wizards.imports;

import com.tssap.tools.ui.wizards.imports.ExtProjWizardPage;
import com.tssap.util.Util;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ExtProjImportWizard
extends Wizard
implements IImportWizard {
    protected static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$tools$ui$wizards$imports$ExtProjImportWizard == null ? (class$com$tssap$tools$ui$wizards$imports$ExtProjImportWizard = ExtProjImportWizard.class$("com.tssap.tools.ui.wizards.imports.ExtProjImportWizard")) : class$com$tssap$tools$ui$wizards$imports$ExtProjImportWizard));
    private static final String THIS_PLUGIN_ID = "com.tssap.tools.ui";
    private static final String WIZARD_TITLE = "Import";
    private static final String WIZARD_PAGE_TITLE = "Import external source projects";
    private ExtProjWizardPage mainPage;
    private IStructuredSelection selection;
    private IWorkbench workbench;
    static /* synthetic */ Class class$com$tssap$tools$ui$wizards$imports$ExtProjImportWizard;

    public ExtProjImportWizard() {
        AbstractUIPlugin plugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
        IDialogSettings workbenchSettings = plugin.getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection((class$com$tssap$tools$ui$wizards$imports$ExtProjImportWizard == null ? (class$com$tssap$tools$ui$wizards$imports$ExtProjImportWizard = ExtProjImportWizard.class$("com.tssap.tools.ui.wizards.imports.ExtProjImportWizard")) : class$com$tssap$tools$ui$wizards$imports$ExtProjImportWizard).getName());
        if (section == null) {
            section = workbenchSettings.addNewSection((class$com$tssap$tools$ui$wizards$imports$ExtProjImportWizard == null ? (class$com$tssap$tools$ui$wizards$imports$ExtProjImportWizard = ExtProjImportWizard.class$("com.tssap.tools.ui.wizards.imports.ExtProjImportWizard")) : class$com$tssap$tools$ui$wizards$imports$ExtProjImportWizard).getName());
        }
        this.setDialogSettings(section);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.workbench = workbench;
        super.setWindowTitle(WIZARD_TITLE);
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new ExtProjWizardPage(WIZARD_PAGE_TITLE, this.selection);
        this.addPage((IWizardPage)this.mainPage);
        this.mainPage.setWizard((IWizard)this);
    }

    public boolean performFinish() {
        File[] projFilesToImport = this.mainPage.getSelectedProjectFiles();
        if (projFilesToImport.length > 0) {
            SourceProjectImporter importer = new SourceProjectImporter(projFilesToImport, this.mainPage.isOpenProjects());
            try {
                ProgressMonitorDialog pmd = new ProgressMonitorDialog(null);
                pmd.setCancelable(false);
                pmd.run(true, true, (IRunnableWithProgress)importer);
            }
            catch (InvocationTargetException e) {
                tracer.warning("performFinish()", "", (Throwable)e);
            }
            catch (InterruptedException e) {
                tracer.warning("performFinish()", "", (Throwable)e);
            }
            ArrayList errorMsgList = importer.getErrorMsgList();
            if (errorMsgList.size() > 0) {
                MultiStatus mainStatus = new MultiStatus(Util.getPluginID(((Object)((Object)this)).getClass()), 0, "Errors importing Projects", null);
                int i = 0;
                while (i < errorMsgList.size()) {
                    Status status = new Status(4, Util.getPluginID(((Object)((Object)this)).getClass()), 0, "Error message: " + ((Throwable)errorMsgList.get(i)).getMessage(), (Throwable)errorMsgList.get(i));
                    mainStatus.add((IStatus)status);
                    ++i;
                }
                ErrorDialog.openError((Shell)this.getShell(), (String)"Errors importing Projects", (String)"There have been problems importing the selected projects.", (IStatus)mainStatus);
            }
        }
        this.mainPage.saveWidgetValues();
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SourceProjectImporter
    implements IRunnableWithProgress {
        private File[] projFilesToImport;
        private boolean openProjects;
        private ArrayList errorMsgList;

        public SourceProjectImporter(File[] projFiles, boolean openProjects) {
            this.projFilesToImport = projFiles;
            this.openProjects = openProjects;
            this.errorMsgList = new ArrayList();
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("Importing Projects", (this.openProjects ? this.projFilesToImport.length * 2 : this.projFilesToImport.length) * 100);
            this.createProjects(monitor);
        }

        private void createProjects(IProgressMonitor monitor) {
            ArrayList<IProject> importedProj = new ArrayList<IProject>();
            int i = 0;
            while (i < this.projFilesToImport.length) {
                try {
                    IProject newPrj = this.createExistingProject(this.projFilesToImport[i], monitor, this.errorMsgList);
                    if (newPrj != null) {
                        importedProj.add(newPrj);
                    }
                }
                catch (Throwable e) {
                    this.errorMsgList.add(e);
                }
                ++i;
            }
            if (ExtProjImportWizard.this.mainPage.isOpenProjects()) {
                int i2 = 0;
                while (i2 < importedProj.size()) {
                    try {
                        IProject proj = (IProject)importedProj.get(i2);
                        monitor.subTask("Opening Project: " + proj.getName());
                        proj.open(monitor);
                    }
                    catch (CoreException e) {
                        this.errorMsgList.add(e);
                    }
                    ++i2;
                }
            }
        }

        private IProject createExistingProject(File prjFile, IProgressMonitor monitor, ArrayList errorMsg) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            Path prjFilePath = new Path(prjFile.getAbsolutePath());
            IProjectDescription newDescription = null;
            String prjName = null;
            try {
                newDescription = workspace.loadProjectDescription((IPath)prjFilePath);
                prjName = newDescription.getName();
            }
            catch (CoreException ex) {
                errorMsg.add(ex.getMessage());
            }
            IProject project = workspace.getRoot().getProject(prjName);
            IProjectDescription description = newDescription;
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(this, project, description){
                private final /* synthetic */ IProject val$project;
                private final /* synthetic */ IProjectDescription val$description;
                private final /* synthetic */ SourceProjectImporter this$1;
                {
                    this.this$1 = this$1;
                    this.val$project = val$project;
                    this.val$description = val$description;
                }

                protected void execute(IProgressMonitor monitor) throws CoreException {
                    this.val$project.create(this.val$description, monitor);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                }
            };
            try {
                monitor.subTask("Creating Project " + project.getName());
                monitor.worked(100);
                op.run((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)new NullProgressMonitor(), 100));
            }
            catch (InterruptedException e) {
                return null;
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                errorMsg.add(t);
                return null;
            }
            return project;
        }

        public ArrayList getErrorMsgList() {
            return this.errorMsgList;
        }
    }
}

