/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.ui.views.userout;

import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.LogRecord;
import com.tssap.tools.ui.views.userout.LogDetailDialogAction;
import com.tssap.util.Util;
import com.tssap.util.action.ICategory;
import com.tssap.util.action.path.DefaultPathProvider;
import com.tssap.util.action.path.IPathProvider;
import com.tssap.util.trace.internal.EclipseFormatter;
import com.tssap.util.trace.internal.ILogListener;
import com.tssap.util.trace.internal.MemLog;
import com.tssap.util.trace.internal.UserLog;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.menu.IMenuFactory;
import com.tssap.util.ui.menu.MenuFactory;
import com.tssap.util.ui.menu.context.ContextMenu;
import com.tssap.util.ui.menu.context.DynamicContextMenu;
import com.tssap.util.ui.menu.context.IContextMenu;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public abstract class BasicUserOutView
extends ViewPart
implements ILogListener {
    private static final Formatter myFormatter = new EclipseFormatter(16);
    protected static final int MEMLOG_AWARE = 1;
    protected static final int USEROUT_AWARE = 2;
    static final int COL_SEVERITY = 0;
    static final int COL_TIME = 1;
    static final int COL_MSG = 2;
    private static String[] columnHeaders = new String[]{"!", "Time", "Message"};
    private static ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnPixelData(19, false), new ColumnPixelData(60, true), new ColumnWeightData(1000)};
    private int logAware;
    private List myShownLogRecords = new ArrayList();
    private TableViewer tableViewer;
    private Table table;
    private MemLog memLog = new MemLog();
    private UserLog userLog = new UserLog();
    private IAction clearAction;

    public BasicUserOutView(int logType) {
        this.logAware = logType;
    }

    protected abstract boolean acceptLog(LogRecord var1);

    protected ICategory getDefaultActionCategory() {
        return LogDetailDialogAction.CATEGORY;
    }

    public void dispose() {
        super.dispose();
        this.memLog.removeLogListener((ILogListener)this);
        this.userLog.removeLogListener((ILogListener)this);
    }

    public void createPartControl(Composite parent) {
        this.createActions();
        this.createActionBar();
        this.table = this.createTable(parent);
        this.tableViewer = this.createTableViewer(this.table);
        this.createColumns();
        this.initTableContent();
        if ((this.logAware & 1) > 0) {
            this.memLog.addLogListener((ILogListener)this);
        }
        if ((this.logAware & 2) > 0) {
            this.userLog.addLogListener((ILogListener)this);
        }
        MenuFactory mf = new MenuFactory();
        mf.getPathProviderManager().addPathProvider((IPathProvider)new DefaultPathProvider());
        DynamicContextMenu cm = new DynamicContextMenu((IMenuFactory)mf);
        cm.setDefaultCategory(this.getDefaultActionCategory());
        ContextMenu.setContextMenuToStructuredViewer((StructuredViewer)this.tableViewer, (IContextMenu)cm);
    }

    private void initTableContent() {
        int i;
        LogRecord[] recs;
        if ((this.logAware & 2) > 0) {
            recs = this.userLog.getMemLogs();
            i = 0;
            while (i < recs.length) {
                this.logged(recs[i]);
                ++i;
            }
        }
        if ((this.logAware & 1) > 0) {
            recs = this.memLog.getMemLogs();
            i = 0;
            while (i < recs.length) {
                this.logged(recs[i]);
                ++i;
            }
        }
    }

    private void createActionBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add(this.clearAction);
    }

    private void createActions() {
        this.clearAction = new ClearAction();
    }

    private TableViewer createTableViewer(Table table) {
        TableViewer ret = new TableViewer(table);
        ret.setLabelProvider((IBaseLabelProvider)new OutViewLableProvider());
        ret.setContentProvider((IContentProvider)new OutViewContentProvider());
        ret.setUseHashlookup(true);
        ret.setInput((Object)"");
        ret.setSorter((ViewerSorter)new OutViewSorter(1));
        return ret;
    }

    private void setTableSorter(OutViewSorter sorter) {
        this.tableViewer.setSorter((ViewerSorter)sorter);
    }

    private void createColumns() {
        SelectionAdapter headerListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int column = BasicUserOutView.this.table.indexOf((TableColumn)e.widget);
                OutViewSorter oldSorter = (OutViewSorter)BasicUserOutView.this.tableViewer.getSorter();
                if (oldSorter != null && column == oldSorter.getCol()) {
                    oldSorter.setReversed(!oldSorter.isReversed());
                    BasicUserOutView.this.tableViewer.refresh();
                } else {
                    BasicUserOutView.this.setTableSorter(new OutViewSorter(column));
                }
            }
        };
        TableLayout layout = new TableLayout();
        int i = 0;
        while (i < columnHeaders.length) {
            layout.addColumnData(columnLayouts[i]);
            TableColumn tc = new TableColumn(this.table, 0, i);
            tc.setResizable(BasicUserOutView.columnLayouts[i].resizable);
            tc.setText(columnHeaders[i]);
            tc.addSelectionListener((SelectionListener)headerListener);
            ++i;
        }
        this.table.setLayout((Layout)layout);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(false);
    }

    private Table createTable(Composite parent) {
        Table ret = new Table(parent, 66306);
        ret.setLinesVisible(true);
        return ret;
    }

    public void setFocus() {
    }

    public void logged(final LogRecord logRec) {
        if (!this.acceptLog(logRec)) {
            return;
        }
        this.myShownLogRecords.add(logRec);
        Display myDisplay = Display.getDefault();
        if (myDisplay != null) {
            myDisplay.asyncExec(new Runnable(){

                public void run() {
                    if (!BasicUserOutView.this.tableViewer.getTable().isDisposed()) {
                        BasicUserOutView.this.tableViewer.add((Object)logRec);
                    }
                }
            });
        }
    }

    private void clearView() {
        this.myShownLogRecords.clear();
        this.tableViewer.refresh();
    }

    protected String getMessageTxt(LogRecord rec) {
        return myFormatter.format(rec);
    }

    class OutViewSorter
    extends ViewerSorter {
        private boolean isReversed = false;
        private int col;

        private OutViewSorter() {
            this(1);
        }

        private OutViewSorter(int column) {
            this.col = column;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int ret = 0;
            LogRecord rec1 = null;
            LogRecord rec2 = null;
            if (e1 instanceof LogRecord) {
                rec1 = (LogRecord)e1;
            }
            if (e2 instanceof LogRecord) {
                rec2 = (LogRecord)e2;
            }
            if (rec1 == null) {
                ret = 1;
            } else if (rec2 == null) {
                ret = -1;
            }
            int catdiff = this.category(e1) - this.category(e2);
            if (this.col == 0) {
                if (catdiff != 0) {
                    ret = -catdiff;
                    ret = this.isReversed() ? -ret : ret;
                } else {
                    ret = -rec1.getTime().compareTo(rec2.getTime());
                }
            } else if (this.col == 1) {
                ret = -rec1.getTime().compareTo(rec2.getTime());
                ret = this.isReversed() ? -ret : ret;
            } else {
                ret = super.compare(viewer, (Object)rec1.getMsgClear(), (Object)rec2.getMsgClear());
                ret = this.isReversed() ? -ret : ret;
            }
            return ret;
        }

        public int category(Object element) {
            int ret = 0;
            if (this.col == 0 && element instanceof LogRecord) {
                ret = ((LogRecord)element).getSeverity();
            }
            return ret;
        }

        public int getCol() {
            return this.col;
        }

        public boolean isReversed() {
            return this.isReversed;
        }

        public void setReversed(boolean isReversed) {
            this.isReversed = isReversed;
        }
    }

    class ClearAction
    extends Action {
        static /* synthetic */ Class class$com$tssap$tools$ui$views$userout$BasicUserOutView;

        public ClearAction() {
            this.setText("Clear");
            this.setToolTipText("Clear View");
            ImageDescriptor id_active = SapIdeUtilImages.getImageDescriptorFromIconsDirectory((String)Util.getPluginID((Class)(class$com$tssap$tools$ui$views$userout$BasicUserOutView == null ? (class$com$tssap$tools$ui$views$userout$BasicUserOutView = ClearAction.class$("com.tssap.tools.ui.views.userout.BasicUserOutView")) : class$com$tssap$tools$ui$views$userout$BasicUserOutView)), (String)"clear_active.gif");
            ImageDescriptor id_deactive = SapIdeUtilImages.getImageDescriptorFromIconsDirectory((String)Util.getPluginID((Class)(class$com$tssap$tools$ui$views$userout$BasicUserOutView == null ? (class$com$tssap$tools$ui$views$userout$BasicUserOutView = ClearAction.class$("com.tssap.tools.ui.views.userout.BasicUserOutView")) : class$com$tssap$tools$ui$views$userout$BasicUserOutView)), (String)"clear_deactive.gif");
            this.setImageDescriptor(id_active);
            this.setDisabledImageDescriptor(id_deactive);
            this.setId((class$com$tssap$tools$ui$views$userout$BasicUserOutView == null ? (class$com$tssap$tools$ui$views$userout$BasicUserOutView = ClearAction.class$("com.tssap.tools.ui.views.userout.BasicUserOutView")) : class$com$tssap$tools$ui$views$userout$BasicUserOutView).getName() + ".ClearAction");
        }

        public void run() {
            BasicUserOutView.this.clearView();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    class OutViewLableProvider
    extends LabelProvider
    implements ITableLabelProvider {
        final Calendar calendar = new GregorianCalendar();
        Image[] imgs = new Image[]{PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"), PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"), PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK")};

        OutViewLableProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            String ret = null;
            if (element instanceof LogRecord) {
                LogRecord rec = (LogRecord)element;
                if (columnIndex == 2) {
                    ret = BasicUserOutView.this.getMessageTxt(rec);
                    if (ret.length() >= 2) {
                        StringTokenizer st = new StringTokenizer(ret, "\n\r");
                        ret = st.hasMoreTokens() ? st.nextToken() : "";
                        if (st.hasMoreTokens()) {
                            ret = ret + " [more]";
                        }
                    }
                } else if (columnIndex == 1) {
                    this.calendar.setTime(rec.getTime());
                    StringBuffer buf = new StringBuffer();
                    buf.append(this.formatTimePart(this.calendar.get(11)));
                    buf.append(":");
                    buf.append(this.formatTimePart(this.calendar.get(12)));
                    buf.append(":");
                    buf.append(this.formatTimePart(this.calendar.get(13)));
                    ret = buf.toString();
                }
            } else {
                ret = "Unknown elememt " + element.getClass().getName();
            }
            return ret == null ? "" : ret;
        }

        private String formatTimePart(int tp) {
            String ret = Integer.toString(tp);
            if (ret.length() == 1) {
                ret = "0" + ret;
            }
            return ret;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image ret = null;
            if (columnIndex == 0 && element instanceof LogRecord) {
                int severity = ((LogRecord)element).getSeverity();
                ret = this.imgs[this.getImgFromSeverity(severity)];
            }
            return ret;
        }

        private int getImgFromSeverity(int severity) {
            int ret = severity >= 500 ? 0 : (severity > 300 ? 1 : 2);
            return ret;
        }
    }

    class OutViewContentProvider
    implements IStructuredContentProvider {
        OutViewContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return BasicUserOutView.this.myShownLogRecords.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

