/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.ui.preferences.trace.tree;

import com.tssap.tools.ui.preferences.trace.tree.SAComperatorI;
import com.tssap.tools.ui.preferences.trace.tree.SAFilterI;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;

public class SATreeElement {
    private static final int UNKNOWN = -1;
    public static final int ALREADY_EXIST = 0;
    public static final int NOT_ADDABLE = 1;
    public static final int ADDED = 2;
    private ArrayList children;
    private SATreeElement parent;
    private SATreeRoot root;
    private Object data;

    private SATreeElement(SATreeElement parent, SATreeRoot root, Object data) {
        this.parent = parent;
        this.root = root;
        this.data = data;
        this.children = new ArrayList();
    }

    public SATreeElement[] getChildren() {
        return this.children.toArray(new SATreeElement[this.children.size()]);
    }

    public SATreeElement getParent() {
        return this.parent;
    }

    public Object getData() {
        return this.data;
    }

    public int addChild(Object data) {
        int ret = -1;
        SAComperatorI comp = this.getRoot().getComperator();
        int result = comp.compare(this.data, data);
        if (result == 1) {
            boolean done = false;
            int i = 0;
            while (i < this.children.size() && !done) {
                result = comp.compare(((SATreeElement)this.children.get(i)).getData(), data);
                if (result == 0) {
                    ret = 0;
                } else if (result == 1) {
                    ret = ((SATreeElement)this.children.get(i)).addChild(data);
                    done = true;
                }
                ++i;
            }
            if (!done) {
                SATreeElement newEl = new SATreeElement(this, this.getRoot(), data);
                SATreeElement[] siblings = this.children.toArray(new SATreeElement[this.children.size()]);
                int i2 = 0;
                while (i2 < siblings.length) {
                    if (comp.compare(data, siblings[i2].getData()) == 1) {
                        newEl.addChildNode(siblings[i2]);
                        ((AbstractCollection)this.children).remove(siblings[i2]);
                    }
                    ++i2;
                }
                this.children.add(newEl);
                ret = 2;
            }
        } else {
            ret = 1;
        }
        return ret;
    }

    private void addChildNode(SATreeElement sATreeElement) {
        this.children.add(sATreeElement);
    }

    public boolean removeChild(Object data, boolean includeSubChildren) {
        SAComperatorI comp = this.getRoot().getComperator();
        boolean done = false;
        int i = 0;
        while (i < this.children.size() && !done) {
            int result = comp.compare(((SATreeElement)this.children.get(i)).getData(), data);
            if (result == 0) {
                if (!includeSubChildren) {
                    SATreeElement[] subChildren = ((SATreeElement)this.children.get(i)).getChildren();
                    this.children.remove(i);
                    this.children.addAll(Arrays.asList(subChildren));
                } else {
                    this.children.remove(i);
                }
                done = true;
            } else if (result == 1) {
                done = ((SATreeElement)this.children.get(i)).removeChild(data, includeSubChildren);
            }
            ++i;
        }
        return done;
    }

    public SATreeElement findChild(Object data) {
        SATreeElement ret = null;
        SAComperatorI comp = this.getRoot().getComperator();
        int result = comp.compare(this.data, data);
        if (result == 0) {
            ret = this;
        } else if (result == 1) {
            int i = 0;
            while (i < this.children.size() && ret == null) {
                ret = ((SATreeElement)this.children.get(i)).findChild(data);
                ++i;
            }
        }
        return ret;
    }

    public ArrayList getContainedDataObjects(SAFilterI filter) {
        ArrayList ret = new ArrayList();
        this.getContainedDataObjects(filter, ret);
        return ret;
    }

    private void getContainedDataObjects(SAFilterI filter, ArrayList result) {
        if (filter.isAccepted(this.data)) {
            result.add(this.data);
        }
        if (filter.mayContain(this.data)) {
            int i = 0;
            while (i < this.children.size()) {
                ((SATreeElement)this.children.get(i)).getContainedDataObjects(filter, result);
                ++i;
            }
        }
    }

    private SATreeRoot getRoot() {
        SATreeRoot ret = this.root;
        if (ret == null && this instanceof SATreeRoot) {
            ret = (SATreeRoot)this;
        }
        return ret;
    }

    public String toString() {
        return "SA:" + this.data.toString();
    }

    public static SATreeRoot createTreeRoot(SAComperatorI comperator) {
        SATreeElement te = new SATreeElement(null, null, null);
        SATreeRoot ret = te.new SATreeRoot(comperator);
        return ret;
    }

    public class SATreeRoot
    extends SATreeElement {
        private SAComperatorI comperator;

        protected SATreeRoot(SAComperatorI comperator) {
            super(null, null, null);
            this.comperator = comperator;
        }

        public SAComperatorI getComperator() {
            return this.comperator;
        }
    }
}

