/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.ui.preferences.trace.ec;

import com.tssap.tools.ui.preferences.trace.data.ConfigManager;
import com.tssap.tools.ui.preferences.trace.data.FormatterData;
import com.tssap.util.ui.EditableVisitor;
import com.tssap.util.ui.IControlVisitor;
import com.tssap.util.ui.SWTUtil;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.GenericComponent;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;

public class FormatterSelectionComp
extends GenericComponent {
    Combo formatterSelector;

    public int getUserGridNumOfColumns() {
        return 2;
    }

    public void initContainer(IGridLayoutPane userArea) {
        userArea.addTextLabel("Formatter ");
        IGridLayoutData comboData = userArea.createGridLayoutData(4, 1, true, false);
        this.formatterSelector = userArea.addComboBox(this.getFormatterNames(), this.getDefaultFormatterName(), true, comboData);
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        if (this.getUserAreaGridLayoutPane() != null) {
            SWTUtil.visitControl((Control)this.getUserAreaGridLayoutPane().getComposite(), (IControlVisitor)new EditableVisitor(this.isEditable()));
        }
    }

    private String getDefaultFormatterName() {
        return ConfigManager.getInstance().getDefaultFormatter().getDisplayName();
    }

    private String[] getFormatterNames() {
        FormatterData[] formatter = ConfigManager.getInstance().getFormatters();
        String[] names = new String[formatter.length];
        int i = 0;
        while (i < names.length) {
            names[i] = formatter[i].getDisplayName();
            ++i;
        }
        return names;
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    public String getSelectedFormatterName() {
        return this.formatterSelector != null ? this.formatterSelector.getItem(this.formatterSelector.getSelectionIndex()) : null;
    }

    public void setSelection(String formatterName) {
        int index = -1;
        String[] items = this.formatterSelector.getItems();
        int i = 0;
        while (i < items.length && index == -1) {
            if (items[i].equals(formatterName)) {
                index = i;
            }
            ++i;
        }
        if (index == -1) {
            index = this.getDefaultIndex();
        }
        if (this.formatterSelector != null) {
            this.formatterSelector.select(index);
        }
    }

    private int getDefaultIndex() {
        return 0;
    }
}

