/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.ui.preferences.trace.ec;

import com.tssap.tools.ui.preferences.trace.data.ConfigManager;
import com.tssap.tools.ui.preferences.trace.data.HandlerData;
import com.tssap.tools.ui.preferences.trace.tree.ITraceConfigElement;
import com.tssap.tools.ui.preferences.trace.tree.SATraceConfigElement;
import com.tssap.tools.ui.preferences.trace.tree.SATraceElement;
import com.tssap.tools.ui.preferences.trace.tree.SATreeElement;
import com.tssap.util.ui.EditableVisitor;
import com.tssap.util.ui.IControlVisitor;
import com.tssap.util.ui.SWTUtil;
import com.tssap.util.ui.dialog.ObjectSelectionDialog;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.GenericComponent;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IObjectEditorComponent;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;

public class ECTraceConfig
extends GenericComponent
implements IObjectEditorComponent {
    private boolean isDataRootElement = false;
    private ITraceConfigElement myConfigData;
    private SATreeElement myTreeElementData;
    private Combo levelCombo;
    private ListViewer handlerList;
    private Button addButton;
    private Button removeButton;
    private Label locTxtLabel;
    private List inheritHandlerList;
    private MyHandlerListCP handlerListCP;
    static /* synthetic */ Class class$com$tssap$tools$ui$preferences$trace$tree$SATreeElement;
    static /* synthetic */ Class class$com$tssap$tools$ui$preferences$trace$tree$ITraceConfigElement;

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        if (this.getUserAreaGridLayoutPane() != null) {
            SWTUtil.visitControl((Control)this.getUserAreaGridLayoutPane().getComposite(), (IControlVisitor)new EditableVisitor(this.isEditable()));
            this.addButton.setEnabled(this.isEditable());
            this.removeButton.setEnabled(this.isEditable());
        }
    }

    public void refreshUIFromData() {
        if (this.myConfigData instanceof SATraceElement) {
            this.locTxtLabel.setText(((SATraceElement)((Object)this.myConfigData)).getName());
        }
        this.inheritHandlerList.removeAll();
        ArrayList inheritHandlerNames = new ArrayList();
        this.calcInheritHandlers(inheritHandlerNames, this.myTreeElementData.getParent());
        int i = 0;
        while (i < inheritHandlerNames.size()) {
            this.inheritHandlerList.add((String)inheritHandlerNames.get(i));
            ++i;
        }
        this.levelCombo.setItems(this.getSelectableLevelNames());
        this.levelCombo.select(this.getComboIndexFromSeverity(this.myConfigData.getSeverity()));
        this.handlerListCP.setHandler(this.myConfigData.getHandlerNames());
        this.handlerList.setInput((Object)"");
        this.handlerList.refresh();
    }

    private void calcInheritHandlers(ArrayList nameCollector, SATreeElement treeElementData) {
        if (treeElementData.getData() instanceof ITraceConfigElement) {
            nameCollector.addAll(Arrays.asList(((ITraceConfigElement)treeElementData.getData()).getHandlerNames()));
        }
        if (treeElementData.getParent() != null) {
            this.calcInheritHandlers(nameCollector, treeElementData.getParent());
        }
    }

    public void refreshDataFromUI() {
        this.myConfigData.setSeverity(this.getServerityFromComboIndex(this.levelCombo.getSelectionIndex()));
        this.myConfigData.setHandlerNames(this.handlerListCP.getHandler());
        this.removeHandler(this.handlerListCP.getHandler(), this.myTreeElementData.getChildren());
    }

    private int getServerityFromComboIndex(int comboIndex) {
        int ret = 0;
        ret = this.isDataRootElement() ? comboIndex + 2 : (comboIndex == 0 ? -1 : comboIndex + 2 - 1);
        return ret;
    }

    private int getComboIndexFromSeverity(int severity) {
        int ret = 0;
        ret = this.isDataRootElement() ? ((ret = severity - 2) < 0 ? 0 : ret) : (severity == -1 ? 0 : ((ret = severity - 2 + 1) <= 0 ? 1 : ret));
        return ret;
    }

    private void removeHandler(String[] handlerNamesToRemove, SATreeElement[] sATreeElements) {
        int i = 0;
        while (i < sATreeElements.length) {
            if (sATreeElements[i].getData() instanceof ITraceConfigElement) {
                ITraceConfigElement tce = (ITraceConfigElement)sATreeElements[i].getData();
                int j = 0;
                while (j < handlerNamesToRemove.length) {
                    tce.removeHandlerName(handlerNamesToRemove[j]);
                    ++j;
                }
            }
            this.removeHandler(handlerNamesToRemove, sATreeElements[i].getChildren());
            ++i;
        }
    }

    public boolean isDataAutoRefreshing() {
        return false;
    }

    public void dispose() {
    }

    public void setData(Object data) {
        if (data instanceof SATreeElement && ((SATreeElement)data).getData() instanceof ITraceConfigElement) {
            this.myTreeElementData = (SATreeElement)data;
            this.myConfigData = (ITraceConfigElement)this.myTreeElementData.getData();
            if (this.myConfigData instanceof SATraceConfigElement) {
                String elName = ((SATraceElement)((Object)this.myConfigData)).getName();
                this.setIsDataRoot("".equals(elName) || "/".equals(elName));
            }
        } else {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + " data must be instanceof " + (class$com$tssap$tools$ui$preferences$trace$tree$SATreeElement == null ? (class$com$tssap$tools$ui$preferences$trace$tree$SATreeElement = ECTraceConfig.class$("com.tssap.tools.ui.preferences.trace.tree.SATreeElement")) : class$com$tssap$tools$ui$preferences$trace$tree$SATreeElement).getName() + "with data content type " + (class$com$tssap$tools$ui$preferences$trace$tree$ITraceConfigElement == null ? (class$com$tssap$tools$ui$preferences$trace$tree$ITraceConfigElement = ECTraceConfig.class$("com.tssap.tools.ui.preferences.trace.tree.ITraceConfigElement")) : class$com$tssap$tools$ui$preferences$trace$tree$ITraceConfigElement).getName());
        }
    }

    public Object getData() {
        return this.myConfigData;
    }

    public void setModifiedCallback(IModifiedCallback callback) {
    }

    public IModifiedCallback getModifiedCallback() {
        return null;
    }

    public String okToLeave() {
        return null;
    }

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutData gridData = userArea.createGridLayoutData(4, 1, this.getUserGridNumOfColumns(), 1);
        this.locTxtLabel = userArea.addTextLabel("", gridData);
        userArea.addPlaceholder(this.getUserGridNumOfColumns(), 1);
        userArea.addTextLabel("Severity ");
        gridData = userArea.createGridLayoutData(4, 4, this.getUserGridNumOfColumns() - 1, 1);
        String[] selectableLevelName = this.getSelectableLevelNames();
        this.levelCombo = userArea.addComboBox(selectableLevelName, selectableLevelName[0], true, gridData);
        userArea.addPlaceholder(this.getUserGridNumOfColumns(), 1);
        userArea.addTextLabel("Inherit Handler ");
        gridData = userArea.createGridLayoutData(4, 4, true, true, 2, 1);
        this.inheritHandlerList = userArea.addList(new String[0], gridData);
        this.inheritHandlerList.setEnabled(false);
        userArea.addTextLabel("Handler ");
        gridData = userArea.createGridLayoutData(4, 4, true, true, 2, 1);
        this.handlerList = userArea.addListViewer(false, gridData);
        this.handlerList.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.handlerListCP = new MyHandlerListCP();
        this.handlerList.setContentProvider((IContentProvider)this.handlerListCP);
        this.handlerList.setInput((Object)"");
        userArea.addPlaceholder();
        this.addButton = userArea.addPushButton("Add");
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ECTraceConfig.this.handleAddButton();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeButton = userArea.addPushButton("Remove");
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ECTraceConfig.this.handleRemoveButton();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private String[] getSelectableLevelNames() {
        String[] selectableLevelName = new String[SATraceConfigElement.SEVERITY_NAMES.length - 2];
        selectableLevelName[0] = SATraceConfigElement.SEVERITY_NAMES[0];
        int i = 1;
        while (i < SATraceConfigElement.SEVERITY_NAMES.length - 2) {
            selectableLevelName[i] = SATraceConfigElement.SEVERITY_NAMES[i + 2];
            ++i;
        }
        if (this.isDataRootElement()) {
            String[] sa = new String[selectableLevelName.length - 1];
            System.arraycopy(selectableLevelName, 1, sa, 0, sa.length);
            selectableLevelName = sa;
        }
        return selectableLevelName;
    }

    private boolean isDataRootElement() {
        return this.isDataRootElement;
    }

    private void setIsDataRoot(boolean b) {
        this.isDataRootElement = b;
    }

    private void handleRemoveButton() {
        int index = this.handlerList.getList().getSelectionIndex();
        if (index >= 0) {
            ArrayList<String> arL = new ArrayList<String>(Arrays.asList(this.handlerListCP.getHandler()));
            arL.remove(index);
            this.handlerListCP.setHandler(arL.toArray(new String[arL.size()]));
            if (arL.size() <= index) {
                --index;
            }
            if (index >= 0) {
                this.handlerList.getList().select(index);
            }
        }
        this.handlerList.setInput((Object)"");
    }

    private void handleAddButton() {
        ObjectSelectionDialog handlerSelectionDiag = new ObjectSelectionDialog(this.levelCombo.getShell(), "Select Handler", "");
        handlerSelectionDiag.setSingleSelection(true);
        handlerSelectionDiag.setLabelProvider((ILabelProvider)new LabelProvider());
        ArrayList<String> activeHandler = new ArrayList<String>(Arrays.asList(this.handlerListCP.getHandler()));
        activeHandler.addAll(Arrays.asList(this.inheritHandlerList.getItems()));
        ArrayList<String> allHandlerArL = new ArrayList<String>();
        HandlerData[] allHandler = ConfigManager.getInstance().getHandlers();
        int i = 0;
        while (i < allHandler.length) {
            allHandlerArL.add(allHandler[i].getDisplayName());
            ++i;
        }
        ((AbstractCollection)allHandlerArL).removeAll(activeHandler);
        Object[] choosableHandler = allHandlerArL.toArray(new String[allHandlerArL.size()]);
        Arrays.sort(choosableHandler);
        Object[] result = handlerSelectionDiag.openDialog(choosableHandler);
        if (result != null && result.length > 0) {
            String newHandler = (String)result[0];
            this.handlerListCP.addHandler(newHandler);
            this.handlerList.setInput((Object)"");
        }
    }

    public int getUserGridNumOfColumns() {
        return 3;
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MyHandlerListCP
    implements IStructuredContentProvider {
        ArrayList handler = new ArrayList();

        private MyHandlerListCP() {
        }

        public void setHandler(String[] handlerNames) {
            this.handler.clear();
            this.handler.addAll(Arrays.asList(handlerNames));
        }

        public void addHandler(String newHandler) {
            this.handler.add(newHandler);
        }

        public String[] getHandler() {
            return this.handler.toArray(new String[this.handler.size()]);
        }

        public Object[] getElements(Object inputElement) {
            return this.handler.toArray(new String[this.handler.size()]);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

