/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.ui.preferences.trace.ec;

import com.tssap.tools.ui.preferences.trace.data.MemoryHandlerData;
import com.tssap.util.ui.EditableVisitor;
import com.tssap.util.ui.IControlVisitor;
import com.tssap.util.ui.SWTUtil;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.GenericComponent;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IObjectEditorComponent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ECMemHandler
extends GenericComponent
implements IObjectEditorComponent {
    private static final String LABEL_TXT = "Mem Log writes logs to memory";
    private Text sizeTextField;
    private Label sizeTextLabel;
    private MemoryHandlerData myData;
    static /* synthetic */ Class class$com$tssap$tools$ui$preferences$trace$data$MemoryHandlerData;

    public void refreshUIFromData() {
        this.sizeTextField.setText("" + this.myData.getMemLogSize());
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        if (this.getUserAreaGridLayoutPane() != null) {
            SWTUtil.visitControl((Control)this.getUserAreaGridLayoutPane().getComposite(), (IControlVisitor)new EditableVisitor(this.isEditable()));
        }
        if (this.sizeTextField != null && !this.sizeTextField.isDisposed()) {
            this.sizeTextField.setEditable(false);
        }
    }

    public void refreshDataFromUI() {
        int val = this.getSizeValFromTextField();
        if (val > 0) {
            this.myData.setMemLogSize(val);
        }
    }

    private int getSizeValFromTextField() {
        int val;
        try {
            val = Integer.parseInt(this.sizeTextField.getText());
        }
        catch (NumberFormatException e) {
            val = -1;
        }
        return val;
    }

    public boolean isDataAutoRefreshing() {
        return false;
    }

    public void dispose() {
    }

    public void setData(Object data) {
        if (!(data instanceof MemoryHandlerData)) {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + " data must be instanceof " + (class$com$tssap$tools$ui$preferences$trace$data$MemoryHandlerData == null ? (class$com$tssap$tools$ui$preferences$trace$data$MemoryHandlerData = ECMemHandler.class$("com.tssap.tools.ui.preferences.trace.data.MemoryHandlerData")) : class$com$tssap$tools$ui$preferences$trace$data$MemoryHandlerData).getName());
        }
        this.myData = (MemoryHandlerData)data;
    }

    public Object getData() {
        return this.myData;
    }

    public void setModifiedCallback(IModifiedCallback callback) {
    }

    public IModifiedCallback getModifiedCallback() {
        return null;
    }

    public String okToLeave() {
        return this.getSizeValFromTextField() > 0 ? null : "Size must be > 0";
    }

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutData lableGridData = userArea.createGridLayoutData(2, 1, this.getUserGridNumOfColumns(), 1);
        IGridLayoutPane labelPane = userArea.addGridLayoutPane(null, 1, lableGridData);
        IGridLayoutData innerLableGridData = userArea.createGridLayoutData(2, 1, true, false);
        labelPane.addTextLabel(LABEL_TXT, innerLableGridData);
        userArea.addPlaceholder(this.getUserGridNumOfColumns(), 1);
        this.sizeTextLabel = userArea.addTextLabel("MemLog Buffer Size ");
        this.sizeTextField = userArea.addTextField(true);
    }

    public int getUserGridNumOfColumns() {
        return 2;
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

