/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.ui.preferences.trace.ec;

import com.tssap.tools.ui.preferences.trace.data.ConfigManager;
import com.tssap.tools.ui.preferences.trace.data.FileHandlerData;
import com.tssap.tools.ui.preferences.trace.ec.FormatterSelectionComp;
import com.tssap.util.ui.EditableVisitor;
import com.tssap.util.ui.IControlVisitor;
import com.tssap.util.ui.SWTUtil;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.GenericComponent;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IObjectEditorComponent;
import com.tssap.util.ui.reuse.chooser.IChooser;
import com.tssap.util.ui.reuse.chooser.impl.DropDownSelector;
import com.tssap.util.ui.reuse.chooser.impl.FileChooser;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class ECFileHandler
extends GenericComponent
implements IObjectEditorComponent {
    private static final int GRID_NUM_COL = 2;
    private String[] ERROR_MSG = new String[]{null, "File Location must be specified", "Max File length contains invalid value", "Number of rotation files contains invalid value", "Max File length must be set"};
    private static final String LABEL_TXT = "File Log";
    private FormatterSelectionComp formatterSelectionComp;
    private Text txt_maxFileSize;
    private Text txt_rotFileNum;
    private DropDownSelector dds_fileSelector;
    private FileHandlerData myData;
    static /* synthetic */ Class class$com$tssap$tools$ui$preferences$trace$data$FileHandlerData;

    public void refreshUIFromData() {
        String formatterSel = this.myData != null && this.myData.getFormatterData() != null ? this.myData.getFormatterData().getDisplayName() : "";
        this.formatterSelectionComp.setSelection(formatterSel);
        String filePattern = this.myData.getFileNamePattern();
        this.dds_fileSelector.setText(filePattern != null ? filePattern : "");
        this.txt_maxFileSize.setText(this.myData.getMaxFileSize() == -1 ? "" : "" + this.myData.getMaxFileSize());
        this.txt_rotFileNum.setText(this.myData.getRotFileNum() == -1 ? "" : "" + this.myData.getRotFileNum());
    }

    public void refreshDataFromUI() {
        if (this.validateInput() == null) {
            this.myData.setMaxFileSize(this.getPosIntFromString(this.txt_maxFileSize.getText().trim()));
            this.myData.setRotFileNum(this.getPosIntFromString(this.txt_rotFileNum.getText().trim()));
            this.myData.setFileNamePattern(this.dds_fileSelector.getText());
            this.myData.setFormatterData(ConfigManager.getInstance().getFormatter(this.formatterSelectionComp.getSelectedFormatterName()));
        }
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        if (this.getUserAreaGridLayoutPane() != null) {
            SWTUtil.visitControl((Control)this.getUserAreaGridLayoutPane().getComposite(), (IControlVisitor)new EditableVisitor(this.isEditable()));
        }
    }

    private String validateInput() {
        int errorType = 0;
        String maxSizeStr = this.txt_maxFileSize.getText().trim();
        String rotNumStr = this.txt_rotFileNum.getText().trim();
        int maxSize = this.getPosIntFromString(maxSizeStr);
        int rotNum = this.getPosIntFromString(rotNumStr);
        if (this.dds_fileSelector.getText().trim().equals("")) {
            errorType = 1;
        } else if (maxSize == -1 && !maxSizeStr.equals("")) {
            errorType = 2;
        } else if (rotNum == -1 && !rotNumStr.equals("")) {
            errorType = 3;
        } else if (maxSize == -1 && rotNum > 0) {
            errorType = 4;
        }
        return this.ERROR_MSG[errorType];
    }

    private int getPosIntFromString(String s) {
        int val;
        try {
            val = Integer.parseInt(s);
            if (val <= 0) {
                val = -1;
            }
        }
        catch (NumberFormatException e) {
            val = -1;
        }
        return val;
    }

    public boolean isDataAutoRefreshing() {
        return false;
    }

    public void dispose() {
    }

    public void setData(Object data) {
        if (!(data instanceof FileHandlerData)) {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + " data must be instanceof " + (class$com$tssap$tools$ui$preferences$trace$data$FileHandlerData == null ? (class$com$tssap$tools$ui$preferences$trace$data$FileHandlerData = ECFileHandler.class$("com.tssap.tools.ui.preferences.trace.data.FileHandlerData")) : class$com$tssap$tools$ui$preferences$trace$data$FileHandlerData).getName());
        }
        this.myData = (FileHandlerData)data;
    }

    public Object getData() {
        return this.myData;
    }

    public void setModifiedCallback(IModifiedCallback callback) {
    }

    public IModifiedCallback getModifiedCallback() {
        return null;
    }

    public String okToLeave() {
        return this.validateInput();
    }

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutData gridData = userArea.createGridLayoutData(2, 1, this.getUserGridNumOfColumns(), 1);
        IGridLayoutPane gridPane = userArea.addGridLayoutPane(null, 1, gridData);
        IGridLayoutData innerGridData = gridPane.createGridLayoutData(2, 1, true, false);
        gridPane.addTextLabel(LABEL_TXT, innerGridData);
        userArea.addPlaceholder(this.getUserGridNumOfColumns(), 1);
        this.formatterSelectionComp = new FormatterSelectionComp();
        this.formatterSelectionComp.createPartControl(userArea);
        userArea.addPlaceholder(this.getUserGridNumOfColumns(), 1);
        this.dds_fileSelector = new DropDownSelector();
        this.dds_fileSelector.setButtonText("...");
        this.dds_fileSelector.setDescriptionPositionLeft(true);
        this.dds_fileSelector.setSelectorDescription("Log File Location");
        this.dds_fileSelector.setHasPushButton(true);
        this.dds_fileSelector.setItemsMaxLength(0);
        this.dds_fileSelector.setPushButtonChooser((IChooser)new FileChooser(0));
        gridData = userArea.createGridLayoutData(4, 1, this.getUserGridNumOfColumns(), 1);
        gridPane = userArea.addGridLayoutPane(null, this.dds_fileSelector.getUserGridNumOfColumns(), gridData);
        this.dds_fileSelector.createPartControl(gridPane);
        userArea.addPlaceholder(this.getUserGridNumOfColumns(), 1);
        gridData = userArea.createGridLayoutData(4, 1, this.getUserGridNumOfColumns(), 1);
        gridPane = userArea.addGridLayoutPane(null, 2, gridData);
        gridPane.addTextLabel("Maximum File Size (byte)");
        this.txt_maxFileSize = gridPane.addTextField(false);
        gridPane.addTextLabel("Number of rotating Files");
        this.txt_rotFileNum = gridPane.addTextField(false);
    }

    public int getUserGridNumOfColumns() {
        return 2;
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

