/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.ui.preferences.trace.data;

import com.tssap.tools.ui.preferences.trace.LogConstants;
import com.tssap.tools.ui.preferences.trace.data.HandlerData;
import java.util.Hashtable;
import java.util.Properties;

public class FileHandlerData
extends HandlerData {
    static final long serialVersionUID = -7774159305504111675L;
    private static final int NONE = -1;
    private static final String DEFAULT_FILE = "%t/trace.log";
    private int maxFileSize = -1;
    private int rotFileNum = -1;
    private String fileNamePattern;

    protected FileHandlerData(String displayName) {
        super("FileLog", displayName);
    }

    public int getType() {
        return 3;
    }

    public static FileHandlerData createFileHandlerData(String displayName) {
        return new FileHandlerData(displayName);
    }

    public String getFileNamePattern() {
        return this.fileNamePattern;
    }

    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    public int getRotFileNum() {
        return this.rotFileNum;
    }

    public void setFileNamePattern(String fileNamePattern) {
        this.fileNamePattern = fileNamePattern;
    }

    public void setMaxFileSize(int maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setRotFileNum(int rotFileNum) {
        this.rotFileNum = rotFileNum;
    }

    public Properties getLoggingProperties() {
        Properties ret = super.getLoggingProperties();
        ((Hashtable)ret).put("log[" + LogConstants.normaliseConfigStr(this.getDisplayName()) + "].pattern", this.getFileNamePattern());
        if (this.getMaxFileSize() != -1) {
            ((Hashtable)ret).put("log[" + LogConstants.normaliseConfigStr(this.getDisplayName()) + "].limit", "" + this.getMaxFileSize());
        }
        if (this.getRotFileNum() != -1) {
            ((Hashtable)ret).put("log[" + LogConstants.normaliseConfigStr(this.getDisplayName()) + "].cnt", "" + this.getRotFileNum());
        }
        return ret;
    }
}

