/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.ui.preferences.trace.data;

import com.tssap.tools.ui.ToolsUIPlugin;
import com.tssap.tools.ui.preferences.trace.LogConstants;
import com.tssap.tools.ui.preferences.trace.data.ConsoleHandlerData;
import com.tssap.tools.ui.preferences.trace.data.EclipseFormatterData;
import com.tssap.tools.ui.preferences.trace.data.EclipseLogHandlerData;
import com.tssap.tools.ui.preferences.trace.data.FileHandlerData;
import com.tssap.tools.ui.preferences.trace.data.FormatterData;
import com.tssap.tools.ui.preferences.trace.data.HandlerData;
import com.tssap.tools.ui.preferences.trace.data.MemoryHandlerData;
import com.tssap.tools.ui.preferences.trace.data.TraceFormatterData;
import com.tssap.tools.ui.preferences.trace.tree.SAFilterI;
import com.tssap.tools.ui.preferences.trace.tree.SATraceConfigElement;
import com.tssap.tools.ui.preferences.trace.tree.SATraceElement;
import com.tssap.tools.ui.preferences.trace.tree.SATreeComperator;
import com.tssap.tools.ui.preferences.trace.tree.SATreeElement;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class ConfigManager {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$tools$ui$preferences$trace$data$ConfigManager == null ? (class$com$tssap$tools$ui$preferences$trace$data$ConfigManager = ConfigManager.class$("com.tssap.tools.ui.preferences.trace.data.ConfigManager")) : class$com$tssap$tools$ui$preferences$trace$data$ConfigManager));
    private static ConfigManager instance;
    private HashMap myHandler;
    private HashMap myFormatter;
    private SATraceElement locationRootData = new SATraceConfigElement("", "All Locations", 0, 1);
    private SATraceElement categoryRootData = new SATraceConfigElement("/", "All Categories", 0, 2);
    private SATraceElement[] activeLocs;
    private SATraceElement[] activeCats;
    private SATraceConfigElement[] definedLocConfigs;
    private SATraceConfigElement[] definedCatConfigs;
    private SATreeElement.SATreeRoot mySATreeRoot;
    static /* synthetic */ Class class$com$tssap$tools$ui$preferences$trace$data$ConfigManager;
    static /* synthetic */ Class class$com$tssap$util$trace$internal$UserLogFilter;

    private ConfigManager() {
        this.myHandler = new HashMap();
        this.myFormatter = new HashMap();
        this.loadActivePluginLocations();
        this.tmpInit();
    }

    public static ConfigManager getInstance() {
        if (instance == null) {
            instance = new ConfigManager();
        }
        return instance;
    }

    private void tmpInit() {
        this.restoreSATree();
        this.restoreDefaultHandler();
        this.restoreDefaultConfig();
    }

    public void restoreDefaultHandler() {
        this.myHandler.clear();
        this.myFormatter.clear();
        TraceFormatterData tfd1 = new TraceFormatterData("TraceFormatter", "Short Formatter", false);
        TraceFormatterData tfd2 = new TraceFormatterData("TraceFormatter", "Normal Formatter", false);
        TraceFormatterData tfd3 = new TraceFormatterData("TraceFormatter", "Long Formatter", false);
        TraceFormatterData tfd4 = new TraceFormatterData("TraceFormatter", "Configurable Formatter", true);
        EclipseFormatterData efd = new EclipseFormatterData();
        tfd1.setPattern("%d %l %s: %m");
        tfd2.setPattern("%24d %-40-l [%t] %s: %m");
        tfd3.setPattern("%24d [%i] %-40-l [%t] %s: %m ");
        tfd4.setPattern("%24d %-40-l [%t] %s: %m");
        this.addFormatter(tfd1);
        this.addFormatter(tfd2);
        this.addFormatter(tfd3);
        this.addFormatter(tfd4);
        this.addFormatter(efd);
        HandlerData[] hd = new HandlerData[]{ConsoleHandlerData.getInstance(), MemoryHandlerData.getInstance(), EclipseLogHandlerData.getInstance(), FileHandlerData.createFileHandlerData("File Log 1"), FileHandlerData.createFileHandlerData("File Log 2"), FileHandlerData.createFileHandlerData("File Log 3")};
        int i = 3;
        while (i < hd.length) {
            ((FileHandlerData)hd[i]).setFileNamePattern("C:/Temp/eclipseLog_" + (i - 2) + ".log");
            ++i;
        }
        int i2 = 0;
        while (i2 < hd.length) {
            hd[i2].setFormatterData(this.getDefaultFormatter());
            this.addHandler(hd[i2]);
            ++i2;
        }
    }

    public void restoreDefaultConfig() {
        ArrayList allData = this.mySATreeRoot.getContainedDataObjects(new SAAllFilter());
        SATraceConfigElement[] confEl = allData.toArray(new SATraceConfigElement[0]);
        int i = 0;
        while (i < confEl.length) {
            confEl[i].setSeverity(-1);
            confEl[i].removeAllHandlerNames();
            ++i;
        }
        SATraceConfigElement locRoot = (SATraceConfigElement)this.mySATreeRoot.findChild(this.locationRootData).getData();
        SATraceConfigElement catRoot = (SATraceConfigElement)this.mySATreeRoot.findChild(this.categoryRootData).getData();
        locRoot.setSeverity(2);
        locRoot.addHandlerName("Console Log");
        locRoot.addHandlerName("Memory Log");
        catRoot.setSeverity(2);
        catRoot.addHandlerName("Console Log");
        catRoot.addHandlerName("Memory Log");
    }

    public HandlerData[] getHandlers() {
        return this.myHandler.values().toArray(new HandlerData[this.myHandler.size()]);
    }

    public FormatterData[] getFormatters() {
        return this.myFormatter.values().toArray(new FormatterData[this.myFormatter.size()]);
    }

    void addHandler(HandlerData handler) {
        this.myHandler.put(handler.getDisplayName(), handler);
    }

    void addFormatter(FormatterData formatter) {
        this.myFormatter.put(formatter.getDisplayName(), formatter);
    }

    public FormatterData getDefaultFormatter() {
        return this.getFormatter("Eclipse Formatter");
    }

    public FormatterData getFormatter(String name) {
        return (FormatterData)this.myFormatter.get(name);
    }

    public HandlerData getHandler(String name) {
        return (HandlerData)this.myHandler.get(name);
    }

    private void loadActivePluginLocations() {
        Properties p = ToolsUIPlugin.getDefault().getActiveTraceUIMapping();
        ArrayList<SATraceElement> locsArL = new ArrayList<SATraceElement>();
        ArrayList<SATraceElement> catsArL = new ArrayList<SATraceElement>();
        Enumeration enumeration = ((Hashtable)p).keys();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            int type = name.startsWith("/") ? 2 : 1;
            SATraceElement newEl = new SATraceElement(name, p.getProperty(name), 0, type);
            if (type == 1) {
                locsArL.add(newEl);
                continue;
            }
            catsArL.add(newEl);
        }
        this.activeLocs = locsArL.toArray(new SATraceElement[locsArL.size()]);
        this.activeCats = catsArL.toArray(new SATraceElement[catsArL.size()]);
    }

    private void restoreSATree() {
        this.mySATreeRoot = SATreeElement.createTreeRoot(new SATreeComperator());
        this.addDefaultLocCatRoots();
        this.updateDefinedConfigsWithActive();
    }

    /*
     * Loose catch block
     */
    public void loadFromFile(File f) {
        block21: {
            this.myHandler.clear();
            this.myFormatter.clear();
            this.mySATreeRoot = SATreeElement.createTreeRoot(new SATreeComperator());
            boolean done = false;
            ObjectInputStream obIn = null;
            obIn = new ObjectInputStream(new FileInputStream(f));
            HandlerData[] handler = (HandlerData[])obIn.readObject();
            FormatterData[] formatter = (FormatterData[])obIn.readObject();
            SATraceElement[] traceEl = (SATraceElement[])obIn.readObject();
            int i = 0;
            while (i < handler.length) {
                this.addHandler(handler[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < formatter.length) {
                this.addFormatter(formatter[i2]);
                ++i2;
            }
            int i3 = 0;
            while (i3 < traceEl.length) {
                this.mySATreeRoot.addChild(traceEl[i3]);
                ++i3;
            }
            done = true;
            Object var11_11 = null;
            try {
                if (obIn != null) {
                    obIn.close();
                }
            }
            catch (IOException e2) {
                tracer.warning("Closing stream failed", (Throwable)e2);
            }
            if (!done) {
                this.restoreDefaultHandler();
                this.restoreSATree();
                this.restoreDefaultConfig();
            } else {
                this.deactivateTree();
                this.updateDefinedConfigsWithActive();
                this.addDefaultLocCatRoots();
                {
                    break block21;
                    catch (Exception e) {
                        tracer.warning("Error loading ConfigManager from File. Restoring Default values. Reason:", (Throwable)e);
                        Object var11_12 = null;
                        try {
                            if (obIn != null) {
                                obIn.close();
                            }
                        }
                        catch (IOException e2) {
                            tracer.warning("Closing stream failed", (Throwable)e2);
                        }
                        if (!done) {
                            this.restoreDefaultHandler();
                            this.restoreSATree();
                            this.restoreDefaultConfig();
                        } else {
                            this.deactivateTree();
                            this.updateDefinedConfigsWithActive();
                            this.addDefaultLocCatRoots();
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    try {
                        if (obIn != null) {
                            obIn.close();
                        }
                    }
                    catch (IOException e2) {
                        tracer.warning("Closing stream failed", (Throwable)e2);
                    }
                    if (!done) {
                        this.restoreDefaultHandler();
                        this.restoreSATree();
                        this.restoreDefaultConfig();
                    } else {
                        this.deactivateTree();
                        this.updateDefinedConfigsWithActive();
                        this.addDefaultLocCatRoots();
                    }
                    throw throwable;
                }
            }
        }
    }

    private void deactivateTree() {
        SATraceElement[] allData = this.getAllTreeData();
        int i = 0;
        while (i < allData.length) {
            allData[i].setStatus(1);
            ++i;
        }
    }

    /*
     * Loose catch block
     */
    public void saveToFile(File f) {
        block13: {
            HandlerData[] handler = new HandlerData[this.myHandler.size()];
            int i = 0;
            Iterator iter = this.myHandler.values().iterator();
            while (iter.hasNext()) {
                handler[i] = (HandlerData)iter.next();
                ++i;
            }
            FormatterData[] formatter = new FormatterData[this.myFormatter.size()];
            i = 0;
            Iterator iter2 = this.myFormatter.values().iterator();
            while (iter2.hasNext()) {
                formatter[i] = (FormatterData)iter2.next();
                ++i;
            }
            SATraceElement[] traceEl = this.getAllTreeData();
            ObjectOutputStream obOut = null;
            obOut = new ObjectOutputStream(new FileOutputStream(f));
            obOut.writeObject(handler);
            obOut.writeObject(formatter);
            obOut.writeObject(traceEl);
            Object var11_9 = null;
            try {
                if (obOut != null) {
                    obOut.close();
                }
                break block13;
            }
            catch (IOException e2) {
                tracer.warning("Closing stream failed", (Throwable)e2);
            }
            break block13;
            {
                catch (Exception e) {
                    tracer.error("Error saving config: ", (Throwable)e);
                    Object var11_10 = null;
                    try {
                        if (obOut != null) {
                            obOut.close();
                        }
                        break block13;
                    }
                    catch (IOException e2) {
                        tracer.warning("Closing stream failed", (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                try {
                    if (obOut != null) {
                        obOut.close();
                    }
                }
                catch (IOException e2) {
                    tracer.warning("Closing stream failed", (Throwable)e2);
                }
                throw throwable;
            }
        }
    }

    private SATraceElement[] getAllTreeData() {
        SATraceElement[] traceEl = this.mySATreeRoot.getContainedDataObjects(new SAAllFilter()).toArray(new SATraceElement[0]);
        return traceEl;
    }

    private void addDefaultLocCatRoots() {
        this.addAndSetActive(this.locationRootData);
        this.addAndSetActive(this.categoryRootData);
    }

    private void updateDefinedConfigsWithActive() {
        int i = 0;
        while (i < this.activeLocs.length) {
            this.addAndSetActive(this.activeLocs[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.activeCats.length) {
            this.addAndSetActive(this.activeCats[i2]);
            ++i2;
        }
    }

    private void addAndSetActive(SATraceElement dataElement) {
        SATreeElement el = this.mySATreeRoot.findChild(dataElement);
        if (el == null) {
            this.mySATreeRoot.addChild(new SATraceConfigElement(dataElement));
        } else if (el.getData() instanceof SATraceConfigElement) {
            SATraceConfigElement tce = (SATraceConfigElement)el.getData();
            tce.setStatus(0);
            tce.setDisplayName(dataElement.getDisplayName());
            tce.setName(dataElement.getName());
            tce.setType(dataElement.getType());
        }
    }

    public Properties getLoggingProperties() {
        Properties ret = new Properties();
        HashMap<String, HandlerData> handlerToWrite = new HashMap<String, HandlerData>();
        ArrayList conigElementList = this.mySATreeRoot.getContainedDataObjects(new HasConfigDataFilter());
        int i = 0;
        while (i < conigElementList.size()) {
            String[] handlerNames;
            SATraceConfigElement confEl = (SATraceConfigElement)conigElementList.get(i);
            if (confEl.getSeverity() != -1) {
                ((Hashtable)ret).put(confEl.getName() + ".severity", SATraceConfigElement.SEVERITY_NAMES[confEl.getSeverity() + 1]);
            }
            if ((handlerNames = confEl.getHandlerNames()).length > 0) {
                StringBuffer logNames = new StringBuffer();
                int j = 0;
                while (j < handlerNames.length) {
                    logNames.append((j == 0 ? "" : ", ") + "log[" + LogConstants.normaliseConfigStr(handlerNames[j]) + "]");
                    handlerToWrite.put(handlerNames[j], this.getHandler(handlerNames[j]));
                    if ("/".equals(confEl.getName())) {
                        ((Hashtable)ret).put("log[" + LogConstants.normaliseConfigStr(handlerNames[j]) + "].filters", (class$com$tssap$util$trace$internal$UserLogFilter == null ? ConfigManager.class$("com.tssap.util.trace.internal.UserLogFilter") : class$com$tssap$util$trace$internal$UserLogFilter).getName());
                    }
                    ++j;
                }
                ((Hashtable)ret).put(confEl.getName() + ".logs", logNames.toString());
            }
            ++i;
        }
        Collection hd = handlerToWrite.values();
        Iterator iter = hd.iterator();
        while (iter.hasNext()) {
            HandlerData handler = (HandlerData)iter.next();
            ((Hashtable)ret).putAll(handler.getLoggingProperties());
        }
        return ret;
    }

    public SATreeElement.SATreeRoot getSATreeRoot() {
        return this.mySATreeRoot;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class HasConfigDataFilter
    extends SAAllFilter {
        private HasConfigDataFilter() {
        }

        public boolean isAccepted(Object obj) {
            SATraceConfigElement configEl;
            boolean ret = false;
            if (obj instanceof SATraceConfigElement && (configEl = (SATraceConfigElement)obj).getHandlerNames().length > 0 | configEl.getSeverity() != -1) {
                ret = true;
            }
            return ret;
        }
    }

    private class SAAllFilter
    implements SAFilterI {
        private SAAllFilter() {
        }

        public boolean isAccepted(Object obj) {
            return obj != null;
        }

        public boolean mayContain(Object arg0) {
            return true;
        }
    }
}

