/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.ui.preferences.trace;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.LogController;
import com.sap.tc.logging.PropertiesConfigurator;
import com.tssap.tools.ui.ToolsUIPlugin;
import com.tssap.tools.ui.preferences.trace.PropertyFileConfigDialog;
import com.tssap.tools.ui.preferences.trace.data.ConfigManager;
import com.tssap.tools.ui.preferences.trace.ec.TraceTabEditorComp;
import com.tssap.tools.ui.preferences.trace.tree.SAFilterI;
import com.tssap.tools.ui.preferences.trace.tree.SATraceElement;
import com.tssap.tools.ui.preferences.trace.tree.SATreeElement;
import com.tssap.util.Util;
import com.tssap.util.UtilPlugin;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.trace.internal.DefaultEclipseLogFilter;
import com.tssap.util.trace.internal.PlatformLogListener;
import com.tssap.util.ui.dialog.CheckboxSelectionDialog;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TraceConfigUIPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$tools$ui$preferences$trace$TraceConfigUIPreferencePage == null ? (class$com$tssap$tools$ui$preferences$trace$TraceConfigUIPreferencePage = TraceConfigUIPreferencePage.class$("com.tssap.tools.ui.preferences.trace.TraceConfigUIPreferencePage")) : class$com$tssap$tools$ui$preferences$trace$TraceConfigUIPreferencePage));
    private static final String CONFIG_MANAGER_DAT_FILENAME = "ConfManagerData.dat";
    private static final String CURRENT_TRACE_CONFIG_FILENAME = "currentTraceProps.properties";
    private static final String PREFSTORE_FILENAME = "TraceConfigPreference.pref";
    public static final int NOTALLOWED_LEVEL_NUM = 2;
    private TraceTabEditorComp traceConfigEC;
    private Button butSave;
    private Button butSaveAs;
    private Button butLoad;
    private Button propFileCheckBox;
    private File lastOpendConfigFile = null;
    private PropertyFileConfigDialog lastPropFileDiag;
    private IGridLayoutPane mainPane;
    private IGridLayoutPane subPane;
    static /* synthetic */ Class class$com$tssap$tools$ui$preferences$trace$TraceConfigUIPreferencePage;
    static /* synthetic */ Class class$com$tssap$util$UtilPlugin;
    static /* synthetic */ Class class$com$tssap$tools$ui$ToolsUIPlugin;

    public void init(IWorkbench workbench) {
        this.initPreferences();
    }

    protected Control createContents(Composite parent) {
        if (tracer.debug()) {
            StringBuffer sBuf = new StringBuffer("creating TraceConfigUI\n");
            String[] filteredNames = DefaultEclipseLogFilter.getFilteredSourceNames();
            sBuf.append("Default EclipseLog fitered source names\n");
            int i = 0;
            while (i < filteredNames.length) {
                sBuf.append(filteredNames[i]);
                sBuf.append("\n");
                ++i;
            }
            tracer.debug(sBuf.toString());
        }
        this.mainPane = PaneFactory.createGridLayoutPane((Composite)parent, (int)1);
        IGridLayoutData gridData = this.mainPane.createGridLayoutData(4, 4, true, true);
        this.subPane = this.mainPane.addGridLayoutPane(1, gridData);
        GridData data = new GridData(1808);
        data.widthHint = 600;
        data.heightHint = 300;
        this.subPane.getComposite().setLayoutData((Object)data);
        gridData = this.subPane.createGridLayoutData(4, 1, true, false);
        this.createSaveButtonGroup(this.subPane, gridData);
        this.traceConfigEC = new TraceTabEditorComp();
        this.traceConfigEC.setData(this.createConfigManager());
        this.traceConfigEC.createPartControl(this.subPane);
        gridData = this.mainPane.createGridLayoutData(1, 4, true, false);
        this.propFileCheckBox = this.mainPane.addCheckBox("Use special Property File", false, gridData);
        this.propFileCheckBox.addSelectionListener((SelectionListener)new MySelectionAdapter(){

            public void handleSelection() {
                TraceConfigUIPreferencePage.this.handlePropFileCheckboxPressed();
            }
        });
        Composite ret = this.mainPane.getComposite();
        ret.setLayoutData((Object)new GridData(0));
        return ret;
    }

    private void createSaveButtonGroup(IGridLayoutPane pane, IGridLayoutData gridData) {
        IGridLayoutPane saveButPane = pane.addGridLayoutPane(5, gridData);
        this.butSave = saveButPane.addPushButton("Save");
        this.butSave.addSelectionListener((SelectionListener)new MySelectionAdapter(){

            public void handleSelection() {
                TraceConfigUIPreferencePage.this.handleSaveButPressed();
            }
        });
        this.butSaveAs = saveButPane.addPushButton("Save as");
        this.butSaveAs.addSelectionListener((SelectionListener)new MySelectionAdapter(){

            public void handleSelection() {
                TraceConfigUIPreferencePage.this.handleSaveAsButPressed();
            }
        });
        this.butLoad = saveButPane.addPushButton("Open");
        this.butLoad.addSelectionListener((SelectionListener)new MySelectionAdapter(){

            public void handleSelection() {
                TraceConfigUIPreferencePage.this.handleLoadButPressed();
            }
        });
        IGridLayoutData placeHolderGridData = pane.createGridLayoutData(4, 4, true, false);
        saveButPane.addPlaceholder(placeHolderGridData);
    }

    private void activateConfig() {
        this.traceConfigEC.refreshDataFromUI();
        TraceConfigUIPreferencePage.activateLogProperties(this.getConfigProps());
    }

    private void makeConfigDefault() {
        this.traceConfigEC.refreshDataFromUI();
        TraceConfigUIPreferencePage.saveAsDefaultConfig(this.getConfigProps());
    }

    private Properties getConfigProps() {
        Properties ret = UtilPlugin.getInstance().getDefaultLogProperties();
        ((Hashtable)ret).putAll(ConfigManager.getInstance().getLoggingProperties());
        return ret;
    }

    private void handlePropFileCheckboxPressed() {
        if (this.propFileCheckBox.getSelection()) {
            PropertyFileConfigDialog diag = new PropertyFileConfigDialog(this.getShell());
            int result = diag.open();
            if (result == 0) {
                this.lastPropFileDiag = diag;
                this.subPane.getComposite().setEnabled(false);
            } else {
                this.propFileCheckBox.setSelection(false);
                this.subPane.getComposite().setEnabled(true);
            }
        } else {
            this.subPane.getComposite().setEnabled(true);
        }
    }

    private void handleLoadButPressed() {
        FileDialog fd = new FileDialog(this.getShell(), 4096);
        fd.setFilterExtensions(new String[]{"*.tcfg"});
        String filePath = fd.open();
        if (filePath != null) {
            this.lastOpendConfigFile = new File(filePath);
            ConfigManager.getInstance().loadFromFile(this.lastOpendConfigFile);
        }
        this.traceConfigEC.setData(ConfigManager.getInstance());
        this.traceConfigEC.refreshUIFromData();
    }

    private void handleSaveAsButPressed() {
        FileDialog fd = new FileDialog(this.getShell(), 8192);
        fd.setFilterExtensions(new String[]{"*.tcfg"});
        String filePath = fd.open();
        if (filePath != null) {
            if (!filePath.endsWith(".tcfg")) {
                filePath = filePath + ".tcfg";
            }
            this.traceConfigEC.refreshDataFromUI();
            this.lastOpendConfigFile = new File(filePath);
            ConfigManager.getInstance().saveToFile(this.lastOpendConfigFile);
        }
    }

    private void handleSaveButPressed() {
        if (this.lastOpendConfigFile != null) {
            this.traceConfigEC.refreshDataFromUI();
            ConfigManager.getInstance().saveToFile(this.lastOpendConfigFile);
        } else {
            this.handleSaveAsButPressed();
        }
    }

    private ConfigManager createConfigManager() {
        return ConfigManager.getInstance();
    }

    private void initPreferences() {
        File defaultConfigFile = TraceConfigUIPreferencePage.getConfigManagerDataFile();
        if (defaultConfigFile != null && defaultConfigFile.exists()) {
            ConfigManager.getInstance().loadFromFile(defaultConfigFile);
        } else {
            ConfigManager.getInstance().restoreDefaultConfig();
            ConfigManager.getInstance().restoreDefaultHandler();
            tracer.info("Default config file not found for trace configuration dialog");
        }
    }

    private void savePreferences() {
        File dataFile = TraceConfigUIPreferencePage.getConfigManagerDataFile();
        if (dataFile != null) {
            ConfigManager.getInstance().saveToFile(dataFile);
        }
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    protected void performDefaults() {
        ArrayList inactiveData = ConfigManager.getInstance().getSATreeRoot().getContainedDataObjects(new SAFilterI(){

            public boolean isAccepted(Object data) {
                boolean ret = false;
                if (data instanceof SATraceElement && ((SATraceElement)data).getStatus() == 1) {
                    ret = true;
                }
                return ret;
            }

            public boolean mayContain(Object data) {
                return true;
            }
        });
        boolean restoreDefaultServAndHandler = true;
        if (inactiveData.size() > 0) {
            restoreDefaultServAndHandler = false;
            int[] result = CheckboxSelectionDialog.openDialog((Shell)this.getShell(), (String)"Please choose operation", (String)"", (String[])new String[]{"Reset default severities and handlers", "Remove inactive location and category entries"}, (int[])new int[]{0});
            if (result != null) {
                int i = 0;
                while (i < result.length) {
                    if (result[i] == 0) {
                        restoreDefaultServAndHandler = true;
                    } else if (result[i] == 1) {
                        SATreeElement.SATreeRoot rootEl = ConfigManager.getInstance().getSATreeRoot();
                        Iterator iter = ((AbstractList)inactiveData).iterator();
                        while (iter.hasNext()) {
                            rootEl.removeChild(iter.next(), false);
                        }
                    }
                    ++i;
                }
            }
        }
        if (restoreDefaultServAndHandler) {
            int activeTab = this.traceConfigEC.getCurrentSelectedIndex();
            if (activeTab == 1) {
                ConfigManager.getInstance().restoreDefaultHandler();
            } else if (activeTab == 0) {
                ConfigManager.getInstance().restoreDefaultConfig();
            }
            this.traceConfigEC.setData(ConfigManager.getInstance());
            this.traceConfigEC.refreshUIFromData();
        }
    }

    protected void performApply() {
        this.performOk();
    }

    public boolean performOk() {
        String leaveOkAnswer = this.isConfifECReadyToLeave();
        if (this.propFileCheckBox.getSelection()) {
            File configFile = this.lastPropFileDiag.getSelectedFile();
            if (configFile != null && configFile.exists()) {
                if (this.lastPropFileDiag.isMakeActive()) {
                    if (!this.lastPropFileDiag.isAddConfiguration()) {
                        TraceConfigUIPreferencePage.resetLogging();
                    }
                    TraceConfigUIPreferencePage.configureLogging(configFile);
                }
                if (this.lastPropFileDiag.isMakeDefault()) {
                    this.saveAsDefaultConfig(configFile);
                }
            } else {
                String msg = configFile != null ? "Unable to load file " + configFile.getAbsolutePath() : "No Property File selected";
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)msg);
            }
        } else if (leaveOkAnswer == null) {
            this.activateConfig();
            this.makeConfigDefault();
            this.savePreferences();
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"TraceConfiguration Page not ready to leave", (String)leaveOkAnswer);
        }
        return leaveOkAnswer == null;
    }

    public boolean isValid() {
        return this.okToLeave();
    }

    public boolean okToLeave() {
        return this.isConfifECReadyToLeave() == null;
    }

    private String isConfifECReadyToLeave() {
        return this.traceConfigEC.okToLeave();
    }

    public static void setAsDefaultTraceConfFile(String path) {
        Plugin utilPlugin;
        String utilPluginID = Util.getPluginID((Class)(class$com$tssap$util$UtilPlugin == null ? (class$com$tssap$util$UtilPlugin = TraceConfigUIPreferencePage.class$("com.tssap.util.UtilPlugin")) : class$com$tssap$util$UtilPlugin));
        if (utilPluginID != null && path != null && (utilPlugin = Platform.getPlugin((String)utilPluginID)) != null) {
            IPath metaPath = Platform.getPluginStateLocation((Plugin)utilPlugin);
            String traceConfFileName = metaPath.toOSString() + "/" + "traceconfig.dat";
            Properties prop = new Properties();
            ((Hashtable)prop).put("TraceConfigFile", path);
            try {
                prop.store(new FileOutputStream(traceConfFileName), "");
            }
            catch (FileNotFoundException e) {
                tracer.error("Error saving settings as default to file " + path, (Throwable)e);
            }
            catch (IOException e) {
                tracer.error("Error saving settings as default to file " + path, (Throwable)e);
            }
        }
    }

    protected static void resetLogControler(LogController controler) {
        controler.setEffectiveSeverity();
        controler.removeLogs();
        Collection childCollection = controler.getChildren();
        LogController[] children = childCollection.toArray(new LogController[0]);
        int i = 0;
        while (i < children.length) {
            TraceConfigUIPreferencePage.resetLogControler(children[i]);
            ++i;
        }
    }

    protected static void resetLogging() {
        Location.getRoot().setEffectiveSeverity(701);
        Category.getRoot().setEffectiveSeverity(701);
        TraceConfigUIPreferencePage.resetLogControler((LogController)Location.getRoot());
        TraceConfigUIPreferencePage.resetLogControler((LogController)Category.getRoot());
    }

    protected static void activateLogProperties(Properties configProps) {
        PlatformLogListener.activate((boolean)true);
        TraceConfigUIPreferencePage.resetLogging();
        TraceConfigUIPreferencePage.configureLogging(configProps);
    }

    protected static void configureLogging(Properties configProps) {
        PropertiesConfigurator pc = new PropertiesConfigurator(configProps);
        pc.setClassLoader(ToolsUIPlugin.getDefault().getDescriptor().getPluginClassLoader());
        pc.configure();
    }

    protected static void configureLogging(File configFile) {
        PropertiesConfigurator pc = new PropertiesConfigurator(configFile);
        pc.setClassLoader(ToolsUIPlugin.getDefault().getDescriptor().getPluginClassLoader());
        pc.configure();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void saveAsDefaultConfig(Properties configProps) {
        File f = TraceConfigUIPreferencePage.getConfigManagerDataFile();
        if (f == null) return;
        File propFile = new File(f.getParentFile(), CURRENT_TRACE_CONFIG_FILENAME);
        FileOutputStream out = null;
        out = new FileOutputStream(propFile);
        configProps.store(out, "");
        TraceConfigUIPreferencePage.setAsDefaultTraceConfFile(propFile.getAbsolutePath());
        Object var7_4 = null;
        if (out == null) return;
        try {
            ((OutputStream)out).close();
            return;
        }
        catch (IOException e1) {}
        return;
        {
            catch (FileNotFoundException e) {
                tracer.error("", (Throwable)e);
                Object var7_5 = null;
                if (out == null) return;
                try {
                    ((OutputStream)out).close();
                    return;
                }
                catch (IOException e1) {}
                return;
            }
            catch (IOException e) {
                tracer.error("", (Throwable)e);
                Object var7_6 = null;
                if (out == null) return;
                try {
                    ((OutputStream)out).close();
                    return;
                }
                catch (IOException e1) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (out == null) throw throwable;
            try {
                ((OutputStream)out).close();
                throw throwable;
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected void saveAsDefaultConfig(File configFile) {
        File f = TraceConfigUIPreferencePage.getConfigManagerDataFile();
        if (f != null) {
            File propFile = new File(f.getParentFile(), CURRENT_TRACE_CONFIG_FILENAME);
            try {
                TraceConfigUIPreferencePage.copyFile(configFile, propFile);
                TraceConfigUIPreferencePage.setAsDefaultTraceConfFile(propFile.getAbsolutePath());
            }
            catch (Exception e) {
                tracer.error("Error copying log property file:", (Throwable)e);
            }
        }
    }

    private static void copyFile(File configFile, File propFile) throws IOException {
        FileOutputStream out = null;
        FileInputStream in = null;
        try {
            in = new FileInputStream(configFile);
            out = new FileOutputStream(propFile);
            int bufSize = 1024;
            int read = 0;
            byte[] buffer = new byte[bufSize];
            while ((read = in.read(buffer, 0, bufSize)) > 0) {
                out.write(buffer, 0, read);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                tracer.warning("Unable to close stream", (Throwable)e);
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                tracer.warning("Unable to close stream", (Throwable)e);
            }
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            tracer.warning("Unable to close stream", (Throwable)e);
        }
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e) {
            tracer.warning("Unable to close stream", (Throwable)e);
        }
    }

    protected static File getConfigManagerDataFile() {
        Plugin toolsUIPlugin;
        File ret = null;
        String toolsUIPluginID = Util.getPluginID((Class)(class$com$tssap$tools$ui$ToolsUIPlugin == null ? (class$com$tssap$tools$ui$ToolsUIPlugin = TraceConfigUIPreferencePage.class$("com.tssap.tools.ui.ToolsUIPlugin")) : class$com$tssap$tools$ui$ToolsUIPlugin));
        if (toolsUIPluginID != null && (toolsUIPlugin = Platform.getPlugin((String)toolsUIPluginID)) != null) {
            IPath metaPath = Platform.getPluginStateLocation((Plugin)toolsUIPlugin);
            ret = new File(metaPath.toOSString() + "/" + CONFIG_MANAGER_DAT_FILENAME);
        }
        return ret;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return TraceConfigUIPreferencePage.getTracePreferencePrefstore();
    }

    protected static IPreferenceStore getTracePreferencePrefstore() {
        PreferenceStore ret;
        block7: {
            String myPluginID = Util.getPluginID((Class)(class$com$tssap$tools$ui$preferences$trace$TraceConfigUIPreferencePage == null ? (class$com$tssap$tools$ui$preferences$trace$TraceConfigUIPreferencePage = TraceConfigUIPreferencePage.class$("com.tssap.tools.ui.preferences.trace.TraceConfigUIPreferencePage")) : class$com$tssap$tools$ui$preferences$trace$TraceConfigUIPreferencePage));
            if (myPluginID != null) {
                Plugin myPlugin = Platform.getPlugin((String)myPluginID);
                if (myPlugin != null) {
                    IPath metaPath = Platform.getPluginStateLocation((Plugin)myPlugin);
                    String prefStoreFilename = metaPath.toOSString() + "/" + PREFSTORE_FILENAME;
                    ret = new PreferenceStore(prefStoreFilename);
                    try {
                        File f = new File(prefStoreFilename);
                        if (f.exists()) {
                            ret.load();
                            break block7;
                        }
                        tracer.info("Preference store file does not exist");
                    }
                    catch (IOException e) {
                        tracer.warning("Unable to load preference store", (Throwable)e);
                    }
                } else {
                    ret = new PreferenceStore();
                }
            } else {
                ret = new PreferenceStore();
            }
        }
        return ret;
    }

    private Properties loadProperties(File f) {
        Properties props = null;
        if (f != null && f.exists() && f.isFile()) {
            try {
                FileInputStream in = new FileInputStream(f);
                props = new Properties();
                props.load(in);
            }
            catch (FileNotFoundException e) {
                tracer.error("", (Throwable)e);
                props = null;
            }
            catch (IOException e) {
                tracer.error("", (Throwable)e);
                props = null;
            }
        }
        return props;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    abstract class MySelectionAdapter
    implements SelectionListener {
        MySelectionAdapter() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.handleSelection();
        }

        public void widgetSelected(SelectionEvent e) {
            this.handleSelection();
        }

        public abstract void handleSelection();
    }
}

