/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.ui.preferences.trace;

import com.tssap.tools.ui.preferences.trace.TraceConfigUIPreferencePage;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISimplePane;
import com.tssap.util.ui.pane.PaneFactory;
import com.tssap.util.ui.reuse.chooser.IChooser;
import com.tssap.util.ui.reuse.chooser.IDropDownSelector;
import com.tssap.util.ui.reuse.chooser.impl.DropDownSelector;
import com.tssap.util.ui.reuse.chooser.impl.FileChooser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

public class PropertyFileConfigDialog
extends SelectionDialog {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$tools$ui$preferences$trace$PropertyFileConfigDialog == null ? (class$com$tssap$tools$ui$preferences$trace$PropertyFileConfigDialog = PropertyFileConfigDialog.class$("com.tssap.tools.ui.preferences.trace.PropertyFileConfigDialog")) : class$com$tssap$tools$ui$preferences$trace$PropertyFileConfigDialog));
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 400;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 300;
    private static final String DIAG_TITLE = "Logging Property File Selector";
    private static final String DIAG_MSG = "";
    private Text textField;
    private IDropDownSelector dds;
    private Button butSaveChanges;
    private Button butOpenFile;
    private static final String PREFSTORE_FILENAME = "TraceConfigPreference.pref";
    private Button butActivate;
    private Button butMakeDefault;
    private Button radioReplaceConfig;
    private Button radioAddConfig;
    private boolean isOkToLeave;
    private boolean makeDefault = false;
    private boolean makeActive = true;
    private File selectedFile;
    private boolean addConfiguration = false;
    static /* synthetic */ Class class$com$tssap$tools$ui$preferences$trace$PropertyFileConfigDialog;

    protected PropertyFileConfigDialog(Shell parentShell) {
        super(parentShell);
        this.setMessage(DIAG_MSG);
        this.setTitle(DIAG_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        this.createSelectionPane(composite);
        return composite;
    }

    protected Control createSelectionPane(Composite parent) {
        IGridLayoutPane grdpane = PaneFactory.createGridLayoutPane((Composite)parent, (int)1);
        this.createFileSelector(grdpane);
        Text txtField = this.createTextEditor(grdpane);
        GridData data = new GridData(1808);
        data.widthHint = 400;
        data.heightHint = 300;
        txtField.setLayoutData((Object)data);
        this.createActivateButtonGroup(grdpane, grdpane.createGridLayoutData(1, 1));
        this.initPreferences();
        return grdpane.getComposite();
    }

    private void initPreferences() {
        IPreferenceStore prefStore = TraceConfigUIPreferencePage.getTracePreferencePrefstore();
        int historyLength = prefStore.getInt("HistoryLength");
        String[] historyPaths = new String[historyLength];
        int i = 0;
        while (i < historyLength) {
            historyPaths[i] = prefStore.getString("HistoryEntry" + i);
            ++i;
        }
        this.dds.setHistory(historyPaths);
        if (this.addConfiguration) {
            this.radioAddConfig.setSelection(true);
        } else {
            this.radioReplaceConfig.setSelection(true);
        }
        this.butActivate.setSelection(this.makeActive);
        this.butMakeDefault.setSelection(this.makeDefault);
    }

    private void savePreferences() {
        IPreferenceStore prefStore = TraceConfigUIPreferencePage.getTracePreferencePrefstore();
        String[] historyPaths = this.dds.getHistory();
        prefStore.setValue("HistoryLength", historyPaths.length);
        int i = 0;
        while (i < historyPaths.length) {
            prefStore.setValue("HistoryEntry" + i, historyPaths[i]);
            ++i;
        }
        try {
            ((PreferenceStore)prefStore).save();
        }
        catch (Exception e) {
            tracer.error("Unable to save trace preferences", (Throwable)e);
        }
    }

    private Text createTextEditor(IGridLayoutPane parentGridPane) {
        IGridLayoutData griddata = parentGridPane.createGridLayoutData(4, 4, true, true);
        this.textField = parentGridPane.addTextPane(DIAG_MSG, true, griddata);
        this.textField.setText(DIAG_MSG);
        this.textField.setEditable(false);
        return this.textField;
    }

    private void createFileSelector(IGridLayoutPane parentGridPane) {
        FileChooser pushButtonChooser = new FileChooser(0);
        ModifyListener ml = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PropertyFileConfigDialog.this.handleSourceFileTextChanged(e);
            }
        };
        ISimplePane simplePane = parentGridPane.addSimplePane(parentGridPane.createGridLayoutData(4, 4, true, false));
        this.dds = new DropDownSelector(8);
        this.dds.setSelectorDescription("Configuration file ");
        this.dds.setDescriptionPositionLeft(false);
        this.dds.setReadOnly(false);
        this.dds.setButtonText("Browse");
        this.dds.setHasPushButton(true);
        this.dds.setPushButtonChooser((IChooser)pushButtonChooser);
        this.dds.addModifyListener(ml);
        this.dds.createPartControl(simplePane.getComposite());
    }

    private void createActivateButtonGroup(IGridLayoutPane pane, IGridLayoutData gridData) {
        IGridLayoutPane activateButPane = pane.addGridLayoutPane(2, gridData);
        this.butActivate = activateButPane.addCheckBox("Activate this configuration");
        this.butActivate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyFileConfigDialog.this.handleActivateChecked();
            }
        });
        activateButPane.addPlaceholder(1, 1);
        this.radioReplaceConfig = activateButPane.addRadioButton("Replace Configuration");
        this.radioReplaceConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyFileConfigDialog.this.handleRadioReplace();
            }
        });
        this.radioAddConfig = activateButPane.addRadioButton("Add Configuration");
        this.radioAddConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyFileConfigDialog.this.handleRadioAdd();
            }
        });
        activateButPane.addPlaceholder(2, 1);
        this.butMakeDefault = activateButPane.addCheckBox("Set as startup configuration");
        this.butMakeDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyFileConfigDialog.this.handleMakedefaultChecked();
            }
        });
    }

    private void handleRadioReplace() {
        this.addConfiguration = !this.radioReplaceConfig.getSelection();
    }

    private void handleRadioAdd() {
        this.addConfiguration = this.radioAddConfig.getSelection();
    }

    private void handleMakedefaultChecked() {
        this.makeDefault = this.butMakeDefault.getSelection();
    }

    private void handleActivateChecked() {
        this.makeActive = this.butActivate.getSelection();
    }

    public void okPressed() {
        this.savePreferences();
        if (this.isOkToLeave()) {
            super.okPressed();
        }
    }

    private void handleSourceFileTextChanged(ModifyEvent e) {
        String newSelection = this.dds.getText();
        File f = new File(newSelection);
        if (f.exists() && f.isFile()) {
            this.selectedFile = f;
            this.textField.setText(this.getTextStringFromFile(f));
            this.dds.addSelectionToHistory();
            this.setIsOkToLeave(true);
        } else {
            this.textField.setText("Choose configuration file");
            this.setIsOkToLeave(false);
        }
    }

    private void setIsOkToLeave(boolean b) {
        this.isOkToLeave = b;
        Button okBut = this.getButton(0);
        if (okBut != null && !okBut.isDisposed()) {
            okBut.setEnabled(this.isOkToLeave);
        }
    }

    private String getTextStringFromFile(File f) {
        String ret = DIAG_MSG;
        if (f.exists() && f.isFile()) {
            try {
                FileInputStream fIn = new FileInputStream(f);
                if (f.length() > 64000L) {
                    ret = "The selected File is not show because it is longer than 64kB. ";
                } else {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    int bufSize = 1024;
                    byte[] readBuffer = new byte[bufSize];
                    int readCount = 0;
                    while ((readCount = fIn.read(readBuffer, 0, bufSize)) > 0) {
                        out.write(readBuffer, 0, readCount);
                    }
                    ret = out.toString();
                }
            }
            catch (FileNotFoundException ex) {
                ret = "Error: " + ex.getMessage();
            }
            catch (IOException ex) {
                ret = "Error: " + ex.getMessage();
            }
        }
        return ret;
    }

    private boolean isOkToLeave() {
        return this.isOkToLeave;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return TraceConfigUIPreferencePage.getTracePreferencePrefstore();
    }

    public boolean isAddConfiguration() {
        return this.addConfiguration;
    }

    public boolean isMakeActive() {
        return this.makeActive;
    }

    public boolean isMakeDefault() {
        return this.makeDefault;
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

