/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.ui.plugindep;

import com.tssap.tools.plugindep.IPlugin;
import com.tssap.tools.plugindep.IPluginManager;
import com.tssap.tools.plugindep.impl.PluginImpl;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class BuildOrderContentProvider
implements ITreeContentProvider {
    private ArrayList buildOrder = new ArrayList();
    private IPluginManager ipm = null;

    public BuildOrderContentProvider(IPluginManager ipm) {
        this.ipm = ipm;
    }

    public Object[] getChildren(Object parentElement) {
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    public Object[] getElements(Object inputElement) {
        this.createBuildOrder();
        return this.buildOrder.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private void createBuildOrder() {
        this.buildOrder.clear();
        IPlugin[] allPlugins = this.ipm.getAllPlugins();
        HashMap<String, IPlugin> map = new HashMap<String, IPlugin>();
        int i = 0;
        while (i < allPlugins.length) {
            map.put(allPlugins[i].getID(), allPlugins[i]);
            ++i;
        }
        while (map.values().size() > 0) {
            String[] ids = map.keySet().toArray(new String[0]);
            int i2 = 0;
            while (i2 < ids.length) {
                IPlugin p = (IPlugin)map.get(ids[i2]);
                if (p != null) {
                    if (p instanceof PluginImpl && !((PluginImpl)p).hasDescription()) {
                        map.remove(p.getID());
                    } else {
                        IPlugin[] req = p.getRequiredPlugins();
                        boolean notFound = false;
                        int j = 0;
                        while (j < req.length) {
                            if (req[j] instanceof PluginImpl && !((PluginImpl)req[j]).hasDescription()) {
                                map.remove(req[j].getID());
                            } else if (!this.buildOrder.contains(req[j])) {
                                notFound = true;
                            }
                            ++j;
                        }
                        if (!notFound) {
                            this.buildOrder.add(p);
                            map.remove(p.getID());
                        }
                    }
                }
                ++i2;
            }
        }
    }

    public void saveBuildOrder(String file) {
        try {
            FileWriter f = new FileWriter(new File(file));
            int i = 0;
            while (i < this.buildOrder.size()) {
                IPlugin p = (IPlugin)this.buildOrder.get(i);
                f.write(p.getID() + ",\n");
                ++i;
            }
            f.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

