/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.ui.addlib.internal;

import com.tssap.tools.addlib.AddLibManager;
import com.tssap.tools.addlib.IAddLib;
import com.tssap.tools.addlib.IAddLibDefinition;
import com.tssap.tools.addlib.IAddLibManager;
import com.tssap.tools.addlib.ILibraryProjectAddLib;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class AddLibTreeManager
extends LabelProvider
implements ITreeContentProvider {
    private IAddLibManager addLibMan;
    private Vector rootNodes;
    private Vector unselectableNodes;
    private Vector preselectableNodes;
    private Hashtable addLibNodes;
    private boolean onlyLibraries;

    public AddLibTreeManager(IAddLibManager manager, boolean onlyLibraries) {
        this.addLibMan = manager;
        this.onlyLibraries = onlyLibraries;
        this.rootNodes = new Vector();
        this.unselectableNodes = new Vector();
        this.preselectableNodes = new Vector();
        this.addLibNodes = new Hashtable();
        this.initModel(manager, this.rootNodes, this.unselectableNodes, this.preselectableNodes);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof InnerTreeNode) {
            InnerTreeNode treeNode = (InnerTreeNode)parentElement;
            return treeNode.getChildren();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof InnerTreeNode) {
            InnerTreeNode treeNode = (InnerTreeNode)element;
            return treeNode.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof InnerTreeNode) {
            InnerTreeNode treeNode = (InnerTreeNode)element;
            return treeNode.hasChildren();
        }
        return false;
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        if (element instanceof InnerTreeNode) {
            InnerTreeNode treeNode = (InnerTreeNode)element;
            return treeNode.getText();
        }
        return "???";
    }

    public Object[] getElements(Object inputElement) {
        Object[] rootElements = this.getRooteNodes().toArray();
        return rootElements;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getUnselectableNodes() {
        Object[] unselNodes = this.unselectableNodes.toArray();
        return unselNodes;
    }

    public Object[] getPreselectableNodes() {
        Object[] preselNodes = this.preselectableNodes.toArray();
        return preselNodes;
    }

    public Object getAddLibNodeByDefinition(IAddLibDefinition addLibDefinition) {
        String hashKey = this.computeHashKey(addLibDefinition);
        return this.addLibNodes.get(hashKey);
    }

    public IAddLib getAddLibForNode(Object node) {
        Object nodeData;
        IAddLib addLibNode = null;
        if (node instanceof InnerTreeNode && (nodeData = ((InnerTreeNode)node).getData()) instanceof IAddLib) {
            addLibNode = (IAddLib)nodeData;
        }
        return addLibNode;
    }

    private Vector getRooteNodes() {
        return this.rootNodes;
    }

    private void initModel(IAddLibManager manager, Vector rootNodeVec, Vector unselNodes, Vector preselNodes) {
        IAddLib[] allAddLibs = manager.getAddLibs();
        IAddLib[] prjAddLibs = AddLibManager.getAddLibsByType((int)1, (IAddLib[])allAddLibs);
        IAddLib[] engineAddLibs = AddLibManager.getAddLibsByType((int)2, (IAddLib[])allAddLibs);
        IAddLib[] systemAddLibs = AddLibManager.getAddLibsByType((int)3, (IAddLib[])allAddLibs);
        InnerTreeNode prjRoot = new InnerTreeNode(null, "Library Projects", "Library Projects");
        InnerTreeNode engineRoot = new InnerTreeNode(null, "Engine Libraries", "Engine Libraries");
        InnerTreeNode sysRoot = new InnerTreeNode(null, "Installed Libraries", "Installed Libraries");
        rootNodeVec.add(prjRoot);
        this.unselectableNodes.add(prjRoot);
        if (engineAddLibs.length > 0) {
            rootNodeVec.add(engineRoot);
            this.unselectableNodes.add(engineRoot);
        }
        rootNodeVec.add(sysRoot);
        this.unselectableNodes.add(sysRoot);
        this.addChildren(prjRoot, prjAddLibs, unselNodes, preselNodes);
        this.addChildren(engineRoot, engineAddLibs, unselNodes, preselNodes);
        this.addChildren(sysRoot, systemAddLibs, unselNodes, preselNodes);
    }

    private void addChildren(InnerTreeNode rootNode, IAddLib[] libs, Vector unselNodes, Vector preselNodes) {
        String[] vendors = AddLibManager.getAddLibVendors((IAddLib[])libs);
        InnerTreeNode[] vendorNodes = new InnerTreeNode[vendors.length];
        int v = 0;
        while (v < vendors.length) {
            String vendor = vendors[v];
            InnerTreeNode vendorRootNode = new InnerTreeNode(rootNode, vendor, null);
            unselNodes.add(vendorRootNode);
            vendorNodes[v] = vendorRootNode;
            IAddLib[] vendorLibs = AddLibManager.getAddLibsByVendor((String)vendor, (IAddLib[])libs);
            ArrayList<InnerTreeNode> libNodes = new ArrayList<InnerTreeNode>(vendorLibs.length);
            int vl = 0;
            while (vl < vendorLibs.length) {
                IAddLib lib = vendorLibs[vl];
                if (!this.onlyLibraries || lib.getSubType() == 2) {
                    InnerTreeNode libNode = new InnerTreeNode(vendorRootNode, lib.getName(), lib);
                    libNodes.add(libNode);
                    String libNodeHashkey = this.computeHashKey((IAddLibDefinition)lib);
                    this.addLibNodes.put(libNodeHashkey, libNode);
                    preselNodes.add(libNode);
                    if (lib.getAddLibType() == 3 || lib.getAddLibType() == 2) {
                        IPath[] jars = lib.getClassPathJars();
                        InnerTreeNode[] jarNodes = new InnerTreeNode[jars.length];
                        int jl = 0;
                        while (jl < jars.length) {
                            IPath jarPath = jars[jl];
                            jarNodes[jl] = new InnerTreeNode(libNode, jarPath.toString(), jarPath);
                            unselNodes.add(jarNodes[jl]);
                            ++jl;
                        }
                        libNode.setChildren(jarNodes);
                    } else if (lib.getAddLibType() == 1) {
                        InnerTreeNode prjNode = new InnerTreeNode(libNode, "Project: " + ((ILibraryProjectAddLib)lib).getLibraryProject().getName(), lib);
                        unselNodes.add(prjNode);
                        libNode.setChildren(new InnerTreeNode[]{prjNode});
                    }
                }
                ++vl;
            }
            InnerTreeNode[] libNodesArray = new InnerTreeNode[libNodes.size()];
            libNodes.toArray(libNodesArray);
            vendorRootNode.setChildren(libNodesArray);
            rootNode.setChildren(vendorNodes);
            ++v;
        }
    }

    private String computeHashKey(IAddLibDefinition definition) {
        return definition.getVendor() + ":" + definition.getName();
    }

    private class InnerTreeNode {
        private InnerTreeNode nodeParent;
        private InnerTreeNode[] nodeChildren;
        private String nodeText;
        private Object nodeUserObject;

        public InnerTreeNode(InnerTreeNode parent, String text, Object userObject) {
            this.nodeParent = parent;
            this.nodeChildren = new InnerTreeNode[0];
            this.nodeText = text;
            this.nodeUserObject = userObject;
        }

        public Object getParent() {
            return this.nodeParent;
        }

        public Object[] getChildren() {
            return this.nodeChildren;
        }

        public void setChildren(InnerTreeNode[] children) {
            this.nodeChildren = children;
        }

        public boolean hasChildren() {
            return this.nodeChildren.length > 0;
        }

        public String getText() {
            return this.nodeText;
        }

        public Object getData() {
            return this.nodeUserObject;
        }
    }
}

