/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.ui.addlib.dialog;

import com.tssap.tools.addlib.IAddLib;
import com.tssap.tools.addlib.IAddLibDefinition;
import com.tssap.tools.addlib.IAddLibManager;
import com.tssap.tools.ui.addlib.internal.AddLibTreeManager;
import com.tssap.util.ui.dialog.StructuredObjectSelectionDialog;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Shell;

public class AddLibSelectionDialog {
    private AddLibSelectionDialog() {
    }

    public static IAddLib[] openSelection(Shell shell, IAddLibManager manager, IAddLibDefinition[] unselectable, IAddLibDefinition[] preselected) {
        return AddLibSelectionDialog.openSelection(shell, manager, unselectable, preselected, false);
    }

    public static IAddLib[] openSelection(Shell shell, IAddLibManager manager, IAddLibDefinition[] unselectable, IAddLibDefinition[] preselected, boolean onlyLibraries) {
        if (preselected == null) {
            preselected = new IAddLibDefinition[]{};
        }
        if (unselectable == null) {
            unselectable = new IAddLibDefinition[]{};
        }
        AddLibTreeManager addLibTM = new AddLibTreeManager(manager, onlyLibraries);
        Vector<Object> preselectedObjectVec = new Vector<Object>();
        int pre = 0;
        while (pre < preselected.length) {
            IAddLibDefinition ald = preselected[pre];
            Object preselObject = addLibTM.getAddLibNodeByDefinition(ald);
            if (preselObject != null) {
                preselectedObjectVec.add(preselObject);
            }
            ++pre;
        }
        Object[] preselectedObjects = preselectedObjectVec.toArray();
        Vector<Object> unselectedObjectVec = new Vector<Object>();
        int i = 0;
        while (i < unselectable.length) {
            Object unselObject = addLibTM.getAddLibNodeByDefinition(unselectable[i]);
            if (unselObject != null) {
                unselectedObjectVec.add(unselObject);
            }
            ++i;
        }
        unselectedObjectVec.addAll(Arrays.asList(addLibTM.getUnselectableNodes()));
        Object[] unselectableObjects = unselectedObjectVec.toArray();
        String title = onlyLibraries ? "J2EE libraries" : "J2EE libraries/interfaces/service";
        StructuredObjectSelectionDialog sosd = new StructuredObjectSelectionDialog(shell, title, "Please select");
        sosd.setLabelProvider((ILabelProvider)addLibTM);
        sosd.setPreSelectedObjects(preselectedObjects);
        sosd.setTreeInput((Object)"");
        sosd.setExpandTreeLevel(3);
        Object[] selectedObj = sosd.openPreFilteredDialog((ITreeContentProvider)addLibTM, unselectableObjects);
        IAddLib[] selectedAddLibs = null;
        if (selectedObj != null) {
            Vector<IAddLib> addLibVec = new Vector<IAddLib>();
            int so = 0;
            while (so < selectedObj.length) {
                Object selObject = selectedObj[so];
                IAddLib addLib = addLibTM.getAddLibForNode(selObject);
                if (addLib != null) {
                    addLibVec.add(addLib);
                }
                ++so;
            }
            selectedAddLibs = addLibVec.toArray(new IAddLib[0]);
        }
        return selectedAddLibs;
    }
}

